/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.FormattingOptions;
import com.facebook.ktfmt.format.Parser;
import com.facebook.ktfmt.format.RedundantElementManager;
import com.facebook.ktfmt.format.RedundantImportDetector;
import com.facebook.ktfmt.format.RedundantSemicolonDetector;
import com.facebook.ktfmt.format.TrailingCommas;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocImpl;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/facebook/ktfmt/format/RedundantElementManager;", "", "()V", "addRedundantElements", "", "code", "options", "Lcom/facebook/ktfmt/format/FormattingOptions;", "dropRedundantElements", "containsNewline", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nRedundantElementManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantElementManager.kt\ncom/facebook/ktfmt/format/RedundantElementManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1054#2:125\n1054#2:126\n*S KotlinDebug\n*F\n+ 1 RedundantElementManager.kt\ncom/facebook/ktfmt/format/RedundantElementManager\n*L\n79#1:125\n112#1:126\n*E\n"})
public final class RedundantElementManager {
    @NotNull
    public static final RedundantElementManager INSTANCE = new RedundantElementManager();

    private RedundantElementManager() {
    }

    @NotNull
    public final String dropRedundantElements(@NotNull String code, @NotNull FormattingOptions options) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        KtFile file = Parser.INSTANCE.parse(code);
        RedundantImportDetector redundantImportDetector = new RedundantImportDetector(options.getRemoveUnusedImports());
        RedundantSemicolonDetector redundantSemicolonDetector = new RedundantSemicolonDetector();
        TrailingCommas.Detector trailingCommaDetector = new TrailingCommas.Detector();
        file.accept((PsiElementVisitor)new KtTreeVisitorVoid(redundantImportDetector, redundantSemicolonDetector, options, trailingCommaDetector){
            final /* synthetic */ RedundantImportDetector $redundantImportDetector;
            final /* synthetic */ RedundantSemicolonDetector $redundantSemicolonDetector;
            final /* synthetic */ FormattingOptions $options;
            final /* synthetic */ TrailingCommas.Detector $trailingCommaDetector;
            {
                this.$redundantImportDetector = $redundantImportDetector;
                this.$redundantSemicolonDetector = $redundantSemicolonDetector;
                this.$options = $options;
                this.$trailingCommaDetector = $trailingCommaDetector;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KDocImpl) {
                    this.$redundantImportDetector.takeKdoc((KDocImpl)element);
                    return;
                }
                this.$redundantSemicolonDetector.takeElement(element);
                if (this.$options.getManageTrailingCommas()) {
                    this.$trailingCommaDetector.takeElement(element);
                }
                super.visitElement(element);
            }

            public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                this.$redundantImportDetector.takePackageDirective(directive, (Function0<Unit>)((Function0)new Function0<Unit>(this, directive){
                    final /* synthetic */ dropRedundantElements.1 this$0;
                    final /* synthetic */ KtPackageDirective $directive;
                    {
                        this.this$0 = $receiver;
                        this.$directive = $directive;
                        super(0);
                    }

                    public final void invoke() {
                        dropRedundantElements.1.access$visitPackageDirective$s882885595(this.this$0, this.$directive);
                    }
                }));
            }

            public void visitImportList(@NotNull KtImportList importList) {
                Intrinsics.checkNotNullParameter((Object)importList, (String)"importList");
                this.$redundantImportDetector.takeImportList(importList, (Function0<Unit>)((Function0)new Function0<Unit>(this, importList){
                    final /* synthetic */ dropRedundantElements.1 this$0;
                    final /* synthetic */ KtImportList $importList;
                    {
                        this.this$0 = $receiver;
                        this.$importList = $importList;
                        super(0);
                    }

                    public final void invoke() {
                        dropRedundantElements.1.access$visitImportList$s882885595(this.this$0, this.$importList);
                    }
                }));
            }

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.$redundantImportDetector.takeReferenceExpression(expression);
                super.visitReferenceExpression(expression);
            }

            public static final /* synthetic */ void access$visitPackageDirective$s882885595(dropRedundantElements.1 $this, KtPackageDirective p0) {
                super.visitPackageDirective(p0);
            }

            public static final /* synthetic */ void access$visitImportList$s882885595(dropRedundantElements.1 $this, KtImportList p0) {
                super.visitImportList(p0);
            }
        });
        StringBuilder result2 = new StringBuilder(code);
        List elementsToRemove = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)redundantSemicolonDetector.getRedundantSemicolonElements(), (Iterable)redundantImportDetector.getRedundantImportElements()), (Iterable)trailingCommaDetector.getTrailingCommaElements());
        Iterable $this$sortedByDescending$iv = elementsToRemove;
        boolean $i$f$sortedByDescending = false;
        for (PsiElement element : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PsiElement p0 = (PsiElement)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)p0));
                p0 = (PsiElement)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)p0)));
            }
        })) {
            String replacement = Intrinsics.areEqual((Object)element.getText(), (Object)";") && !this.containsNewline(element.getNextSibling()) ? "\n" : "";
            result2.replace(PsiUtilsKt.getStartOffset((PsiElement)element), PsiUtilsKt.getEndOffset((PsiElement)element), replacement);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public final String addRedundantElements(@NotNull String code, @NotNull FormattingOptions options) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!options.getManageTrailingCommas()) {
            return code;
        }
        KtFile file = Parser.INSTANCE.parse(code);
        TrailingCommas.Suggestor trailingCommaSuggestor = new TrailingCommas.Suggestor();
        file.accept((PsiElementVisitor)new KtTreeVisitorVoid(trailingCommaSuggestor){
            final /* synthetic */ TrailingCommas.Suggestor $trailingCommaSuggestor;
            {
                this.$trailingCommaSuggestor = $trailingCommaSuggestor;
            }

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.$trailingCommaSuggestor.takeElement(element);
                super.visitElement((PsiElement)element);
            }
        });
        StringBuilder result2 = new StringBuilder(code);
        List<PsiElement> suggestionElements = trailingCommaSuggestor.getTrailingCommaSuggestions();
        Iterable $this$sortedByDescending$iv = suggestionElements;
        boolean $i$f$sortedByDescending = false;
        for (PsiElement element : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PsiElement p0 = (PsiElement)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)p0));
                p0 = (PsiElement)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)p0)));
            }
        })) {
            result2.insert(PsiUtilsKt.getEndOffset((PsiElement)element), ',');
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final boolean containsNewline(PsiElement $this$containsNewline) {
        if (!($this$containsNewline instanceof PsiWhiteSpace)) {
            return false;
        }
        String string = ((PsiWhiteSpace)$this$containsNewline).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.text");
        return StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null);
    }
}

