/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.EnumEntryList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/ktfmt/format/RedundantSemicolonDetector;", "", "()V", "extraSemicolons", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getRedundantSemicolonElements", "", "isExtraSemicolon", "", "element", "takeElement", "", "ktfmt"})
public final class RedundantSemicolonDetector {
    @NotNull
    private final List<PsiElement> extraSemicolons = new ArrayList();

    @NotNull
    public final List<PsiElement> getRedundantSemicolonElements() {
        return this.extraSemicolons;
    }

    public final void takeElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isExtraSemicolon(element)) {
            ((Collection)this.extraSemicolons).add(element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExtraSemicolon(PsiElement element) {
        PsiElement nextConcreteSibling;
        if (!Intrinsics.areEqual((Object)element.getText(), (Object)";")) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof KtStringTemplateExpression) return false;
        if (parent instanceof KtStringTemplateEntry) {
            return false;
        }
        if (parent instanceof KtEnumEntry) {
            PsiElement psiElement = ((KtEnumEntry)parent).getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassBody");
            KtClassBody classBody = (KtClassBody)psiElement;
            PsiElement[] psiElementArray = classBody.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"classBody.children");
            return Intrinsics.areEqual((Object)ArraysKt.last((Object[])psiElementArray), (Object)parent);
        }
        if (parent instanceof KtClassBody) {
            EnumEntryList enumEntryList = EnumEntryList.Companion.extractChildList((KtClassBody)parent);
            if (enumEntryList == null) {
                return true;
            }
            EnumEntryList enumEntryList2 = enumEntryList;
            if (!Intrinsics.areEqual((Object)element, (Object)enumEntryList2.getTerminatingSemicolon())) return true;
            PsiElement[] psiElementArray = ((KtClassBody)parent).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"parent.children");
            if (((Object[])psiElementArray).length != 0) return false;
            return true;
        }
        PsiElement prevLeaf = PsiUtilsKt.prevLeaf((PsiElement)element, (boolean)false);
        PsiElement prevConcreteSibling = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)element, (boolean)false, (int)1, null);
        if ((prevConcreteSibling instanceof KtIfExpression || prevConcreteSibling instanceof KtWhileExpression) && prevLeaf instanceof KtContainerNodeForControlStructureBody) {
            String string = ((KtContainerNodeForControlStructureBody)prevLeaf).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prevLeaf.text");
            if (((CharSequence)string).length() == 0) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
        }
        if ((nextConcreteSibling = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)element, (boolean)false, (int)1, null)) instanceof KtLambdaExpression) return false;
        if (!(nextConcreteSibling instanceof KtDotQualifiedExpression)) return true;
        if (!(((KtDotQualifiedExpression)nextConcreteSibling).getReceiverExpression() instanceof KtLambdaExpression)) return true;
        return false;
    }
}

