/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.KDocFormattingOptions;
import com.facebook.ktfmt.kdoc.ParagraphListBuilderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000f\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a6\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007\u001a$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015\u001a*\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u0007\u001a\n\u0010\u001b\u001a\u00020\u0005*\u00020\u0005\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0005*\u00020\u0005\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u0005\u001a\n\u0010!\u001a\u00020 *\u00020\u0005\u001a\n\u0010\"\u001a\u00020 *\u00020\u0005\u001a\n\u0010#\u001a\u00020 *\u00020\u0005\u001a\u0014\u0010$\u001a\u00020 *\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u0007\u001a\n\u0010&\u001a\u00020 *\u00020\u0005\u001a\n\u0010'\u001a\u00020 *\u00020\u0005\u001a\n\u0010(\u001a\u00020 *\u00020\u0005\u001a?\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010+\"\u000e\b\u0001\u0010**\b\u0012\u0004\u0012\u0002H*0,*\b\u0012\u0004\u0012\u0002H+0-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u0002H*0\t\u00a2\u0006\u0002\u0010/\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"numberPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "computeIndents", "Lkotlin/Pair;", "", "start", "", "lookup", "Lkotlin/Function1;", "", "max", "findSamePosition", "comment", "delta", "reformattedComment", "getIndent", "width", "getIndentSize", "indent", "options", "Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;", "getLineNumber", "source", "offset", "startLine", "startOffset", "collapseSpaces", "getParamName", "getTagName", "tag", "isDirectiveMarker", "", "isExpectingMore", "isHeader", "isKDocTag", "isLine", "minCount", "isListItem", "isQuoted", "isTodo", "maxOf", "R", "T", "", "", "selector", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Comparable;", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utilities.kt\ncom/facebook/ktfmt/kdoc/UtilitiesKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,356:1\n214#2,5:357\n1099#2,3:362\n1099#2,3:365\n1064#2,2:368\n970#2:370\n1041#2,3:371\n*S KotlinDebug\n*F\n+ 1 Utilities.kt\ncom/facebook/ktfmt/kdoc/UtilitiesKt\n*L\n118#1:357,5\n127#1:362,3\n128#1:365,3\n235#1:368,2\n238#1:370\n238#1:371,3\n*E\n"})
public final class UtilitiesKt {
    private static final Pattern numberPattern = Pattern.compile("^\\d+([.)]) ");

    @NotNull
    public static final String getIndent(int width) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            sb.append(' ');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static final int getIndentSize(@NotNull String indent, @NotNull KDocFormattingOptions options) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        int size = 0;
        int n = indent.length();
        for (int i = 0; i < n; ++i) {
            char c = indent.charAt(i);
            if (c == '\t') {
                size += options.getTabWidth();
                continue;
            }
            ++size;
        }
        return size;
    }

    public static final int getLineNumber(@NotNull String source, int offset, int startLine, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int line2 = startLine;
        for (int i = startOffset; i < offset; ++i) {
            char c = source.charAt(i);
            if (c != '\n') continue;
            ++line2;
        }
        return line2;
    }

    public static /* synthetic */ int getLineNumber$default(String string, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return UtilitiesKt.getLineNumber(string, n, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isListItem(@NotNull String $this$isListItem) {
        Intrinsics.checkNotNullParameter((Object)$this$isListItem, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$isListItem, (String)"- ", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)$this$isListItem, (String)"* ", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)$this$isListItem, (String)"+ ", (boolean)false, (int)2, null)) return true;
        Character c = StringsKt.firstOrNull((CharSequence)$this$isListItem);
        boolean bl = c != null ? Character.isDigit(c.charValue()) : false;
        if (bl) {
            if (numberPattern.matcher($this$isListItem).find()) return true;
        }
        if (!StringsKt.startsWith((String)$this$isListItem, (String)"<li>", (boolean)true)) return false;
        return true;
    }

    @NotNull
    public static final String collapseSpaces(@NotNull String $this$collapseSpaces) {
        Intrinsics.checkNotNullParameter((Object)$this$collapseSpaces, (String)"<this>");
        if (StringsKt.indexOf$default((CharSequence)$this$collapseSpaces, (String)"  ", (int)0, (boolean)false, (int)6, null) == -1) {
            return ((Object)StringsKt.trimEnd((CharSequence)$this$collapseSpaces)).toString();
        }
        StringBuilder sb = new StringBuilder();
        char prev = $this$collapseSpaces.charAt(0);
        int n = $this$collapseSpaces.length();
        for (int i = 0; i < n; ++i) {
            if (prev == ' ' && $this$collapseSpaces.charAt(i) == ' ') continue;
            sb.append($this$collapseSpaces.charAt(i));
            prev = $this$collapseSpaces.charAt(i);
        }
        return ((Object)StringsKt.trimEnd((CharSequence)sb)).toString();
    }

    public static final boolean isTodo(@NotNull String $this$isTodo) {
        Intrinsics.checkNotNullParameter((Object)$this$isTodo, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isTodo, (String)"TODO:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isTodo, (String)"TODO(", (boolean)false, (int)2, null);
    }

    public static final boolean isHeader(@NotNull String $this$isHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$isHeader, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isHeader, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith((String)$this$isHeader, (String)"<h", (boolean)true);
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuoted, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isQuoted, (String)"> ", (boolean)false, (int)2, null);
    }

    public static final boolean isDirectiveMarker(@NotNull String $this$isDirectiveMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectiveMarker, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isDirectiveMarker, (String)"<!--", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isDirectiveMarker, (String)"-->", (boolean)false, (int)2, null);
    }

    public static final boolean isExpectingMore(@NotNull String $this$isExpectingMore) {
        Character c;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isExpectingMore, (String)"<this>");
            CharSequence $this$lastOrNull$iv = $this$isExpectingMore;
            boolean $i$f$lastOrNull = false;
            int n = $this$lastOrNull$iv.length() + -1;
            if (0 <= n) {
                do {
                    char element$iv;
                    int index$iv = n--;
                    char it = element$iv = $this$lastOrNull$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    c = Character.valueOf(element$iv);
                    break block3;
                } while (0 <= n);
            }
            c = null;
        }
        if (c == null) {
            return false;
        }
        char last = c.charValue();
        return last == ':' || last == ',';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isLine(@NotNull String $this$isLine, int minCount) {
        char it;
        char element$iv;
        int n;
        int count$iv;
        boolean $i$f$count;
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)$this$isLine, (String)"<this>");
        if (StringsKt.startsWith$default((CharSequence)$this$isLine, (char)'-', (boolean)false, (int)2, null) && ParagraphListBuilderKt.containsOnly($this$isLine, cArray = new char[]{'-', ' '})) {
            CharSequence charSequence = $this$isLine;
            $i$f$count = false;
            count$iv = 0;
            for (n = 0; n < charSequence.length(); ++n) {
                it = element$iv = charSequence.charAt(n);
                boolean bl = false;
                if (!(it == '-')) continue;
                ++count$iv;
            }
            if (count$iv >= minCount) return true;
        }
        if (!StringsKt.startsWith$default((CharSequence)$this$isLine, (char)'_', (boolean)false, (int)2, null)) return false;
        char[] cArray2 = new char[]{'_', ' '};
        if (!ParagraphListBuilderKt.containsOnly($this$isLine, cArray2)) return false;
        CharSequence charSequence = $this$isLine;
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < charSequence.length(); ++n) {
            it = element$iv = charSequence.charAt(n);
            boolean bl = false;
            if (!(it == '_')) continue;
            ++count$iv;
        }
        if (count$iv < minCount) return false;
        return true;
    }

    public static /* synthetic */ boolean isLine$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return UtilitiesKt.isLine(string, n);
    }

    public static final boolean isKDocTag(@NotNull String $this$isKDocTag) {
        Intrinsics.checkNotNullParameter((Object)$this$isKDocTag, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$isKDocTag, (String)"@", (boolean)false, (int)2, null) && $this$isKDocTag.length() > 1) {
            int n = $this$isKDocTag.length();
            for (int i = 1; i < n; ++i) {
                char c = $this$isKDocTag.charAt(i);
                if (CharsKt.isWhitespace((char)c)) {
                    return i > 2;
                }
                if (Character.isLetter(c) && Character.isLowerCase(c)) continue;
                if (c == '[' && (StringsKt.startsWith$default((String)$this$isKDocTag, (String)"@param", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isKDocTag, (String)"@property", (boolean)false, (int)2, null))) {
                    return true;
                }
                return i == 1 && Character.isLetter(c) && Character.isUpperCase(c);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static final String getTagName(@NotNull String $this$getTagName, @NotNull String tag) {
        int end;
        int start;
        Intrinsics.checkNotNullParameter((Object)$this$getTagName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        int length = $this$getTagName.length();
        for (start = 0; start < length && CharsKt.isWhitespace((char)$this$getTagName.charAt(start)); ++start) {
        }
        if (!StringsKt.startsWith$default((String)$this$getTagName, (String)tag, (int)start, (boolean)false, (int)4, null)) {
            return null;
        }
        start += tag.length();
        while (start < length && CharsKt.isWhitespace((char)$this$getTagName.charAt(start))) {
            ++start;
        }
        if (start < length && $this$getTagName.charAt(start) == '[') {
            ++start;
            while (start < length && CharsKt.isWhitespace((char)$this$getTagName.charAt(start))) {
                ++start;
            }
        }
        for (end = start; end < length && Character.isJavaIdentifierPart($this$getTagName.charAt(end)); ++end) {
        }
        if (end > start) {
            String string = $this$getTagName.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return null;
    }

    @Nullable
    public static final String getParamName(@NotNull String $this$getParamName) {
        Intrinsics.checkNotNullParameter((Object)$this$getParamName, (String)"<this>");
        String string = UtilitiesKt.getTagName($this$getParamName, "@param");
        if (string == null) {
            string = UtilitiesKt.getTagName($this$getParamName, "@property");
        }
        return string;
    }

    private static final String getIndent(int start, Function1<? super Integer, Character> lookup) {
        for (int i = start - 1; i >= 0 && ((Character)lookup.invoke((Object)i)).charValue() != '\n'; --i) {
        }
        StringBuilder sb = new StringBuilder();
        for (int j = i + 1; j < start; ++j) {
            sb.append(((Character)lookup.invoke((Object)j)).charValue());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<String, String> computeIndents(int start, @NotNull Function1<? super Integer, Character> lookup, int max) {
        String string;
        String indent;
        String string2;
        boolean suffix;
        boolean bl;
        String originalIndent;
        block12: {
            Intrinsics.checkNotNullParameter(lookup, (String)"lookup");
            originalIndent = UtilitiesKt.getIndent(start, lookup);
            CharSequence $this$all$iv = originalIndent;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                bl = false;
                break block12;
            }
            bl = true;
        }
        boolean bl3 = suffix = !bl;
        if (suffix) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = originalIndent;
            boolean $i$f$map = false;
            CharSequence element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                char it;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(Character.valueOf(CharsKt.isWhitespace((char)it) ? it : (char)' '));
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } else {
            string2 = indent = originalIndent;
        }
        if (suffix) {
            int offset;
            for (offset = start; offset < max && ((Character)lookup.invoke((Object)offset)).charValue() != '\n'; ++offset) {
            }
            ++offset;
            StringBuilder sb = new StringBuilder();
            while (offset < max) {
                if (((Character)lookup.invoke((Object)offset)).charValue() == '\n') {
                    StringsKt.clear((StringBuilder)sb);
                } else {
                    char c = ((Character)lookup.invoke((Object)offset)).charValue();
                    if (CharsKt.isWhitespace((char)c)) {
                        sb.append(c);
                    } else {
                        if (c != '*') break;
                        sb.setLength(sb.length() - 1);
                        break;
                    }
                }
                ++offset;
            }
            string = sb.toString();
        } else {
            string = originalIndent;
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"if (suffix) {\n        //\u2026   originalIndent\n      }");
        String secondaryIndent = string3;
        return new Pair((Object)indent, (Object)secondaryIndent);
    }

    public static final int findSamePosition(@NotNull String comment, int delta, @NotNull String reformattedComment) {
        int reformattedOffset;
        int j;
        int i;
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)reformattedComment, (String)"reformattedComment");
        int n = Math.min(comment.length(), reformattedComment.length());
        for (i = 0; i < n; ++i) {
            if (i == delta) {
                return delta;
            }
            if (comment.charAt(i) != reformattedComment.charAt(i)) break;
        }
        i = comment.length() - 1;
        if (delta == i + 1) {
            return j + 1;
        }
        for (j = reformattedComment.length() - 1; i >= 0 && j >= 0; --i, --j) {
            if (i == delta) {
                return j;
            }
            if (comment.charAt(i) != reformattedComment.charAt(j)) break;
        }
        int offset = 0;
        for (reformattedOffset = 0; offset < delta && reformattedOffset < reformattedComment.length(); ++offset, ++reformattedOffset) {
            offset = UtilitiesKt.findSamePosition$nextSignificantChar(comment, offset);
            reformattedOffset = UtilitiesKt.findSamePosition$nextSignificantChar(reformattedComment, reformattedOffset);
            if (offset != delta) continue;
            return reformattedOffset;
        }
        return reformattedOffset;
    }

    @NotNull
    public static final <T, R extends Comparable<? super R>> R maxOf(@NotNull Iterable<? extends T> $this$maxOf, @NotNull Function1<? super T, ? extends R> selector) {
        Intrinsics.checkNotNullParameter($this$maxOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterator<T> iterator = $this$maxOf.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable maxValue = (Comparable)selector.invoke(iterator.next());
        while (iterator.hasNext()) {
            Comparable v = (Comparable)selector.invoke(iterator.next());
            if (maxValue.compareTo(v) >= 0) continue;
            maxValue = v;
        }
        return (R)maxValue;
    }

    private static final boolean findSamePosition$isSignificantChar(char c) {
        return CharsKt.isWhitespace((char)c) || c == '*';
    }

    private static final int findSamePosition$nextSignificantChar(String s, int from) {
        char c;
        int curr;
        for (curr = from; curr < s.length() && UtilitiesKt.findSamePosition$isSignificantChar(c = s.charAt(curr)); ++curr) {
        }
        return curr;
    }
}

