/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.debughelpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.CloseOp;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpenOp;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"OPENOP_STRING_FORM_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "printOps", "", "ops", "Lcom/google/common/collect/ImmutableList;", "Lcom/google/googlejavaformat/Op;", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nOpsDebug.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpsDebug.kt\ncom/facebook/ktfmt/debughelpers/OpsDebugKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class OpsDebugKt {
    private static final Pattern OPENOP_STRING_FORM_REGEX = Pattern.compile("OpenOp\\{plusIndent=Const\\{n=(\\d+)}}");

    public static final void printOps(@NotNull ImmutableList<Op> ops) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        System.out.println((Object)"Ops: ");
        int indent = 0;
        UnmodifiableIterator unmodifiableIterator = ops.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            String line2;
            Op op = (Op)unmodifiableIterator2.next();
            Op op2 = op;
            if (op2 instanceof OpenOp) {
                String opIndent;
                Matcher matcher = OPENOP_STRING_FORM_REGEX.matcher(((OpenOp)op).toString());
                v1 = matcher.matches() ? "[ " + (!Intrinsics.areEqual((Object)(opIndent = matcher.group(1)), (Object)"0") ? opIndent : "") : "[ " + op;
            } else if (op2 instanceof CloseOp) {
                v1 = "]";
            } else if (op2 instanceof Doc.Token) {
                Ref.ObjectRef result2 = new Ref.ObjectRef();
                result2.element = "";
                Output output2 = new Output((Ref.ObjectRef<String>)result2){
                    final /* synthetic */ Ref.ObjectRef<String> $result;
                    {
                        this.$result = $result;
                    }

                    public void indent(int indent) {
                    }

                    public void blankLine(int k, OpsBuilder.BlankLineWanted wanted) {
                    }

                    public void markForPartialFormat(Input.Token start, Input.Token end) {
                    }

                    public CommentsHelper getCommentsHelper() {
                        throw new Throwable();
                    }

                    public void append(String text, Range<Integer> range) {
                        this.$result.element = text;
                    }
                };
                ((Doc.Token)op).write(output2);
                v1 = "\"" + result2.element + "\"";
            } else {
                String result3 = op.toString();
                v1 = line2 = Intrinsics.areEqual((Object)result3, (Object)"Space{}") ? "\" \"" : result3;
            }
            if (op instanceof CloseOp) {
                --indent;
            }
            int n = 2 * indent;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                System.out.print((Object)" ");
            }
            if (op instanceof OpenOp) {
                ++indent;
            }
            System.out.println((Object)line2);
        }
        System.out.println();
    }
}

