/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.KotlinTok;
import com.facebook.ktfmt.format.KotlinToken;
import com.facebook.ktfmt.format.Tokenizer;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00180\u0017J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001cJV\u0010\u001d\u001aB\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\r0\r \u001e* \u0012\f\u0012\n \u001e*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0003H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\rH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010,\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0016J\u0016\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\b\u0001\u0012\u00020\n0\u000fH\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u00100\u001a\u00020\u0003H\u0016J\u0010\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u00064"}, d2={"Lcom/facebook/ktfmt/format/KotlinInput;", "Lcom/google/googlejavaformat/Input;", "text", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFile;)V", "tokens", "Lcom/google/common/collect/ImmutableList;", "Lcom/google/googlejavaformat/Input$Token;", "positionToColumnMap", "Lcom/google/common/collect/ImmutableMap;", "", "positionTokenMap", "Lcom/google/common/collect/ImmutableRangeMap;", "kN", "kToToken", "", "[Lcom/google/googlejavaformat/Input$Token;", "characterRangesToTokenRanges", "Lcom/google/common/collect/RangeSet;", "characterRanges", "", "Lcom/google/common/collect/Range;", "characterRangeToTokenRange", "offset", "length", "characterRangeToTokenRange$ktfmt", "makePositionToColumnMap", "kotlin.jvm.PlatformType", "toks", "", "Lcom/facebook/ktfmt/format/KotlinTok;", "buildToks", "fileText", "buildTokens", "buildTokenPositionsMap", "isParamComment", "", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "getkN", "getToken", "k", "getTokens", "getPositionTokenMap", "getPositionToColumnMap", "getText", "getLineNumber", "inputPosition", "getColumnNumber", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nKotlinInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInput.kt\ncom/facebook/ktfmt/format/KotlinInput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1563#2:235\n1634#2,3:236\n*S KotlinDebug\n*F\n+ 1 KotlinInput.kt\ncom/facebook/ktfmt/format/KotlinInput\n*L\n134#1:235\n134#1:236,3\n*E\n"})
public final class KotlinInput
extends Input {
    @NotNull
    private final String text;
    @NotNull
    private final ImmutableList<Input.Token> tokens;
    @NotNull
    private final ImmutableMap<Integer, Integer> positionToColumnMap;
    @NotNull
    private final ImmutableRangeMap<Integer, Input.Token> positionTokenMap;
    private int kN;
    @NotNull
    private final Input.Token[] kToToken;

    public KotlinInput(@NotNull String text, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.text = text;
        this.setLines(ImmutableList.copyOf((Iterator)Newlines.lineIterator((String)this.text)));
        ImmutableList<KotlinTok> toks = this.buildToks(file, this.text);
        ImmutableMap<Integer, Integer> immutableMap = this.makePositionToColumnMap((List)toks);
        Intrinsics.checkNotNullExpressionValue(immutableMap, (String)"makePositionToColumnMap(...)");
        this.positionToColumnMap = immutableMap;
        this.tokens = this.buildTokens((List)toks);
        this.positionTokenMap = this.buildTokenPositionsMap(this.tokens);
        this.kToToken = new Input.Token[this.kN + 1];
        UnmodifiableIterator unmodifiableIterator = this.tokens.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            Input.Tok tok;
            Input.Token token = (Input.Token)unmodifiableIterator2.next();
            UnmodifiableIterator unmodifiableIterator3 = token.getToksBefore().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator3, (String)"iterator(...)");
            UnmodifiableIterator unmodifiableIterator4 = unmodifiableIterator3;
            while (unmodifiableIterator4.hasNext()) {
                tok = (Input.Tok)unmodifiableIterator4.next();
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
            this.kToToken[token.getTok().getIndex()] = token;
            UnmodifiableIterator unmodifiableIterator5 = token.getToksAfter().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator5, (String)"iterator(...)");
            unmodifiableIterator4 = unmodifiableIterator5;
            while (unmodifiableIterator4.hasNext()) {
                tok = (Input.Tok)unmodifiableIterator4.next();
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
        }
    }

    @NotNull
    public final RangeSet<Integer> characterRangesToTokenRanges(@NotNull Collection<Range<Integer>> characterRanges) throws FormatterException {
        Intrinsics.checkNotNullParameter(characterRanges, (String)"characterRanges");
        TreeRangeSet tokenRangeSet = TreeRangeSet.create();
        for (Range<Integer> characterRange0 : characterRanges) {
            Range characterRange = characterRange0.canonical(DiscreteDomain.integers());
            Comparable comparable = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"lowerEndpoint(...)");
            int n = ((Number)((Object)comparable)).intValue();
            int n2 = ((Number)((Object)characterRange.upperEndpoint())).intValue();
            Comparable comparable2 = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"lowerEndpoint(...)");
            tokenRangeSet.add(this.characterRangeToTokenRange$ktfmt(n, n2 - ((Number)((Object)comparable2)).intValue()));
        }
        Intrinsics.checkNotNull((Object)tokenRangeSet);
        return (RangeSet)tokenRangeSet;
    }

    @NotNull
    public final Range<Integer> characterRangeToTokenRange$ktfmt(int offset, int length) throws FormatterException {
        Range range;
        int requiredLength = offset + length;
        if (requiredLength > this.text.length()) {
            String string = "error: invalid length %d, offset + length (%d) is outside the file";
            Object[] objectArray = new Object[]{length, requiredLength};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new FormatterException(string2);
        }
        if (length < 0) {
            Range range2 = Input.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"EMPTY_RANGE");
            return range2;
        }
        int expandedLength = length == 0 ? 1 : length;
        Collection collection = this.getPositionTokenMap().subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + expandedLength))).asMapOfRanges().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        ImmutableCollection enclosed = (ImmutableCollection)collection;
        if (enclosed.isEmpty()) {
            Range range3 = Input.EMPTY_RANGE;
            Intrinsics.checkNotNull((Object)range3);
            range = range3;
        } else {
            Range range4 = Range.closedOpen((Comparable)Integer.valueOf(((Input.Token)enclosed.iterator().next()).getTok().getIndex()), (Comparable)Integer.valueOf(((Input.Token)Iterables.getLast((Iterable)((Iterable)enclosed))).getTok().getIndex() + 1));
            range = range4;
            Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"closedOpen(...)");
        }
        return range;
    }

    /*
     * WARNING - void declaration
     */
    private final ImmutableMap<Integer, Integer> makePositionToColumnMap(List<KotlinTok> toks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = toks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinTok kotlinTok = (KotlinTok)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getPosition(), (Object)it.getColumn()));
        }
        return ImmutableMap.copyOf((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    private final ImmutableList<KotlinTok> buildToks(KtFile file, String fileText) {
        Tokenizer tokenizer = new Tokenizer(fileText, file);
        file.accept((PsiElementVisitor)tokenizer);
        List<KotlinTok> toks = tokenizer.getToks();
        int n = tokenizer.getIndex();
        int n2 = fileText.length();
        KtToken ktToken = KtTokens.EOF;
        Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
        toks.add(new KotlinTok(n, "", "", n2, 0, true, ktToken));
        this.kN = tokenizer.getIndex();
        this.computeRanges(toks);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)toks);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
        return immutableList;
    }

    private final ImmutableList<Input.Token> buildTokens(List<KotlinTok> toks) {
        ImmutableList.Builder tokens = ImmutableList.builder();
        int k = 0;
        int kN = toks.size();
        ImmutableList.Builder builder = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ImmutableList.Builder toksBefore = builder;
        block0: while (k < kN) {
            KotlinTok tok;
            while (!toks.get(k).isToken()) {
                tok = toks.get(k++);
                toksBefore.add((Object)tok);
                if (!this.isParamComment(tok)) continue;
                while (toks.get(k).isNewline()) {
                    ++k;
                }
            }
            tok = toks.get(k++);
            ImmutableList.Builder toksAfter = ImmutableList.builder();
            while (!(k >= kN || toks.get(k).isToken() || toks.get(k).isSlashStarComment() && (Intrinsics.areEqual((Object)tok.getText(), (Object)"(") || Intrinsics.areEqual((Object)tok.getText(), (Object)"<") || Intrinsics.areEqual((Object)tok.getText(), (Object)".")) || toks.get(k).isJavadocComment() && Intrinsics.areEqual((Object)tok.getText(), (Object)";"))) {
                if (this.isParamComment(toks.get(k))) {
                    ImmutableList immutableList = toksBefore.build();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
                    ImmutableList immutableList2 = toksAfter.build();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"build(...)");
                    tokens.add((Object)new KotlinToken((ImmutableList<KotlinTok>)immutableList, tok, (ImmutableList<KotlinTok>)immutableList2));
                    Intrinsics.checkNotNullExpressionValue((Object)ImmutableList.builder().add((Object)toks.get(k++)), (String)"add(...)");
                    while (toks.get(k).isNewline()) {
                        ++k;
                    }
                    continue block0;
                }
                KotlinTok nonTokenAfter = toks.get(k++);
                toksAfter.add((Object)nonTokenAfter);
                if (!Newlines.containsBreaks((String)nonTokenAfter.getText())) continue;
            }
            ImmutableList immutableList = toksBefore.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
            ImmutableList immutableList3 = toksAfter.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList3, (String)"build(...)");
            tokens.add((Object)new KotlinToken((ImmutableList<KotlinTok>)immutableList, tok, (ImmutableList<KotlinTok>)immutableList3));
            Intrinsics.checkNotNullExpressionValue((Object)ImmutableList.builder(), (String)"builder(...)");
        }
        ImmutableList immutableList = tokens.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return immutableList;
    }

    private final ImmutableRangeMap<Integer, Input.Token> buildTokenPositionsMap(ImmutableList<Input.Token> tokens) {
        ImmutableRangeMap.Builder tokenLocations = ImmutableRangeMap.builder();
        UnmodifiableIterator unmodifiableIterator = tokens.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            Input.Token token = (Input.Token)unmodifiableIterator2.next();
            Input.Tok end = JavaOutput.endTok((Input.Token)token);
            int n = end.getPosition();
            String string = end.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            int endPosition = n + (((CharSequence)string).length() > 0 ? end.length() - 1 : 0);
            tokenLocations.put(Range.closed((Comparable)Integer.valueOf(JavaOutput.startTok((Input.Token)token).getPosition()), (Comparable)Integer.valueOf(endPosition)), (Object)token);
        }
        ImmutableRangeMap immutableRangeMap = tokenLocations.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableRangeMap, (String)"build(...)");
        return immutableRangeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isParamComment(Input.Tok tok) {
        if (!tok.isSlashStarComment()) return false;
        String string = tok.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        if (!new Regex("/\\*[A-Za-z0-9\\s_\\-]+=\\s*\\*/").matches(charSequence)) return false;
        return true;
    }

    public int getkN() {
        return this.kN;
    }

    @Nullable
    public Input.Token getToken(int k) {
        return this.kToToken[k];
    }

    @NotNull
    public ImmutableList<? extends Input.Token> getTokens() {
        return this.tokens;
    }

    @NotNull
    public ImmutableRangeMap<Integer, ? extends Input.Token> getPositionTokenMap() {
        return this.positionTokenMap;
    }

    @NotNull
    public ImmutableMap<Integer, Integer> getPositionToColumnMap() {
        return this.positionToColumnMap;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public int getLineNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).line + 1;
    }

    public int getColumnNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).column;
    }
}

