/*
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package com.facebook.litho.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Parameters declared in a class annotated with {@link Event} that are used in {@link OnTrigger}
 *
 * For example:
 * <pre>
 *   {@code
 *
 *   {@literal @}LayoutSpec
 *   public class ComponentSpec {
 *
 *     {@literal @}OnTrigger(YourEvent.class)
 *     static Object yourEventClick(ComponentContext c, {@literal @}FromTrigger YourObject obj) {
 *       return new Object();
 *     }
 *   }}
 * </pre>
 */
@Retention(RetentionPolicy.SOURCE)
public @interface FromTrigger {

}
