/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.fresco;

import android.graphics.ColorFilter;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.v4.util.Pools;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.fresco.DraweeDrawable;
import com.facebook.litho.fresco.FrescoImageSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public final class FrescoImage
extends ComponentLifecycle {
    private static FrescoImage sInstance = null;
    private static final Pools.SynchronizedPool<Builder> mBuilderPool = new Pools.SynchronizedPool(2);
    private FrescoImageSpec mSpec = new FrescoImageSpec();

    private FrescoImage() {
    }

    public static synchronized FrescoImage get() {
        if (sInstance == null) {
            sInstance = new FrescoImage();
        }
        return sInstance;
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component _abstractImpl) {
        FrescoImageImpl _impl = (FrescoImageImpl)_abstractImpl;
        FrescoImageSpec.onMeasure(c, layout, widthSpec, heightSpec, size, _impl.aspectRatio);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected Object onCreateMountContent(ComponentContext c) {
        DraweeDrawable<GenericDraweeHierarchy> _result = FrescoImageSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object draweeDrawable, Component _abstractImpl) {
        FrescoImageImpl _impl = (FrescoImageImpl)_abstractImpl;
        FrescoImageSpec.onMount(c, (DraweeDrawable)((Object)draweeDrawable), _impl.actualImageScaleType, _impl.fadeDuration, _impl.failureImage, _impl.failureImageScaleType, _impl.placeholderImage, _impl.placeholderImageFocusPoint, _impl.placeholderImageScaleType, _impl.progressBarImage, _impl.progressBarImageScaleType, _impl.retryImage, _impl.retryImageScaleType, _impl.roundingParams, _impl.colorFilter);
    }

    protected void onBind(ComponentContext c, Object mountedDrawable, Component _abstractImpl) {
        FrescoImageImpl _impl = (FrescoImageImpl)_abstractImpl;
        FrescoImageSpec.onBind(c, (DraweeDrawable)((Object)mountedDrawable), _impl.controller);
    }

    protected void onUnbind(ComponentContext c, Object mountedDrawable, Component _abstractImpl) {
        FrescoImageImpl _impl = (FrescoImageImpl)_abstractImpl;
        FrescoImageSpec.onUnbind(c, (DraweeDrawable)((Object)mountedDrawable), _impl.controller);
    }

    protected void onUnmount(ComponentContext c, Object mountedDrawable, Component _abstractImpl) {
        FrescoImageImpl _impl = (FrescoImageImpl)_abstractImpl;
        FrescoImageSpec.onUnmount(c, (DraweeDrawable)((Object)mountedDrawable));
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 15;
    }

    private static Builder newBuilder(ComponentContext context, int defStyleAttr, int defStyleRes, FrescoImageImpl frescoImageImpl) {
        Builder builder = (Builder)((Object)mBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, frescoImageImpl);
        return builder;
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        return FrescoImage.newBuilder(context, defStyleAttr, defStyleRes, new FrescoImageImpl());
    }

    public static Builder create(ComponentContext context) {
        return FrescoImage.create(context, 0, 0);
    }

    public static class Builder
    extends Component.Builder<FrescoImage> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"controller"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        FrescoImageImpl mFrescoImageImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, FrescoImageImpl frescoImageImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)frescoImageImpl);
            this.mFrescoImageImpl = frescoImageImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder aspectRatio(float aspectRatio) {
            this.mFrescoImageImpl.aspectRatio = aspectRatio;
            return this;
        }

        public Builder aspectRatioRes(@DimenRes int resId) {
            this.mFrescoImageImpl.aspectRatio = this.resolveFloatRes(resId);
            return this;
        }

        public Builder aspectRatioAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mFrescoImageImpl.aspectRatio = this.resolveFloatAttr(attrResId, defResId);
            return this;
        }

        public Builder aspectRatioAttr(@AttrRes int attrResId) {
            this.mFrescoImageImpl.aspectRatio = this.resolveFloatAttr(attrResId, 0);
            return this;
        }

        public Builder actualImageScaleType(ScalingUtils.ScaleType actualImageScaleType) {
            this.mFrescoImageImpl.actualImageScaleType = actualImageScaleType;
            return this;
        }

        public Builder fadeDuration(int fadeDuration) {
            this.mFrescoImageImpl.fadeDuration = fadeDuration;
            return this;
        }

        public Builder failureImage(Drawable failureImage) {
            this.mFrescoImageImpl.failureImage = failureImage;
            return this;
        }

        public Builder failureImageRes(@DrawableRes int resId) {
            this.mFrescoImageImpl.failureImage = this.resolveDrawableRes(resId);
            return this;
        }

        public Builder failureImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImageImpl.failureImage = this.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        public Builder failureImageAttr(@AttrRes int attrResId) {
            this.mFrescoImageImpl.failureImage = this.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        public Builder failureImageScaleType(ScalingUtils.ScaleType failureImageScaleType) {
            this.mFrescoImageImpl.failureImageScaleType = failureImageScaleType;
            return this;
        }

        public Builder placeholderImage(Drawable placeholderImage) {
            this.mFrescoImageImpl.placeholderImage = placeholderImage;
            return this;
        }

        public Builder placeholderImageRes(@DrawableRes int resId) {
            this.mFrescoImageImpl.placeholderImage = this.resolveDrawableRes(resId);
            return this;
        }

        public Builder placeholderImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImageImpl.placeholderImage = this.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        public Builder placeholderImageAttr(@AttrRes int attrResId) {
            this.mFrescoImageImpl.placeholderImage = this.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        public Builder placeholderImageFocusPoint(PointF placeholderImageFocusPoint) {
            this.mFrescoImageImpl.placeholderImageFocusPoint = placeholderImageFocusPoint;
            return this;
        }

        public Builder placeholderImageScaleType(ScalingUtils.ScaleType placeholderImageScaleType) {
            this.mFrescoImageImpl.placeholderImageScaleType = placeholderImageScaleType;
            return this;
        }

        public Builder progressBarImage(Drawable progressBarImage) {
            this.mFrescoImageImpl.progressBarImage = progressBarImage;
            return this;
        }

        public Builder progressBarImageRes(@DrawableRes int resId) {
            this.mFrescoImageImpl.progressBarImage = this.resolveDrawableRes(resId);
            return this;
        }

        public Builder progressBarImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImageImpl.progressBarImage = this.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        public Builder progressBarImageAttr(@AttrRes int attrResId) {
            this.mFrescoImageImpl.progressBarImage = this.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        public Builder progressBarImageScaleType(ScalingUtils.ScaleType progressBarImageScaleType) {
            this.mFrescoImageImpl.progressBarImageScaleType = progressBarImageScaleType;
            return this;
        }

        public Builder retryImage(Drawable retryImage) {
            this.mFrescoImageImpl.retryImage = retryImage;
            return this;
        }

        public Builder retryImageRes(@DrawableRes int resId) {
            this.mFrescoImageImpl.retryImage = this.resolveDrawableRes(resId);
            return this;
        }

        public Builder retryImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImageImpl.retryImage = this.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        public Builder retryImageAttr(@AttrRes int attrResId) {
            this.mFrescoImageImpl.retryImage = this.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        public Builder retryImageScaleType(ScalingUtils.ScaleType retryImageScaleType) {
            this.mFrescoImageImpl.retryImageScaleType = retryImageScaleType;
            return this;
        }

        public Builder roundingParams(RoundingParams roundingParams) {
            this.mFrescoImageImpl.roundingParams = roundingParams;
            return this;
        }

        public Builder colorFilter(ColorFilter colorFilter) {
            this.mFrescoImageImpl.colorFilter = colorFilter;
            return this;
        }

        public Builder controller(DraweeController controller) {
            this.mFrescoImageImpl.controller = controller;
            this.mRequired.set(0);
            return this;
        }

        public Builder key(String key) {
            super.setKey(key);
            return this;
        }

        public Component<FrescoImage> build() {
            if (this.mRequired != null && this.mRequired.nextClearBit(0) < 1) {
                ArrayList<String> missingProps = new ArrayList<String>();
                for (int i = 0; i < 1; ++i) {
                    if (this.mRequired.get(i)) continue;
                    missingProps.add(REQUIRED_PROPS_NAMES[i]);
                }
                throw new IllegalStateException("The following props are not marked as optional and were not supplied: " + Arrays.toString(missingProps.toArray()));
            }
            FrescoImageImpl frescoImageImpl = this.mFrescoImageImpl;
            this.release();
            return frescoImageImpl;
        }

        protected void release() {
            super.release();
            this.mFrescoImageImpl = null;
            this.mContext = null;
            mBuilderPool.release((Object)this);
        }
    }

    private static class FrescoImageImpl
    extends Component<FrescoImage>
    implements Cloneable {
        @Prop
        float aspectRatio = 1.0f;
        @Prop
        ScalingUtils.ScaleType actualImageScaleType = FrescoImageSpec.actualImageScaleType;
        @Prop
        int fadeDuration = 300;
        @Prop
        Drawable failureImage;
        @Prop
        ScalingUtils.ScaleType failureImageScaleType = FrescoImageSpec.failureImageScaleType;
        @Prop
        Drawable placeholderImage;
        @Prop
        PointF placeholderImageFocusPoint = FrescoImageSpec.placeholderImageFocusPoint;
        @Prop
        ScalingUtils.ScaleType placeholderImageScaleType = FrescoImageSpec.placeholderImageScaleType;
        @Prop
        Drawable progressBarImage;
        @Prop
        ScalingUtils.ScaleType progressBarImageScaleType = FrescoImageSpec.progressBarImageScaleType;
        @Prop
        Drawable retryImage;
        @Prop
        ScalingUtils.ScaleType retryImageScaleType = FrescoImageSpec.retryImageScaleType;
        @Prop
        RoundingParams roundingParams;
        @Prop
        ColorFilter colorFilter;
        @Prop
        DraweeController controller;

        private FrescoImageImpl() {
            super((ComponentLifecycle)FrescoImage.get());
        }

        public String getSimpleName() {
            return "FrescoImage";
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            FrescoImageImpl frescoImageImpl = (FrescoImageImpl)other;
            if (this.getId() == frescoImageImpl.getId()) {
                return true;
            }
            if (Float.compare(this.aspectRatio, frescoImageImpl.aspectRatio) != 0) {
                return false;
            }
            if (this.actualImageScaleType != null ? !this.actualImageScaleType.equals(frescoImageImpl.actualImageScaleType) : frescoImageImpl.actualImageScaleType != null) {
                return false;
            }
            if (this.fadeDuration != frescoImageImpl.fadeDuration) {
                return false;
            }
            if (this.failureImage != null ? !this.failureImage.equals(frescoImageImpl.failureImage) : frescoImageImpl.failureImage != null) {
                return false;
            }
            if (this.failureImageScaleType != null ? !this.failureImageScaleType.equals(frescoImageImpl.failureImageScaleType) : frescoImageImpl.failureImageScaleType != null) {
                return false;
            }
            if (this.placeholderImage != null ? !this.placeholderImage.equals(frescoImageImpl.placeholderImage) : frescoImageImpl.placeholderImage != null) {
                return false;
            }
            if (this.placeholderImageFocusPoint != null ? !this.placeholderImageFocusPoint.equals((Object)frescoImageImpl.placeholderImageFocusPoint) : frescoImageImpl.placeholderImageFocusPoint != null) {
                return false;
            }
            if (this.placeholderImageScaleType != null ? !this.placeholderImageScaleType.equals(frescoImageImpl.placeholderImageScaleType) : frescoImageImpl.placeholderImageScaleType != null) {
                return false;
            }
            if (this.progressBarImage != null ? !this.progressBarImage.equals(frescoImageImpl.progressBarImage) : frescoImageImpl.progressBarImage != null) {
                return false;
            }
            if (this.progressBarImageScaleType != null ? !this.progressBarImageScaleType.equals(frescoImageImpl.progressBarImageScaleType) : frescoImageImpl.progressBarImageScaleType != null) {
                return false;
            }
            if (this.retryImage != null ? !this.retryImage.equals(frescoImageImpl.retryImage) : frescoImageImpl.retryImage != null) {
                return false;
            }
            if (this.retryImageScaleType != null ? !this.retryImageScaleType.equals(frescoImageImpl.retryImageScaleType) : frescoImageImpl.retryImageScaleType != null) {
                return false;
            }
            if (this.roundingParams != null ? !this.roundingParams.equals((Object)frescoImageImpl.roundingParams) : frescoImageImpl.roundingParams != null) {
                return false;
            }
            if (this.colorFilter != null ? !this.colorFilter.equals(frescoImageImpl.colorFilter) : frescoImageImpl.colorFilter != null) {
                return false;
            }
            return !(this.controller != null ? !this.controller.equals(frescoImageImpl.controller) : frescoImageImpl.controller != null);
        }
    }
}

