/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.fresco;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.litho.ImageContent;
import com.facebook.litho.Touchable;
import com.facebook.litho.fresco.NoOpDrawable;
import java.util.Collections;
import java.util.List;

public class DraweeDrawable<DH extends DraweeHierarchy>
extends ForwardingDrawable
implements ImageContent,
Touchable {
    private final Drawable mNoOpDrawable = new NoOpDrawable();
    private final DraweeHolder<DH> mDraweeHolder;

    public DraweeDrawable(Context context, DH draweeHierarchy) {
        super(null);
        this.setCurrent(this.mNoOpDrawable);
        this.mDraweeHolder = DraweeHolder.create(draweeHierarchy, (Context)context);
    }

    public void mount() {
        this.setDrawable(this.mDraweeHolder.getTopLevelDrawable());
        this.mDraweeHolder.onAttach();
    }

    public void unmount() {
        this.mDraweeHolder.onDetach();
        this.setDrawable(this.mNoOpDrawable);
    }

    public void draw(Canvas canvas) {
        this.mDraweeHolder.onDraw();
        super.draw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event, View host) {
        return this.mDraweeHolder.onTouchEvent(event);
    }

    public boolean shouldHandleTouchEvent(MotionEvent event) {
        return true;
    }

    public List<Drawable> getImageItems() {
        return Collections.singletonList(this);
    }

    public DraweeController getController() {
        return this.mDraweeHolder.getController();
    }

    public DH getDraweeHierarchy() {
        return (DH)this.mDraweeHolder.getHierarchy();
    }

    public void setController(DraweeController controller) {
        if (this.mDraweeHolder.getController() == controller) {
            return;
        }
        this.mDraweeHolder.setController(controller);
    }
}

