/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.fresco;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import androidx.annotation.AttrRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Size;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.fresco.DraweeDrawable;
import com.facebook.litho.fresco.FrescoImageSpec;
import java.util.BitSet;

@Generated
public final class FrescoImage
extends SpecGeneratedComponent {
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    PointF actualImageFocusPoint;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ScalingUtils.ScaleType actualImageScaleType = FrescoImageSpec.actualImageScaleType;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ColorFilter colorFilter;
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=13)
    DraweeController controller;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int fadeDuration = 300;
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable failureImage;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ScalingUtils.ScaleType failureImageScaleType = FrescoImageSpec.failureImageScaleType;
    @Prop(resType=ResType.FLOAT, optional=true)
    @Comparable(type=0)
    float imageAspectRatio = 1.0f;
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable placeholderImage;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    PointF placeholderImageFocusPoint = FrescoImageSpec.placeholderImageFocusPoint;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ScalingUtils.ScaleType placeholderImageScaleType = FrescoImageSpec.placeholderImageScaleType;
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable progressBarImage;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ScalingUtils.ScaleType progressBarImageScaleType = FrescoImageSpec.progressBarImageScaleType;
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable retryImage;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ScalingUtils.ScaleType retryImageScaleType = FrescoImageSpec.retryImageScaleType;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    RoundingParams roundingParams;

    private FrescoImage() {
        super("FrescoImage");
    }

    public boolean isEquivalentProps(Component other, boolean shouldCompareCommonProps) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        FrescoImage frescoImageRef = (FrescoImage)other;
        if (this.actualImageFocusPoint != null ? !this.actualImageFocusPoint.equals((Object)frescoImageRef.actualImageFocusPoint) : frescoImageRef.actualImageFocusPoint != null) {
            return false;
        }
        if (this.actualImageScaleType != null ? !this.actualImageScaleType.equals(frescoImageRef.actualImageScaleType) : frescoImageRef.actualImageScaleType != null) {
            return false;
        }
        if (this.colorFilter != null ? !this.colorFilter.equals(frescoImageRef.colorFilter) : frescoImageRef.colorFilter != null) {
            return false;
        }
        if (this.controller != null ? !this.controller.equals(frescoImageRef.controller) : frescoImageRef.controller != null) {
            return false;
        }
        if (this.fadeDuration != frescoImageRef.fadeDuration) {
            return false;
        }
        if (this.failureImage != null ? !this.failureImage.equals(frescoImageRef.failureImage) : frescoImageRef.failureImage != null) {
            return false;
        }
        if (this.failureImageScaleType != null ? !this.failureImageScaleType.equals(frescoImageRef.failureImageScaleType) : frescoImageRef.failureImageScaleType != null) {
            return false;
        }
        if (Float.compare(this.imageAspectRatio, frescoImageRef.imageAspectRatio) != 0) {
            return false;
        }
        if (this.placeholderImage != null ? !this.placeholderImage.equals(frescoImageRef.placeholderImage) : frescoImageRef.placeholderImage != null) {
            return false;
        }
        if (this.placeholderImageFocusPoint != null ? !this.placeholderImageFocusPoint.equals((Object)frescoImageRef.placeholderImageFocusPoint) : frescoImageRef.placeholderImageFocusPoint != null) {
            return false;
        }
        if (this.placeholderImageScaleType != null ? !this.placeholderImageScaleType.equals(frescoImageRef.placeholderImageScaleType) : frescoImageRef.placeholderImageScaleType != null) {
            return false;
        }
        if (this.progressBarImage != null ? !this.progressBarImage.equals(frescoImageRef.progressBarImage) : frescoImageRef.progressBarImage != null) {
            return false;
        }
        if (this.progressBarImageScaleType != null ? !this.progressBarImageScaleType.equals(frescoImageRef.progressBarImageScaleType) : frescoImageRef.progressBarImageScaleType != null) {
            return false;
        }
        if (this.retryImage != null ? !this.retryImage.equals(frescoImageRef.retryImage) : frescoImageRef.retryImage != null) {
            return false;
        }
        if (this.retryImageScaleType != null ? !this.retryImageScaleType.equals(frescoImageRef.retryImageScaleType) : frescoImageRef.retryImageScaleType != null) {
            return false;
        }
        return !(this.roundingParams != null ? !this.roundingParams.equals((Object)frescoImageRef.roundingParams) : frescoImageRef.roundingParams != null);
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, InterStagePropsContainer _5) {
        FrescoImageSpec.onMeasure(c, layout, widthSpec, heightSpec, size, this.imageAspectRatio);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected Object onCreateMountContent(Context c) {
        DraweeDrawable<GenericDraweeHierarchy> _result = FrescoImageSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object draweeDrawable, InterStagePropsContainer _2) {
        FrescoImageSpec.onMount(c, (DraweeDrawable)((Object)draweeDrawable), this.actualImageScaleType, this.actualImageFocusPoint, this.fadeDuration, this.failureImage, this.failureImageScaleType, this.placeholderImage, this.placeholderImageFocusPoint, this.placeholderImageScaleType, this.progressBarImage, this.progressBarImageScaleType, this.retryImage, this.retryImageScaleType, this.roundingParams, this.colorFilter);
    }

    protected void onBind(ComponentContext c, Object mountedDrawable, InterStagePropsContainer _2) {
        FrescoImageSpec.onBind(c, (DraweeDrawable)((Object)mountedDrawable), this.controller);
    }

    protected void onUnbind(ComponentContext c, Object mountedDrawable, InterStagePropsContainer _2) {
        FrescoImageSpec.onUnbind(c, (DraweeDrawable)((Object)mountedDrawable), this.controller);
    }

    protected void onUnmount(ComponentContext c, Object mountedDrawable, InterStagePropsContainer _2) {
        FrescoImageSpec.onUnmount(c, (DraweeDrawable)((Object)mountedDrawable));
    }

    public Component.MountType getMountType() {
        return Component.MountType.DRAWABLE;
    }

    public int poolSize() {
        return 3;
    }

    public boolean canPreallocate() {
        return false;
    }

    public static Builder create(ComponentContext context) {
        return FrescoImage.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        FrescoImage instance = new FrescoImage();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        FrescoImage mFrescoImage;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"controller"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, FrescoImage frescoImageRef) {
            super(context, defStyleAttr, defStyleRes, (Component)frescoImageRef);
            this.mFrescoImage = frescoImageRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mFrescoImage = (FrescoImage)component;
        }

        @PropSetter(value="actualImageFocusPoint", required=false)
        public Builder actualImageFocusPoint(PointF actualImageFocusPoint) {
            this.mFrescoImage.actualImageFocusPoint = actualImageFocusPoint;
            return this;
        }

        @PropSetter(value="actualImageScaleType", required=false)
        public Builder actualImageScaleType(ScalingUtils.ScaleType actualImageScaleType) {
            this.mFrescoImage.actualImageScaleType = actualImageScaleType;
            return this;
        }

        @PropSetter(value="colorFilter", required=false)
        public Builder colorFilter(ColorFilter colorFilter) {
            this.mFrescoImage.colorFilter = colorFilter;
            return this;
        }

        @PropSetter(value="controller", required=true)
        @RequiredProp(value="controller")
        public Builder controller(DraweeController controller) {
            this.mFrescoImage.controller = controller;
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="fadeDuration", required=false)
        public Builder fadeDuration(int fadeDuration) {
            this.mFrescoImage.fadeDuration = fadeDuration;
            return this;
        }

        @PropSetter(value="failureImage", required=false)
        public Builder failureImage(Drawable failureImage) {
            this.mFrescoImage.failureImage = failureImage;
            return this;
        }

        @PropSetter(value="failureImage", required=false)
        public Builder failureImageRes(@DrawableRes int resId) {
            this.mFrescoImage.failureImage = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="failureImage", required=false)
        public Builder failureImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImage.failureImage = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="failureImage", required=false)
        public Builder failureImageAttr(@AttrRes int attrResId) {
            this.mFrescoImage.failureImage = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="failureImageScaleType", required=false)
        public Builder failureImageScaleType(ScalingUtils.ScaleType failureImageScaleType) {
            this.mFrescoImage.failureImageScaleType = failureImageScaleType;
            return this;
        }

        @PropSetter(value="imageAspectRatio", required=false)
        public Builder imageAspectRatio(float imageAspectRatio) {
            this.mFrescoImage.imageAspectRatio = imageAspectRatio;
            return this;
        }

        @PropSetter(value="imageAspectRatio", required=false)
        public Builder imageAspectRatioRes(@DimenRes int resId) {
            this.mFrescoImage.imageAspectRatio = this.mResourceResolver.resolveFloatRes(resId);
            return this;
        }

        @PropSetter(value="imageAspectRatio", required=false)
        public Builder imageAspectRatioAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mFrescoImage.imageAspectRatio = this.mResourceResolver.resolveFloatAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="imageAspectRatio", required=false)
        public Builder imageAspectRatioAttr(@AttrRes int attrResId) {
            this.mFrescoImage.imageAspectRatio = this.mResourceResolver.resolveFloatAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="placeholderImage", required=false)
        public Builder placeholderImage(Drawable placeholderImage) {
            this.mFrescoImage.placeholderImage = placeholderImage;
            return this;
        }

        @PropSetter(value="placeholderImage", required=false)
        public Builder placeholderImageRes(@DrawableRes int resId) {
            this.mFrescoImage.placeholderImage = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="placeholderImage", required=false)
        public Builder placeholderImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImage.placeholderImage = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="placeholderImage", required=false)
        public Builder placeholderImageAttr(@AttrRes int attrResId) {
            this.mFrescoImage.placeholderImage = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="placeholderImageFocusPoint", required=false)
        public Builder placeholderImageFocusPoint(PointF placeholderImageFocusPoint) {
            this.mFrescoImage.placeholderImageFocusPoint = placeholderImageFocusPoint;
            return this;
        }

        @PropSetter(value="placeholderImageScaleType", required=false)
        public Builder placeholderImageScaleType(ScalingUtils.ScaleType placeholderImageScaleType) {
            this.mFrescoImage.placeholderImageScaleType = placeholderImageScaleType;
            return this;
        }

        @PropSetter(value="progressBarImage", required=false)
        public Builder progressBarImage(Drawable progressBarImage) {
            this.mFrescoImage.progressBarImage = progressBarImage;
            return this;
        }

        @PropSetter(value="progressBarImage", required=false)
        public Builder progressBarImageRes(@DrawableRes int resId) {
            this.mFrescoImage.progressBarImage = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="progressBarImage", required=false)
        public Builder progressBarImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImage.progressBarImage = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="progressBarImage", required=false)
        public Builder progressBarImageAttr(@AttrRes int attrResId) {
            this.mFrescoImage.progressBarImage = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="progressBarImageScaleType", required=false)
        public Builder progressBarImageScaleType(ScalingUtils.ScaleType progressBarImageScaleType) {
            this.mFrescoImage.progressBarImageScaleType = progressBarImageScaleType;
            return this;
        }

        @PropSetter(value="retryImage", required=false)
        public Builder retryImage(Drawable retryImage) {
            this.mFrescoImage.retryImage = retryImage;
            return this;
        }

        @PropSetter(value="retryImage", required=false)
        public Builder retryImageRes(@DrawableRes int resId) {
            this.mFrescoImage.retryImage = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="retryImage", required=false)
        public Builder retryImageAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mFrescoImage.retryImage = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="retryImage", required=false)
        public Builder retryImageAttr(@AttrRes int attrResId) {
            this.mFrescoImage.retryImage = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="retryImageScaleType", required=false)
        public Builder retryImageScaleType(ScalingUtils.ScaleType retryImageScaleType) {
            this.mFrescoImage.retryImageScaleType = retryImageScaleType;
            return this;
        }

        @PropSetter(value="roundingParams", required=false)
        public Builder roundingParams(@Nullable RoundingParams roundingParams) {
            this.mFrescoImage.roundingParams = roundingParams;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public FrescoImage build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mFrescoImage;
        }
    }
}

