/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.facebook.litho.testing.sections;

import com.facebook.litho.widget.RenderInfo;
import java.util.List;

public class TestIndexOutOfBoundsExceptionTarget extends TestTarget {

  @Override
  public void insert(int index, RenderInfo renderInfo) {
    throw new IndexOutOfBoundsException();
  }

  @Override
  public void insertRange(int index, int count, List<RenderInfo> renderInfos) {
    throw new IndexOutOfBoundsException();
  }

  @Override
  public void update(int index, RenderInfo renderInfo) {
    throw new IndexOutOfBoundsException();
  }

  @Override
  public void updateRange(int index, int count, List<RenderInfo> renderInfos) {
    throw new IndexOutOfBoundsException();
  }
}
