/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.BaseMatcher;
import com.facebook.litho.CommonProps;
import com.facebook.litho.Component;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;

public final class BaseMatcherBuilder {
    private BaseMatcherBuilder() {
    }

    public static Condition<InspectableComponent> buildCommonMatcher(final BaseMatcher matcher) {
        return new Condition<InspectableComponent>(){

            public boolean matches(InspectableComponent component) {
                Component underlyingComponent = component.getComponent();
                CommonProps commonProps = underlyingComponent.getCommonProps();
                if (matcher.mClickHandlerMatcher != null && commonProps != null && !matcher.mClickHandlerMatcher.matches((Object)commonProps.getClickHandler())) {
                    this.as((Description)new TextDescription("Click handler <%s> (doesn't match <%s>)", new Object[]{matcher.mClickHandlerMatcher, commonProps.getClickHandler()}));
                    return false;
                }
                if (matcher.mLongClickHandlerMatcher != null && commonProps != null && !matcher.mLongClickHandlerMatcher.matches((Object)commonProps.getLongClickHandler())) {
                    this.as((Description)new TextDescription("LongClick handler <%s> (doesn't match <%s>)", new Object[]{matcher.mLongClickHandlerMatcher, commonProps.getLongClickHandler()}));
                    return false;
                }
                if (matcher.mFocusChangeHandlerMatcher != null && commonProps != null && !matcher.mFocusChangeHandlerMatcher.matches((Object)commonProps.getFocusChangeHandler())) {
                    this.as((Description)new TextDescription("FocusChange handler <%s> (doesn't match <%s>)", new Object[]{matcher.mFocusChangeHandlerMatcher, commonProps.getFocusChangeHandler()}));
                    return false;
                }
                if (matcher.mTouchEventHandlerMatcher != null && commonProps != null && !matcher.mTouchEventHandlerMatcher.matches((Object)commonProps.getTouchHandler())) {
                    this.as((Description)new TextDescription("TouchEvent handler <%s> (doesn't match <%s>)", new Object[]{matcher.mTouchEventHandlerMatcher, commonProps.getTouchHandler()}));
                    return false;
                }
                if (matcher.mInterceptTouchHandlerMatcher != null && commonProps != null && !matcher.mInterceptTouchHandlerMatcher.matches((Object)commonProps.getInterceptTouchHandler())) {
                    this.as((Description)new TextDescription("InterceptTouch handler <%s> (doesn't match <%s>)", new Object[]{matcher.mInterceptTouchHandlerMatcher, commonProps.getInterceptTouchHandler()}));
                    return false;
                }
                if (matcher.mFocusable != null && commonProps != null && !matcher.mFocusable.matches((Object)commonProps.getFocusable())) {
                    this.as((Description)new TextDescription("Focusable <%s> (doesn't match <%s>)", new Object[]{matcher.mFocusable, commonProps.getFocusable()}));
                    return false;
                }
                if (matcher.mTransitionKey != null && commonProps != null && !matcher.mTransitionKey.matches((Object)commonProps.getTransitionKey())) {
                    this.as((Description)new TextDescription("Transition key <%s> (doesn't match <\"%s\">)", new Object[]{matcher.mTransitionKey, commonProps.getTransitionKey()}));
                    return false;
                }
                return true;
            }
        };
    }
}

