/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoView;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.rendercore.ContentAllocator;
import com.facebook.rendercore.MountItemsPool;

public class BenchmarkTestHelper {
    private static final int[] LAYOUT_SIZE_OUT = new int[2];

    public static LithoView createAndMeasureLithoView(ComponentContext c, Component component, int widthSpec, int heightSpec) {
        ComponentTree componentTree = ComponentTree.create((ComponentContext)c, (Component)component).build();
        LithoView lithoView = new LithoView(c);
        lithoView.setComponentTree(componentTree);
        lithoView.onAttachedToWindow();
        lithoView.measure(widthSpec, heightSpec);
        componentTree.measure(widthSpec, heightSpec, LAYOUT_SIZE_OUT, false);
        return lithoView;
    }

    public static void createLithoViewAndExecLifecycleMethods(ComponentContext c, Component component, int widthSpec, int heightSpec) {
        ComponentTree componentTree = ComponentTree.create((ComponentContext)c, (Component)component).build();
        LithoView lithoView = new LithoView(c.getAndroidContext());
        lithoView.setComponentTree(componentTree);
        lithoView.onAttachedToWindow();
        lithoView.measure(widthSpec, heightSpec);
        lithoView.layout(0, 0, lithoView.getMeasuredWidth(), lithoView.getMeasuredHeight());
    }

    public static void mountLithoView(LithoView lithoView) {
        lithoView.mountComponent(null, true);
    }

    public static void unmountLithoView(LithoView lithoView) {
        lithoView.unmountAllItems();
    }

    public static void ensureMountSpec(Component component) {
        if (!Component.isMountSpec((Component)component)) {
            throw new IllegalStateException("Bind benchmark test is for MountSpec component only!");
        }
    }

    public static Object getMountContent(ComponentContext c, Component component) {
        return MountItemsPool.acquireMountContent((Context)c.getAndroidContext(), (ContentAllocator)((SpecGeneratedComponent)component));
    }

    public static void setMountStateDirty(LithoView lithoView) {
        lithoView.setMountStateDirty();
    }
}

