/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public enum LifecycleStep {
    ON_CREATE_INITIAL_STATE,
    ON_CREATE_LAYOUT,
    ON_PREPARE,
    ON_MEASURE,
    ON_BOUNDS_DEFINED,
    ON_CREATE_MOUNT_CONTENT,
    ON_MOUNT,
    ON_UNMOUNT,
    ON_BIND,
    ON_UNBIND,
    ON_ATTACHED,
    ON_BIND_DYNAMIC_VALUE,
    ON_CALCULATE_CACHED_VALUE,
    ON_CREATE_LAYOUT_WITH_SIZE_SPEC,
    ON_CREATE_MOUNT_CONTENT_POOL,
    ON_CREATE_TRANSITION,
    ON_CREATE_TREE_PROP,
    ON_FOCUSED_EVENT_VISIBLE,
    ON_ENTERED_RANGE,
    ON_ERROR,
    ON_EVENT,
    ON_EVENT_VISIBLE,
    ON_FULL_IMPRESSION_VISIBLE_EVENT,
    ON_VISIBILITY_CHANGED,
    ON_EXITED_RANGE,
    ON_LOAD_STYLE,
    ON_MEASURE_BASELINE,
    ON_POPULATE_ACCESSIBILITY_NODE,
    ON_POPULATE_EXTRA_ACCESSIBILITY_NODE,
    ON_REGISTER_RANGES,
    ON_TRIGGER,
    ON_UPDATE_STATE,
    ON_UPDATE_STATE_WITH_TRANSITION,
    ON_DETACHED,
    ON_UNFOCUSED_EVENT_VISIBLE,
    ON_EVENT_INVISIBLE,
    SHOULD_UPDATE,
    RENDER;


    public static List<LifecycleStep> getSteps(List<StepInfo> infos) {
        ArrayList<LifecycleStep> steps = new ArrayList<LifecycleStep>(infos.size());
        for (StepInfo info : infos) {
            steps.add(info.step);
        }
        return steps;
    }

    public static class StepInfo {
        public final LifecycleStep step;
        @Nullable
        public final Object[] args;

        public StepInfo(LifecycleStep step) {
            this.step = step;
            this.args = null;
        }

        public StepInfo(LifecycleStep step, Object ... args) {
            this.step = step;
            this.args = args;
        }
    }
}

