/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.PerfEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class TestPerfEvent
implements PerfEvent {
    private static final AtomicInteger sInstanceCounter = new AtomicInteger(0);
    private final int mMarkerId;
    private final Map<String, Object> mAnnotations = new HashMap<String, Object>();
    private final List<String> mPoints = new LinkedList<String>();

    public TestPerfEvent(int markerId) {
        this.mMarkerId = markerId;
    }

    public int getInstanceKey() {
        return sInstanceCounter.getAndIncrement();
    }

    public int getMarkerId() {
        return this.mMarkerId;
    }

    public void markerAnnotate(String annotationKey, @Nullable String annotationValue) {
        this.mAnnotations.put(annotationKey, annotationValue);
    }

    public void markerAnnotate(String annotationKey, double annotationValue) {
        this.mAnnotations.put(annotationKey, annotationValue);
    }

    public void markerAnnotate(String annotationKey, int annotationValue) {
        this.mAnnotations.put(annotationKey, annotationValue);
    }

    public void markerAnnotate(String annotationKey, boolean annotationValue) {
        this.mAnnotations.put(annotationKey, annotationValue);
    }

    public void markerAnnotate(String annotationKey, String[] annotationValue) {
        this.mAnnotations.put(annotationKey, annotationValue);
    }

    public void markerAnnotate(String annotationKey, Double[] annotationValue) {
        this.mAnnotations.put(annotationKey, annotationValue);
    }

    public void markerAnnotate(String annotationKey, int[] annotationValue) {
        this.mAnnotations.put(annotationKey, annotationValue);
    }

    public void markerPoint(String eventName) {
        this.mPoints.add(eventName);
    }

    public Map<String, Object> getAnnotations() {
        return this.mAnnotations;
    }

    public List<String> getPoints() {
        return this.mPoints;
    }

    public String toString() {
        StringBuilder annotations = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.mAnnotations.entrySet()) {
            annotations.append(entry.getKey());
            annotations.append("=");
            if (entry.getValue() instanceof Object[]) {
                annotations.append(Arrays.toString((Object[])entry.getValue()));
            } else if (entry.getValue() instanceof int[]) {
                annotations.append(Arrays.toString((int[])entry.getValue()));
            } else {
                annotations.append(entry.getValue());
            }
            annotations.append(";");
        }
        return "TestPerfEvent{mMarkerId=" + this.mMarkerId + ", mAnnotations={" + annotations + "}, mPoints=" + this.mPoints + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestPerfEvent that = (TestPerfEvent)o;
        return this.mMarkerId == that.mMarkerId && Objects.equals(this.mAnnotations, that.mAnnotations) && Objects.equals(this.mPoints, that.mPoints);
    }

    public int hashCode() {
        return Objects.hash(this.mMarkerId, this.mAnnotations, this.mPoints);
    }
}

