/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.testing.BaseThreadLooperController;
import com.facebook.litho.testing.ResolveAndLayoutThreadLooperController;
import com.facebook.litho.testing.ThreadLooperController;
import com.facebook.litho.testing.TimeOutSemaphore;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BackgroundLayoutLooperRule
implements TestRule {
    BaseThreadLooperController threadLooperController = new ThreadLooperController();

    private void ensureThreadLooperType() {
        if (ComponentsConfiguration.isSplitResolveAndLayoutWithSplitHandlers() && this.threadLooperController instanceof ThreadLooperController) {
            this.threadLooperController = new ResolveAndLayoutThreadLooperController();
        } else if (!ComponentsConfiguration.isSplitResolveAndLayoutWithSplitHandlers() && this.threadLooperController instanceof ResolveAndLayoutThreadLooperController) {
            this.threadLooperController = new ThreadLooperController();
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                BackgroundLayoutLooperRule.this.ensureThreadLooperType();
                BackgroundLayoutLooperRule.this.threadLooperController.init();
                try {
                    base.evaluate();
                }
                finally {
                    BackgroundLayoutLooperRule.this.threadLooperController.clean();
                }
            }
        };
    }

    public void runOneTaskSync() {
        this.ensureThreadLooperType();
        this.threadLooperController.runOneTaskSync();
    }

    public void runToEndOfTasksSync() {
        this.ensureThreadLooperType();
        this.threadLooperController.runToEndOfTasksSync();
    }

    public TimeOutSemaphore runToEndOfTasksAsync() {
        this.ensureThreadLooperType();
        return this.threadLooperController.runToEndOfTasksAsync();
    }
}

