/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import android.app.Instrumentation;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import androidx.test.InstrumentationRegistry;
import com.facebook.litho.LithoView;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.TestItem;
import com.facebook.litho.testing.ViewForTestKeyNotFoundException;

public class InteractionUtil {
    @Deprecated
    public static void scrollTo(final RecyclerView recyclerView, final int targetScrollY) {
        int MAX_ITERATIONS = 100;
        int iterations = 0;
        while (targetScrollY != recyclerView.computeVerticalScrollOffset()) {
            if (iterations > 100) {
                throw new RuntimeException("Timed out trying to get to the correct scroll position! target: " + targetScrollY + ", final: " + recyclerView.computeVerticalScrollOffset());
            }
            InstrumentationRegistry.getInstrumentation().runOnMainSync(new Runnable(){

                @Override
                public void run() {
                    recyclerView.smoothScrollBy(0, targetScrollY - recyclerView.computeVerticalScrollOffset());
                }
            });
            InstrumentationRegistry.getInstrumentation().waitForIdleSync();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ++iterations;
        }
    }

    public static void click(View view) {
        int[] locationOnScreen = new int[2];
        view.getLocationOnScreen(locationOnScreen);
        InteractionUtil.click(new Point(locationOnScreen[0] + view.getWidth() / 2, locationOnScreen[1] + view.getHeight() / 2));
    }

    public static void click(LithoView lithoView, String testKey) {
        TestItem testItem = LithoViewTestHelper.findTestItem((LithoView)lithoView, (String)testKey);
        if (testItem == null) {
            throw new ViewForTestKeyNotFoundException(testKey);
        }
        Rect testItemBounds = testItem.getBounds();
        int[] locationOnScreen = new int[2];
        lithoView.getLocationOnScreen(locationOnScreen);
        InteractionUtil.click(new Point(locationOnScreen[0] + testItemBounds.centerX(), locationOnScreen[1] + testItemBounds.centerY()));
    }

    public static void clickBottom(LithoView lithoView, String testKey) {
        TestItem testItem = LithoViewTestHelper.findTestItem((LithoView)lithoView, (String)testKey);
        Rect testItemBounds = testItem.getBounds();
        int[] locationOnScreen = new int[2];
        lithoView.getLocationOnScreen(locationOnScreen);
        InteractionUtil.click(new Point(locationOnScreen[0] + testItemBounds.centerX(), locationOnScreen[1] + testItemBounds.bottom - 1));
    }

    public static void click(Point location) {
        long time = SystemClock.uptimeMillis();
        MotionEvent actionDownEvent = MotionEvent.obtain((long)time, (long)time, (int)0, (float)location.x, (float)location.y, (int)0);
        MotionEvent actionUpEvent = MotionEvent.obtain((long)(time + 100L), (long)(time + 100L), (int)1, (float)location.x, (float)location.y, (int)0);
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        instrumentation.sendPointerSync(actionDownEvent);
        instrumentation.sendPointerSync(actionUpEvent);
        instrumentation.waitForIdleSync();
    }

    public static class Scroller
    extends RecyclerView.OnScrollListener {
        private static final int MAX_ITERATIONS = 100;
        private final RecyclerView mRecyclerView;
        private int mScrollPositionX;
        private int mScrollPositionY;

        public Scroller(RecyclerView recyclerView) {
            this.mRecyclerView = recyclerView;
            recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
        }

        public void onScrolled(RecyclerView rv, int dx, int dy) {
            super.onScrolled(rv, dx, dy);
            this.mScrollPositionX += dx;
            this.mScrollPositionY += dy;
        }

        public void scrollToPositionX(int targetPositionX) {
            this.scrollTo(true, targetPositionX);
        }

        public void scrollToPositionY(int targetPositionY) {
            this.scrollTo(false, targetPositionY);
        }

        private void scrollTo(final boolean xAxis, final int targetPosition) {
            int iterations = 0;
            while (targetPosition != this.getScrollPosition(xAxis)) {
                if (iterations > 100) {
                    throw new RuntimeException("Timed out trying to get to the correct scroll position! target: " + targetPosition + ", final: " + this.getScrollPosition(xAxis));
                }
                InstrumentationRegistry.getInstrumentation().runOnMainSync(new Runnable(){

                    @Override
                    public void run() {
                        mRecyclerView.smoothScrollBy(0, targetPosition - this.getScrollPosition(xAxis));
                    }
                });
                InstrumentationRegistry.getInstrumentation().waitForIdleSync();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ++iterations;
            }
        }

        private int getScrollPosition(boolean xAxis) {
            return xAxis ? this.mScrollPositionX : this.mScrollPositionY;
        }
    }
}

