/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.Component;
import com.facebook.litho.LithoView;
import com.facebook.litho.sections.widget.SectionBinderTarget;
import com.facebook.litho.testing.TestCollectionItem;
import com.facebook.litho.testing.Whitebox;
import com.facebook.litho.widget.ComponentTreeHolder;
import com.facebook.litho.widget.Recycler;
import com.facebook.litho.widget.RecyclerBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010)\u001a\u0004\u0018\u00010\n2\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+H\u0086\bJ\u001b\u0010)\u001a\u0004\u0018\u00010\n2\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0-H\u0086\bJ8\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\"\u0010*\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020,0+0/\"\n\u0012\u0006\b\u0001\u0012\u00020,0+H\u0086\b\u00a2\u0006\u0002\u00100J8\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\"\u0010*\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020,0-0/\"\n\u0012\u0006\b\u0001\u0012\u00020,0-H\u0086\b\u00a2\u0006\u0002\u00101J%\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0014\u00102\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020,0+0\u0012H\u0081\bJ\u0011\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0006H\u0086\bJ\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0012R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u00128F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0014\u00a8\u00067"}, d2={"Lcom/facebook/litho/testing/TestCollection;", "", "recycler", "Lcom/facebook/litho/widget/Recycler;", "(Lcom/facebook/litho/widget/Recycler;)V", "firstFullyVisibleIndex", "", "getFirstFullyVisibleIndex", "()I", "firstItem", "Lcom/facebook/litho/testing/TestCollectionItem;", "getFirstItem", "()Lcom/facebook/litho/testing/TestCollectionItem;", "firstVisibleIndex", "getFirstVisibleIndex", "firstVisibleItem", "getFirstVisibleItem", "fullyVisibleItems", "", "getFullyVisibleItems", "()Ljava/util/List;", "itemCount", "getItemCount", "items", "getItems", "lastFullyVisibleIndex", "getLastFullyVisibleIndex", "lastItem", "getLastItem", "lastVisibleIndex", "getLastVisibleIndex", "lastVisibleItem", "getLastVisibleItem", "recyclerBinder", "Lcom/facebook/litho/widget/RecyclerBinder;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getRecyclerView$litho_testing_release", "()Landroidx/recyclerview/widget/RecyclerView;", "visibleItems", "getVisibleItems", "findFirstItem", "clazz", "Ljava/lang/Class;", "Lcom/facebook/litho/Component;", "Lkotlin/reflect/KClass;", "findItems", "", "([Ljava/lang/Class;)Ljava/util/List;", "([Lkotlin/reflect/KClass;)Ljava/util/List;", "classes", "getItemAtIndex", "index", "getLithoViews", "Lcom/facebook/litho/LithoView;", "litho-testing_release"})
public final class TestCollection {
    @NotNull
    private RecyclerBinder recyclerBinder;

    public TestCollection(@NotNull Recycler recycler) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Object t = Whitebox.getInternalState(recycler, "binder");
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.facebook.litho.sections.widget.SectionBinderTarget");
        SectionBinderTarget binder = (SectionBinderTarget)t;
        Object t2 = Whitebox.getInternalState(binder, "mRecyclerBinder");
        Intrinsics.checkNotNullExpressionValue(t2, (String)"getInternalState(binder, \"mRecyclerBinder\")");
        this.recyclerBinder = (RecyclerBinder)t2;
    }

    public final int getItemCount() {
        return this.recyclerBinder.getItemCount();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestCollectionItem> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getItemCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ComponentTreeHolder componentTreeHolder = this.recyclerBinder.getComponentTreeHolderAt((int)it);
            Intrinsics.checkNotNullExpressionValue((Object)componentTreeHolder, (String)"recyclerBinder.getComponentTreeHolderAt(it)");
            collection.add(new TestCollectionItem(this, componentTreeHolder, (int)it));
        }
        return (List)destination$iv$iv;
    }

    public final int getFirstVisibleIndex() {
        return this.recyclerBinder.findFirstVisibleItemPosition();
    }

    public final int getFirstFullyVisibleIndex() {
        return this.recyclerBinder.findFirstFullyVisibleItemPosition();
    }

    public final int getLastVisibleIndex() {
        return this.recyclerBinder.findLastVisibleItemPosition();
    }

    public final int getLastFullyVisibleIndex() {
        return this.recyclerBinder.findLastFullyVisibleItemPosition();
    }

    @NotNull
    public final List<TestCollectionItem> getVisibleItems() {
        return this.recyclerBinder.findFirstVisibleItemPosition() != -1 ? CollectionsKt.slice(this.getItems(), (IntRange)new IntRange(this.recyclerBinder.findFirstVisibleItemPosition(), this.recyclerBinder.findLastVisibleItemPosition())) : CollectionsKt.emptyList();
    }

    @NotNull
    public final List<TestCollectionItem> getFullyVisibleItems() {
        return this.recyclerBinder.findFirstVisibleItemPosition() != -1 ? CollectionsKt.slice(this.getItems(), (IntRange)new IntRange(this.recyclerBinder.findFirstFullyVisibleItemPosition(), this.recyclerBinder.findLastFullyVisibleItemPosition())) : CollectionsKt.emptyList();
    }

    @NotNull
    public final TestCollectionItem getFirstItem() {
        return (TestCollectionItem)CollectionsKt.first(this.getItems());
    }

    @NotNull
    public final TestCollectionItem getFirstVisibleItem() {
        return (TestCollectionItem)CollectionsKt.first(this.getVisibleItems());
    }

    @NotNull
    public final TestCollectionItem getLastItem() {
        return (TestCollectionItem)CollectionsKt.last(this.getItems());
    }

    @NotNull
    public final TestCollectionItem getLastVisibleItem() {
        return (TestCollectionItem)CollectionsKt.last(this.getVisibleItems());
    }

    @NotNull
    public final TestCollectionItem getItemAtIndex(int index) {
        boolean $i$f$getItemAtIndex = false;
        return this.getItems().get(index);
    }

    @Nullable
    public final TestCollectionItem findFirstItem(@NotNull Class<? extends Component> clazz) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            boolean $i$f$findFirstItem = false;
            Iterable iterable = this.getItems();
            for (Object t : iterable) {
                TestCollectionItem it = (TestCollectionItem)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getComponent().getClass(), clazz)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TestCollectionItem findFirstItem(@NotNull KClass<? extends Component> clazz) {
        Object v0;
        block1: {
            void this_$iv;
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            boolean $i$f$findFirstItem = false;
            TestCollection testCollection = this;
            Class clazz$iv = JvmClassMappingKt.getJavaClass(clazz);
            boolean $i$f$findFirstItem2 = false;
            Iterable iterable = this_$iv.getItems();
            for (Object t : iterable) {
                TestCollectionItem it$iv = (TestCollectionItem)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it$iv.getComponent().getClass(), (Object)clazz$iv)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public final List<TestCollectionItem> findItems(@NotNull List<? extends Class<? extends Component>> classes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        boolean $i$f$findItems = false;
        Iterable $this$filter$iv = this.getItems();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestCollectionItem it = (TestCollectionItem)element$iv$iv;
            boolean bl = false;
            if (!classes.contains(it.getComponent().getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestCollectionItem> findItems(Class<? extends Component> ... clazz) {
        void $this$filterTo$iv$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        boolean $i$f$findItems = false;
        TestCollection testCollection = this;
        List classes$iv = ArraysKt.toList((Object[])clazz);
        boolean $i$f$findItems2 = false;
        Iterable $this$filter$iv$iv = this_$iv.getItems();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            TestCollectionItem it$iv = (TestCollectionItem)element$iv$iv$iv;
            boolean bl = false;
            if (!classes$iv.contains(it$iv.getComponent().getClass())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestCollectionItem> findItems(KClass<? extends Component> ... clazz) {
        void $this$filterTo$iv$iv$iv;
        void this_$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        boolean $i$f$findItems = false;
        TestCollection testCollection = this;
        Object $this$map$iv = clazz;
        boolean $i$f$map = false;
        KClass<? extends Component>[] kClassArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((KClass<? extends Component>[])$this$map$iv).length);
        boolean $i$f$mapTo22 = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmClassMappingKt.getJavaClass((KClass)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$findItems2 = false;
        Iterable $this$filter$iv$iv = this_$iv.getItems();
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            void classes$iv;
            TestCollectionItem it$iv = (TestCollectionItem)element$iv$iv$iv;
            boolean bl = false;
            if (!classes$iv.contains(it$iv.getComponent().getClass())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LithoView> getLithoViews() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)new IntRange(this.getFirstVisibleIndex(), this.getLastVisibleIndex());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LithoView it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            RecyclerView.LayoutManager layoutManager = this.getRecyclerView$litho_testing_release().getLayoutManager();
            Object object = layoutManager != null ? layoutManager.findViewByPosition(it) : null;
            if ((object instanceof LithoView ? (LithoView)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final RecyclerView getRecyclerView$litho_testing_release() {
        RecyclerView recyclerView;
        RecyclerView recyclerView2 = recyclerView = (RecyclerView)Whitebox.getInternalState(this.recyclerBinder, "mMountedView");
        if (recyclerView2 == null) {
            boolean bl = false;
            String string = "We could not find a mounted recycler view.  This normally happens if you did not provide an \nexplicit size when rendering your component for test.  To fix this, add a width and height \nwhen rendering the component: `lithoViewRule.render(widthPx = 100, heightPx = 100) { ... }`.";
            throw new IllegalArgumentException(string.toString());
        }
        return recyclerView2;
    }
}

