/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.testing.TestCollection;
import com.facebook.litho.testing.TestCollectionItem;
import com.facebook.litho.testing.viewtree.ViewExtractors;
import com.facebook.litho.testing.viewtree.ViewTree;
import com.google.common.base.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/litho/testing/TestCollectionDescriptionHelper;", "", "()V", "DEPTH_3_LEADING_SPACE", "", "ITEM_STARTING_DEPTH", "", "collectionToString", "testCollection", "Lcom/facebook/litho/testing/TestCollection;", "fallbackComponentPrintInfo", "component", "Lcom/facebook/litho/Component;", "getComponentInfo", "item", "Lcom/facebook/litho/testing/TestCollectionItem;", "getViewInfo", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getVisibility", "itemToString", "viewExtraTextExtractor", "view", "Landroid/view/View;", "litho-testing_release"})
public final class TestCollectionDescriptionHelper {
    @NotNull
    public static final TestCollectionDescriptionHelper INSTANCE = new TestCollectionDescriptionHelper();
    @NotNull
    private static final String DEPTH_3_LEADING_SPACE = "      ";
    private static final int ITEM_STARTING_DEPTH = 3;

    private TestCollectionDescriptionHelper() {
    }

    @NotNull
    public final String collectionToString(@NotNull TestCollection testCollection) {
        Intrinsics.checkNotNullParameter((Object)testCollection, (String)"testCollection");
        String hierarchyString = null;
        String string = testCollection.getRecyclerView$litho_testing_release().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testCollection.recyclerView.toString()");
        hierarchyString = string;
        Iterable $this$forEach$iv = testCollection.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestCollectionItem item = (TestCollectionItem)element$iv;
            boolean bl = false;
            hierarchyString = hierarchyString + INSTANCE.itemToString(item);
        }
        return hierarchyString;
    }

    private final String itemToString(TestCollectionItem item) {
        String testCollectionItemHeader = "\n\u2514\u2500\u2500 index " + item.getIndex() + ": Collection Item (id: " + item.getId() + ", visibility: " + this.getVisibility(item) + ')';
        String itemDescription = item.getRenderInfo$litho_testing_release().rendersView() ? this.getViewInfo(item, item.getRecyclerView$litho_testing_release()) : this.getComponentInfo(item);
        return testCollectionItemHeader + itemDescription;
    }

    private final String getComponentInfo(TestCollectionItem item) {
        DebugComponent debugComponent = DebugComponent.getRootInstance((ComponentTree)item.getComponentTree$litho_testing_release());
        if (debugComponent == null) {
            Component component = item.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"item.component");
            return this.fallbackComponentPrintInfo(component);
        }
        DebugComponent debugComponent2 = debugComponent;
        String string = LithoViewTestHelper.rootInstanceToString((DebugComponent)debugComponent2, (boolean)false, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rootInstanceToString(deb\u2026lse, ITEM_STARTING_DEPTH)");
        return string;
    }

    private final String fallbackComponentPrintInfo(Component component) {
        String string = component.toString();
        if (string == null) {
            string = component.getClass().getSimpleName();
        }
        String componentString = string;
        return "\n      " + componentString + '{' + component.hashCode() + "}\n";
    }

    private final String getViewInfo(TestCollectionItem item, RecyclerView recyclerView) {
        RecyclerView.ViewHolder viewHolder = recyclerView.findViewHolderForAdapterPosition(item.getIndex());
        if (viewHolder == null || (viewHolder = viewHolder.itemView) == null) {
            return "\n      Found null item view (no additional information available)\n";
        }
        RecyclerView.ViewHolder itemView = viewHolder;
        String viewTreeString = ViewTree.of((View)itemView).makeString(3, (Function<View, String>)((Function)this::viewExtraTextExtractor));
        return viewTreeString + '\n';
    }

    private final String viewExtraTextExtractor(View view) {
        String textOutput;
        String it;
        String string;
        if (view instanceof TextView || view instanceof ComponentHost) {
            String string2;
            String string3 = (String)ViewExtractors.GET_TEXT_FUNCTION.apply((Object)view);
            if (string3 != null) {
                it = string = string3;
                boolean bl = false;
                string2 = !StringsKt.startsWith$default((String)it, (String)"No text found", (boolean)false, (int)2, null) ? string : null;
            } else {
                string2 = textOutput = null;
            }
            if (textOutput != null) {
                return textOutput;
            }
        }
        if (view instanceof ImageView || view instanceof ComponentHost) {
            String string4;
            String string5 = (String)ViewExtractors.GET_DRAWABLE_FUNCTION.apply((Object)view);
            if (string5 != null) {
                it = string = string5;
                boolean bl = false;
                string4 = !StringsKt.startsWith$default((String)it, (String)"No drawable found", (boolean)false, (int)2, null) ? string : null;
            } else {
                string4 = textOutput = null;
            }
            if (textOutput != null) {
                return textOutput;
            }
        }
        return null;
    }

    private final String getVisibility(TestCollectionItem item) {
        return item.isFullyVisible() && item.isVisible() ? "full" : (item.isVisible() ? "partial" : "none");
    }
}

