/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.testing.TestComponent;
import com.facebook.litho.testing.TimeOutSemaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class TestDrawableComponent
extends TestComponent {
    private static final long IS_PURE_RENDER = 2L;
    private static final long CAN_MEASURE = 4L;
    private static final long IMPLEMENTS_ACCESSIBILITY = 16L;
    private static final long IS_MOUNT_SIZE_DEPENDENT = 32L;
    private final long mProperties;
    @Comparable(type=3)
    private int color = -16777216;
    @Comparable(type=3)
    private int measuredWidth = -1;
    @Comparable(type=3)
    private int measuredHeight = -1;
    @Comparable(type=3)
    private boolean mReturnSelfInMakeShallowCopy;
    @Comparable(type=13)
    private TestComponentListener mTestComponentListener;

    private TestDrawableComponent(long properties) {
        super("TestDrawableComponent");
        this.mProperties = properties;
    }

    protected boolean isPureRender() {
        return (this.mProperties & 2L) != 0L;
    }

    protected boolean implementsAccessibility() {
        return (this.mProperties & 0x10L) != 0L;
    }

    public boolean isMountSizeDependent() {
        return (this.mProperties & 0x20L) != 0L;
    }

    protected Object onCreateMountContent(Context c) {
        return new ColorDrawable();
    }

    protected void onMount(ComponentContext c, Object convertDrawable, InterStagePropsContainer interStagePropsContainer) {
        ((ColorDrawable)convertDrawable).setColor(this.color);
        this.onMountCalled();
    }

    protected void onUnmount(ComponentContext c, Object mountedContent, InterStagePropsContainer interStagePropsContainer) {
        this.onUnmountCalled();
    }

    protected boolean canMeasure() {
        return (this.mProperties & 4L) != 0L;
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, InterStagePropsContainer interStagePropsContainer) {
        int width = SizeSpec.getSize((int)widthSpec);
        int height = SizeSpec.getSize((int)heightSpec);
        this.onMeasureCalled();
        size.width = this.measuredWidth != -1 ? SizeSpec.resolveSize((int)widthSpec, (int)this.measuredWidth) : width;
        size.height = this.measuredHeight != -1 ? SizeSpec.resolveSize((int)heightSpec, (int)this.measuredHeight) : height;
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout, InterStagePropsContainer interStagePropsContainer) {
        this.onDefineBoundsCalled();
    }

    protected void onBind(ComponentContext c, Object mountedContent, InterStagePropsContainer interStagePropsContainer) {
        this.onBindCalled();
    }

    protected void onUnbind(ComponentContext c, Object mountedContent, InterStagePropsContainer interStagePropsContainer) {
        this.onUnbindCalled();
    }

    public Component.MountType getMountType() {
        return Component.MountType.DRAWABLE;
    }

    public Component makeShallowCopy() {
        if (this.mReturnSelfInMakeShallowCopy) {
            return this;
        }
        return super.makeShallowCopy();
    }

    protected void onPrepare(ComponentContext c) {
        if (this.mTestComponentListener != null) {
            this.mTestComponentListener.onPrepare();
        }
        super.onPrepare(c);
    }

    public void setTestComponentListener(TestComponentListener listener) {
        this.mTestComponentListener = listener;
    }

    public static Builder create(ComponentContext context) {
        return TestDrawableComponent.create(context, 0, 0, true, true, false, false);
    }

    public static Builder create(ComponentContext context, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        return TestDrawableComponent.create(context, defStyleAttr, defStyleRes, true, true, false);
    }

    public static Builder create(ComponentContext context, boolean isPureRender, boolean canMeasure, boolean implementsAccessibility) {
        return TestDrawableComponent.create(context, 0, 0, isPureRender, canMeasure, implementsAccessibility);
    }

    public static Builder create(ComponentContext context, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, boolean isPureRender, boolean canMeasure, boolean implementsAccessibility) {
        return TestDrawableComponent.create(context, defStyleAttr, defStyleRes, isPureRender, canMeasure, implementsAccessibility, false);
    }

    public static Builder create(ComponentContext context, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, boolean isPureRender, boolean canMeasure, boolean implementsAccessibility, boolean isMountSizeDependent) {
        long properties = 0L;
        if (isPureRender) {
            properties |= 2L;
        }
        if (canMeasure) {
            properties |= 4L;
        }
        if (implementsAccessibility) {
            properties |= 0x10L;
        }
        if (isMountSizeDependent) {
            properties |= 0x20L;
        }
        return TestDrawableComponent.newBuilder(context, defStyleAttr, defStyleRes, new TestDrawableComponent(properties));
    }

    private static Builder newBuilder(ComponentContext context, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, TestDrawableComponent state) {
        return new Builder(context, defStyleAttr, defStyleRes, state);
    }

    public static class BlockInPrepareComponentListener
    implements TestComponentListener {
        private final ThreadLocal<Boolean> mDoNotBlockOnThisThread = new ThreadLocal();
        private final TimeOutSemaphore mOnAsyncPrepareStartSemaphore = new TimeOutSemaphore(0);
        private final TimeOutSemaphore mAllowPrepareToCompleteSemaphore = new TimeOutSemaphore(0);
        private final AtomicInteger mPrepareCount = new AtomicInteger(0);

        @Override
        public void onPrepare() {
            this.mPrepareCount.incrementAndGet();
            if (this.mDoNotBlockOnThisThread.get() != null && this.mDoNotBlockOnThisThread.get().booleanValue()) {
                return;
            }
            this.mOnAsyncPrepareStartSemaphore.release();
            this.mAllowPrepareToCompleteSemaphore.acquire();
            this.mOnAsyncPrepareStartSemaphore.drainPermits();
            this.mAllowPrepareToCompleteSemaphore.drainPermits();
        }

        public void awaitPrepareStart() {
            this.mOnAsyncPrepareStartSemaphore.acquire();
        }

        public void allowPrepareToComplete() {
            this.mAllowPrepareToCompleteSemaphore.release();
        }

        public void setDoNotBlockOnThisThread() {
            this.mDoNotBlockOnThisThread.set(true);
        }

        public int getPrepareCount() {
            return this.mPrepareCount.get();
        }
    }

    public static class Builder
    extends Component.Builder<Builder> {
        TestDrawableComponent mComponent;

        private Builder(ComponentContext context, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, TestDrawableComponent component) {
            super(context, defStyleAttr, defStyleRes, (Component)component);
            this.mComponent = component;
        }

        protected void setComponent(Component component) {
            this.mComponent = (TestDrawableComponent)component;
        }

        public Builder measuredWidth(int width) {
            this.mComponent.measuredWidth = width;
            return this;
        }

        public Builder measuredHeight(int height) {
            this.mComponent.measuredHeight = height;
            return this;
        }

        public Builder color(int color) {
            this.mComponent.color = color;
            return this;
        }

        public Builder returnSelfInMakeShallowCopy() {
            this.mComponent.mReturnSelfInMakeShallowCopy = true;
            return this;
        }

        public TestDrawableComponent build() {
            return this.mComponent;
        }

        public Builder getThis() {
            return this;
        }
    }

    public static interface TestComponentListener {
        public void onPrepare();
    }
}

