/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.test.core.app.ApplicationProvider;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoLayoutResult;
import com.facebook.litho.LithoLifecycleProvider;
import com.facebook.litho.LithoView;
import com.facebook.litho.componentsfinder.ComponentsFinderKt;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.testing.TestCollection;
import com.facebook.litho.testing.TestLithoViewKt;
import com.facebook.litho.testing.viewtree.ViewPredicates;
import com.facebook.litho.testing.viewtree.ViewTree;
import com.facebook.litho.widget.Recycler;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.robolectric.Shadows;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001VB'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000J9\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0)2&\u0010*\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0,0+\"\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0,\u00a2\u0006\u0002\u0010-J5\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0)2\"\u0010*\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\"0.0+\"\n\u0012\u0006\b\u0001\u0012\u00020\"0.\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u0004\u0018\u000101J\u001a\u00102\u001a\u0004\u0018\u00010\"2\u0010\u0010*\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0,J\u0018\u00102\u001a\u0004\u0018\u00010\"2\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0.J\u001a\u00103\u001a\u0004\u0018\u00010\"2\u0010\u0010*\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0,J\u0018\u00103\u001a\u0004\u0018\u00010\"2\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0.J\u0010\u00104\u001a\u0002052\b\b\u0001\u00106\u001a\u00020\u001dJ\u000e\u00104\u001a\u0002052\u0006\u00107\u001a\u000208J\u0012\u00109\u001a\u0004\u0018\u0001052\b\b\u0001\u00106\u001a\u00020\u001dJ\u0010\u00109\u001a\u0004\u0018\u0001052\u0006\u00107\u001a\u000208J \u0010:\u001a\u0004\u0018\u0001052\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002050>H\u0002J\u000e\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020\u0001J\u0010\u0010A\u001a\u0004\u0018\u0001052\u0006\u0010@\u001a\u00020\u0001J\u001c\u0010B\u001a\u0004\u0018\u0001052\b\u0010C\u001a\u0004\u0018\u0001052\u0006\u0010@\u001a\u00020\u0001H\u0002J\u0010\u0010D\u001a\u0002052\b\b\u0001\u00106\u001a\u00020\u001dJ\u000e\u0010D\u001a\u0002052\u0006\u0010E\u001a\u000208J\u0012\u0010F\u001a\u0004\u0018\u0001052\b\b\u0001\u00106\u001a\u00020\u001dJ\u0010\u0010F\u001a\u0004\u0018\u0001052\u0006\u0010E\u001a\u000208J\u0006\u0010G\u001a\u00020\u0000J\u0006\u0010H\u001a\u00020\u0000J\u0006\u0010I\u001a\u00020\u0000J\u0012\u0010J\u001a\u00020\u00002\n\u0010K\u001a\u0006\u0012\u0002\b\u00030LJ\u0010\u0010J\u001a\u00020\u00002\b\u0010M\u001a\u0004\u0018\u00010\"J \u0010N\u001a\u00020\u00002\b\u0010M\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010O\u001a\u00020\u00002\n\u0010K\u001a\u0006\u0012\u0002\b\u00030LJ\u0010\u0010O\u001a\u00020\u00002\b\u0010M\u001a\u0004\u0018\u00010\"J\u0016\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u001d2\u0006\u0010R\u001a\u00020\u001dJ\u0016\u0010S\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010T\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\u000e\u0010U\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\fR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/facebook/litho/testing/TestLithoView;", "", "context", "Lcom/facebook/litho/ComponentContext;", "componentsConfiguration", "Lcom/facebook/litho/config/ComponentsConfiguration;", "lithoLifecycleProvider", "Lcom/facebook/litho/LithoLifecycleProvider;", "(Lcom/facebook/litho/ComponentContext;Lcom/facebook/litho/config/ComponentsConfiguration;Lcom/facebook/litho/LithoLifecycleProvider;)V", "_componentTree", "Lcom/facebook/litho/ComponentTree;", "_lithoView", "Lcom/facebook/litho/LithoView;", "committedLayoutState", "Lcom/facebook/litho/LayoutState;", "getCommittedLayoutState", "()Lcom/facebook/litho/LayoutState;", "componentTree", "getComponentTree", "()Lcom/facebook/litho/ComponentTree;", "getComponentsConfiguration", "()Lcom/facebook/litho/config/ComponentsConfiguration;", "getContext", "()Lcom/facebook/litho/ComponentContext;", "currentRootNode", "Lcom/facebook/litho/LithoLayoutResult;", "getCurrentRootNode", "()Lcom/facebook/litho/LithoLayoutResult;", "heightSpec", "", "lithoView", "getLithoView", "()Lcom/facebook/litho/LithoView;", "rootComponent", "Lcom/facebook/litho/Component;", "getRootComponent", "()Lcom/facebook/litho/Component;", "widthSpec", "attachToWindow", "detachFromWindow", "findAllComponents", "", "clazz", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)Ljava/util/List;", "Lkotlin/reflect/KClass;", "([Lkotlin/reflect/KClass;)Ljava/util/List;", "findCollectionComponent", "Lcom/facebook/litho/testing/TestCollection;", "findComponent", "findDirectComponent", "findViewWithContentDescription", "Landroid/view/View;", "resourceId", "contentDescription", "", "findViewWithContentDescriptionOrNull", "findViewWithPredicateOrNull", "viewTree", "Lcom/facebook/litho/testing/viewtree/ViewTree;", "predicate", "Lcom/google/common/base/Predicate;", "findViewWithTag", "tag", "findViewWithTagOrNull", "findViewWithTagTransversal", "view", "findViewWithText", "text", "findViewWithTextOrNull", "layout", "measure", "release", "setRoot", "builder", "Lcom/facebook/litho/Component$Builder;", "component", "setRootAndSizeSpecSync", "setRootAsync", "setSizePx", "widthPx", "heightPx", "setSizeSpecs", "useComponentTree", "useLithoView", "InteractionsScope", "litho-testing_release"})
public final class TestLithoView {
    @NotNull
    private final ComponentContext context;
    @Nullable
    private final ComponentsConfiguration componentsConfiguration;
    @Nullable
    private final LithoLifecycleProvider lithoLifecycleProvider;
    private int widthSpec;
    private int heightSpec;
    @Nullable
    private LithoView _lithoView;
    @Nullable
    private ComponentTree _componentTree;

    public TestLithoView(@NotNull ComponentContext context, @Nullable ComponentsConfiguration componentsConfiguration, @Nullable LithoLifecycleProvider lithoLifecycleProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.componentsConfiguration = componentsConfiguration;
        this.lithoLifecycleProvider = lithoLifecycleProvider;
        this.widthSpec = TestLithoViewKt.DEFAULT_WIDTH_SPEC;
        this.heightSpec = TestLithoViewKt.DEFAULT_HEIGHT_SPEC;
    }

    public /* synthetic */ TestLithoView(ComponentContext componentContext, ComponentsConfiguration componentsConfiguration, LithoLifecycleProvider lithoLifecycleProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            componentsConfiguration = null;
        }
        if ((n & 4) != 0) {
            lithoLifecycleProvider = null;
        }
        this(componentContext, componentsConfiguration, lithoLifecycleProvider);
    }

    @NotNull
    public final ComponentContext getContext() {
        return this.context;
    }

    @Nullable
    public final ComponentsConfiguration getComponentsConfiguration() {
        return this.componentsConfiguration;
    }

    @NotNull
    public final ComponentTree getComponentTree() {
        if (this._componentTree == null) {
            this._componentTree = ComponentTree.create((ComponentContext)this.context).withLithoLifecycleProvider(this.lithoLifecycleProvider).componentsConfiguration(this.componentsConfiguration).build();
        }
        ComponentTree componentTree = this._componentTree;
        if (componentTree == null) {
            throw new AssertionError((Object)"Set to null by another thread");
        }
        return componentTree;
    }

    @NotNull
    public final LithoView getLithoView() {
        if (this._lithoView == null) {
            this._lithoView = new LithoView(this.context);
        }
        LithoView lithoView = this._lithoView;
        if ((lithoView != null ? lithoView.getComponentTree() : null) == null) {
            LithoView lithoView2 = this._lithoView;
            if (lithoView2 != null) {
                lithoView2.setComponentTree(this.getComponentTree());
            }
        }
        LithoView lithoView3 = this._lithoView;
        if (lithoView3 == null) {
            throw new AssertionError((Object)"Set to null by another thread");
        }
        return lithoView3;
    }

    @Nullable
    public final Component getRootComponent() {
        return ComponentsFinderKt.getRootComponentInLithoView(this.getLithoView());
    }

    @VisibleForTesting(otherwise=5)
    @Nullable
    public final LayoutState getCommittedLayoutState() {
        return this.getComponentTree().getCommittedLayoutState();
    }

    @VisibleForTesting(otherwise=5)
    @Nullable
    public final LithoLayoutResult getCurrentRootNode() {
        LayoutState layoutState = this.getCommittedLayoutState();
        return layoutState != null ? layoutState.getRootLayoutResult() : null;
    }

    @NotNull
    public final TestLithoView useLithoView(@NotNull LithoView lithoView) {
        Intrinsics.checkNotNullParameter((Object)lithoView, (String)"lithoView");
        this._lithoView = lithoView;
        if (lithoView.getComponentContext() != this.context) {
            throw new RuntimeException("You must use the same ComponentContext for the LithoView as what is on the LithoViewRule @Rule!");
        }
        ComponentTree it = lithoView.getComponentTree();
        boolean bl = false;
        if (it == null && this._componentTree != null) {
            lithoView.setComponentTree(this._componentTree);
        } else {
            this._componentTree = it;
        }
        return this;
    }

    @NotNull
    public final TestLithoView useComponentTree(@Nullable ComponentTree componentTree) {
        this._componentTree = componentTree;
        this.getLithoView().setComponentTree(componentTree);
        return this;
    }

    @NotNull
    public final TestLithoView setRoot(@Nullable Component component) {
        this.getComponentTree().setRoot(component);
        return this;
    }

    @NotNull
    public final TestLithoView setRoot(@NotNull Component.Builder<?> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.getComponentTree().setRoot(builder.build());
        return this;
    }

    @NotNull
    public final TestLithoView setRootAsync(@Nullable Component component) {
        this.getComponentTree().setRootAsync(component);
        return this;
    }

    @NotNull
    public final TestLithoView setRootAsync(@NotNull Component.Builder<?> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.getComponentTree().setRootAsync(builder.build());
        return this;
    }

    @NotNull
    public final TestLithoView setRootAndSizeSpecSync(@Nullable Component component, int widthSpec, int heightSpec) {
        this.widthSpec = widthSpec;
        this.heightSpec = heightSpec;
        this.getComponentTree().setRootAndSizeSpecSync(component, this.widthSpec, this.heightSpec);
        return this;
    }

    @NotNull
    public final TestLithoView setSizePx(int widthPx, int heightPx) {
        this.widthSpec = View.MeasureSpec.makeMeasureSpec((int)widthPx, (int)0x40000000);
        this.heightSpec = View.MeasureSpec.makeMeasureSpec((int)heightPx, (int)0x40000000);
        return this;
    }

    @NotNull
    public final TestLithoView setSizeSpecs(int widthSpec, int heightSpec) {
        this.widthSpec = widthSpec;
        this.heightSpec = heightSpec;
        return this;
    }

    @NotNull
    public final TestLithoView measure() {
        this.getLithoView().measure(this.widthSpec, this.heightSpec);
        return this;
    }

    @NotNull
    public final TestLithoView layout() {
        LithoView lithoView = this.getLithoView();
        lithoView.layout(0, 0, lithoView.getMeasuredWidth(), lithoView.getMeasuredHeight());
        return this;
    }

    @NotNull
    public final TestLithoView attachToWindow() {
        this.getLithoView().onAttachedToWindowForTest();
        return this;
    }

    @NotNull
    public final TestLithoView detachFromWindow() {
        this.getLithoView().onDetachedFromWindowForTest();
        return this;
    }

    @NotNull
    public final TestLithoView release() {
        this.getLithoView().release();
        return this;
    }

    @Nullable
    public final View findViewWithTagOrNull(@NotNull Object tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.findViewWithTagTransversal((View)this.getLithoView(), tag);
    }

    @NotNull
    public final View findViewWithTag(@NotNull Object tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        View view = this.findViewWithTagOrNull(tag);
        if (view == null) {
            throw new RuntimeException("Did not find view with tag '" + tag + '\'');
        }
        return view;
    }

    private final View findViewWithTagTransversal(View view, Object tag) {
        int n;
        int i;
        if (view == null || Intrinsics.areEqual((Object)view.getTag(), (Object)tag)) {
            return view;
        }
        if (view instanceof ViewGroup && (i = 0) <= (n = ((ViewGroup)view).getChildCount())) {
            while (true) {
                View child;
                if ((child = this.findViewWithTagTransversal(((ViewGroup)view).getChildAt(i), tag)) != null) {
                    return child;
                }
                if (i == n) break;
                ++i;
            }
        }
        return null;
    }

    @Nullable
    public final View findViewWithTextOrNull(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ViewTree viewTree = ViewTree.of((View)this.getLithoView());
        Intrinsics.checkNotNullExpressionValue((Object)viewTree, (String)"viewTree");
        Predicate<View> predicate = ViewPredicates.hasVisibleText(text);
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"hasVisibleText(text)");
        return this.findViewWithPredicateOrNull(viewTree, predicate);
    }

    @NotNull
    public final View findViewWithText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        View view = this.findViewWithTextOrNull(text);
        if (view == null) {
            throw new RuntimeException("Did not find view with text '" + text + '\'');
        }
        return view;
    }

    @Nullable
    public final View findViewWithContentDescriptionOrNull(@NotNull String contentDescription) {
        Intrinsics.checkNotNullParameter((Object)contentDescription, (String)"contentDescription");
        ViewTree viewTree = ViewTree.of((View)this.getLithoView());
        Intrinsics.checkNotNullExpressionValue((Object)viewTree, (String)"viewTree");
        Predicate<View> predicate = ViewPredicates.hasContentDescription(contentDescription);
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"hasContentDescription(contentDescription)");
        return this.findViewWithPredicateOrNull(viewTree, predicate);
    }

    @NotNull
    public final View findViewWithContentDescription(@NotNull String contentDescription) {
        Intrinsics.checkNotNullParameter((Object)contentDescription, (String)"contentDescription");
        View view = this.findViewWithContentDescriptionOrNull(contentDescription);
        if (view == null) {
            throw new RuntimeException("Did not find view with contentDescription '" + contentDescription + '\'');
        }
        return view;
    }

    @Nullable
    public final View findViewWithTextOrNull(@StringRes int resourceId) {
        ViewTree viewTree = ViewTree.of((View)this.getLithoView());
        String string = ApplicationProvider.getApplicationContext().getResources().getString(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationContext<Co\u2026ces.getString(resourceId)");
        String text = string;
        Intrinsics.checkNotNullExpressionValue((Object)viewTree, (String)"viewTree");
        Predicate<View> predicate = ViewPredicates.hasVisibleText(text);
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"hasVisibleText(text)");
        return this.findViewWithPredicateOrNull(viewTree, predicate);
    }

    @NotNull
    public final View findViewWithText(@StringRes int resourceId) {
        String string = ApplicationProvider.getApplicationContext().getResources().getString(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationContext<Co\u2026ces.getString(resourceId)");
        return this.findViewWithText(string);
    }

    @Nullable
    public final View findViewWithContentDescriptionOrNull(@StringRes int resourceId) {
        ViewTree viewTree = ViewTree.of((View)this.getLithoView());
        String string = ApplicationProvider.getApplicationContext().getResources().getString(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationContext<Co\u2026ces.getString(resourceId)");
        String contentDescription = string;
        Intrinsics.checkNotNullExpressionValue((Object)viewTree, (String)"viewTree");
        Predicate<View> predicate = ViewPredicates.hasContentDescription(contentDescription);
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"hasContentDescription(contentDescription)");
        return this.findViewWithPredicateOrNull(viewTree, predicate);
    }

    @NotNull
    public final View findViewWithContentDescription(@StringRes int resourceId) {
        String string = ApplicationProvider.getApplicationContext().getResources().getString(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationContext<Co\u2026ces.getString(resourceId)");
        return this.findViewWithContentDescription(string);
    }

    @Nullable
    public final Component findDirectComponent(@NotNull KClass<? extends Component> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return ComponentsFinderKt.findDirectComponentInLithoView(this.getLithoView(), clazz);
    }

    @Nullable
    public final Component findDirectComponent(@NotNull Class<? extends Component> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return ComponentsFinderKt.findDirectComponentInLithoView(this.getLithoView(), clazz);
    }

    @Nullable
    public final Component findComponent(@NotNull KClass<? extends Component> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return ComponentsFinderKt.findComponentInLithoView(this.getLithoView(), clazz);
    }

    @Nullable
    public final Component findComponent(@NotNull Class<? extends Component> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return ComponentsFinderKt.findComponentInLithoView(this.getLithoView(), clazz);
    }

    @NotNull
    public final List<Component> findAllComponents(KClass<? extends Component> ... clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return ComponentsFinderKt.findAllComponentsInLithoView(this.getLithoView(), Arrays.copyOf(clazz, clazz.length));
    }

    @NotNull
    public final List<Component> findAllComponents(Class<? extends Component> ... clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return ComponentsFinderKt.findAllComponentsInLithoView(this.getLithoView(), Arrays.copyOf(clazz, clazz.length));
    }

    private final View findViewWithPredicateOrNull(ViewTree viewTree, Predicate<View> predicate) {
        ImmutableList<View> immutableList = viewTree.findChild(predicate);
        return immutableList != null ? (View)CollectionsKt.last((List)((List)immutableList)) : null;
    }

    @Nullable
    public final TestCollection findCollectionComponent() {
        Recycler recycler = (Recycler)this.findComponent(Recycler.class);
        if (recycler == null) {
            return null;
        }
        Recycler recycler2 = recycler;
        return new TestCollection(recycler2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lcom/facebook/litho/testing/TestLithoView$InteractionsScope;", "", "(Lcom/facebook/litho/testing/TestLithoView;)V", "clickOnContentDescription", "", "resourceId", "", "contentDescription", "", "clickOnRootView", "", "clickOnTag", "tag", "clickOnText", "text", "litho-testing_release"})
    public final class InteractionsScope {
        public final boolean clickOnText(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return TestLithoView.this.findViewWithText(text).performClick();
        }

        public final boolean clickOnTag(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return TestLithoView.this.findViewWithTag(tag).performClick();
        }

        public final boolean clickOnContentDescription(@NotNull String contentDescription) {
            Intrinsics.checkNotNullParameter((Object)contentDescription, (String)"contentDescription");
            return TestLithoView.this.findViewWithContentDescription(contentDescription).performClick();
        }

        public final void clickOnRootView() {
            if (Shadows.shadowOf((ViewGroup)((ViewGroup)TestLithoView.this.getLithoView())).getOnClickListener() == null) {
                boolean bl = false;
                String string = "No click handling found on root view.  The root view must be clickable in order to use this function.";
                throw new IllegalStateException(string.toString());
            }
            TestLithoView.this.getLithoView().performClick();
        }

        public final boolean clickOnText(@StringRes int resourceId) {
            return TestLithoView.this.findViewWithText(resourceId).performClick();
        }

        public final boolean clickOnTag(@StringRes int resourceId) {
            return TestLithoView.this.findViewWithTag(resourceId).performClick();
        }

        public final boolean clickOnContentDescription(@StringRes int resourceId) {
            return TestLithoView.this.findViewWithContentDescription(resourceId).performClick();
        }
    }
}

