/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import android.os.Looper;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.testing.BaseThreadLooperController;
import com.facebook.litho.testing.LayoutLooperThread;
import com.facebook.litho.testing.Message;
import com.facebook.litho.testing.MessageType;
import com.facebook.litho.testing.TimeOutSemaphore;
import com.facebook.litho.testing.Whitebox;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.robolectric.Shadows;
import org.robolectric.annotation.LooperMode;
import org.robolectric.shadows.ShadowLooper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/litho/testing/ThreadLooperController;", "Lcom/facebook/litho/testing/BaseThreadLooperController;", "layoutLooper", "Lorg/robolectric/shadows/ShadowLooper;", "(Lorg/robolectric/shadows/ShadowLooper;)V", "isInitialized", "", "getLayoutLooper", "()Lorg/robolectric/shadows/ShadowLooper;", "messageQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/facebook/litho/testing/Message;", "clean", "", "init", "quitSync", "runOneTaskSync", "runToEndOfTasksAsync", "Lcom/facebook/litho/testing/TimeOutSemaphore;", "runToEndOfTasksSync", "litho-testing_release"})
public final class ThreadLooperController
implements BaseThreadLooperController {
    @NotNull
    private final ShadowLooper layoutLooper;
    private BlockingQueue<Message> messageQueue;
    private boolean isInitialized;

    public ThreadLooperController(@NotNull ShadowLooper layoutLooper) {
        Intrinsics.checkNotNullParameter((Object)layoutLooper, (String)"layoutLooper");
        this.layoutLooper = layoutLooper;
    }

    public /* synthetic */ ThreadLooperController(ShadowLooper shadowLooper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Object t = Whitebox.invokeMethod(ComponentTree.class, "getDefaultLayoutThreadLooper", new Object[0]);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type android.os.Looper");
            ShadowLooper shadowLooper2 = Shadows.shadowOf((Looper)((Looper)t));
            Intrinsics.checkNotNullExpressionValue((Object)shadowLooper2, (String)"shadowOf(\n            Wh\u2026               as Looper)");
            shadowLooper = shadowLooper2;
        }
        this(shadowLooper);
    }

    @NotNull
    public final ShadowLooper getLayoutLooper() {
        return this.layoutLooper;
    }

    @Override
    public void init() {
        this.messageQueue = new ArrayBlockingQueue(100);
        BlockingQueue<Message> blockingQueue = this.messageQueue;
        if (blockingQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageQueue");
            blockingQueue = null;
        }
        LayoutLooperThread layoutLooperThread = new LayoutLooperThread(this.layoutLooper, blockingQueue);
        layoutLooperThread.start();
        this.isInitialized = true;
    }

    @Override
    public void clean() {
        if (!this.isInitialized) {
            return;
        }
        this.quitSync();
        if (ShadowLooper.looperMode() != LooperMode.Mode.PAUSED) {
            this.layoutLooper.quitUnchecked();
        }
        this.isInitialized = false;
    }

    private final void quitSync() {
        TimeOutSemaphore semaphore = new TimeOutSemaphore(0);
        BlockingQueue<Message> blockingQueue = this.messageQueue;
        if (blockingQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageQueue");
            blockingQueue = null;
        }
        blockingQueue.add(new Message(MessageType.QUIT, semaphore));
        semaphore.acquire();
    }

    @Override
    public void runOneTaskSync() {
        TimeOutSemaphore semaphore = new TimeOutSemaphore(0);
        BlockingQueue<Message> blockingQueue = this.messageQueue;
        if (blockingQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageQueue");
            blockingQueue = null;
        }
        blockingQueue.add(new Message(MessageType.DRAIN_ONE, semaphore));
        semaphore.acquire();
    }

    @Override
    public void runToEndOfTasksSync() {
        TimeOutSemaphore semaphore = new TimeOutSemaphore(0);
        BlockingQueue<Message> blockingQueue = this.messageQueue;
        if (blockingQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageQueue");
            blockingQueue = null;
        }
        blockingQueue.add(new Message(MessageType.DRAIN_ALL, semaphore));
        semaphore.acquire();
    }

    @Override
    @Nullable
    public TimeOutSemaphore runToEndOfTasksAsync() {
        TimeOutSemaphore semaphore = new TimeOutSemaphore(0);
        BlockingQueue<Message> blockingQueue = this.messageQueue;
        if (blockingQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageQueue");
            blockingQueue = null;
        }
        blockingQueue.add(new Message(MessageType.DRAIN_ALL, semaphore));
        return semaphore;
    }

    public ThreadLooperController() {
        this(null, 1, null);
    }
}

