/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import com.facebook.litho.testing.TimeOutSemaphore;
import junit.framework.AssertionFailedError;

public class ThreadTestingUtils {
    public static TimeOutSemaphore runOnBackgroundThread(Runnable runnable) {
        TimeOutSemaphore latch = new TimeOutSemaphore(0);
        ThreadTestingUtils.runOnBackgroundThread(latch, runnable);
        return latch;
    }

    public static void runOnBackgroundThread(final TimeOutSemaphore latch, final Runnable runnable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception | AssertionFailedError e) {
                    latch.setException(e);
                }
                latch.release();
            }
        }).start();
    }

    public static void failSilentlyIfInterrupted(RunnableWithInterruptedException runnable) {
        try {
            runnable.run();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void failIfInterrupted(RunnableWithInterruptedException runnable) {
        try {
            runnable.run();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface RunnableWithInterruptedException {
        public void run() throws InterruptedException;
    }
}

