/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import androidx.annotation.Nullable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class TimeOutSemaphore {
    private final Semaphore mSemaphore;
    @Nullable
    private Throwable mException;

    public TimeOutSemaphore(int numPermits) {
        this.mSemaphore = new Semaphore(numPermits, true);
    }

    public void acquire() {
        try {
            if (!this.mSemaphore.tryAcquire(5L, TimeUnit.SECONDS)) {
                this.checkException();
                throw new RuntimeException("Timed out!");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.checkException();
    }

    public void release() {
        this.mSemaphore.release();
    }

    public void drainPermits() {
        this.mSemaphore.drainPermits();
    }

    public void setException(Throwable t) {
        this.mException = t;
    }

    private void checkException() {
        if (this.mException != null) {
            throw new RuntimeException("Exception from signaling thread", this.mException);
        }
    }
}

