/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import com.facebook.litho.choreographercompat.ChoreographerCompat;
import com.facebook.litho.choreographercompat.ChoreographerCompatImpl;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.dataflow.DataFlowGraph;
import com.facebook.litho.dataflow.MockTimingSource;
import com.facebook.litho.dataflow.TimingSource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TransitionTestRule
implements TestRule {
    private boolean mIsAnimationDisabled;
    private MockTimingSource mFakeTimingSource;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    TransitionTestRule.this.mIsAnimationDisabled = ComponentsConfiguration.isAnimationDisabled;
                    ComponentsConfiguration.isAnimationDisabled = false;
                    TransitionTestRule.this.mFakeTimingSource = new MockTimingSource();
                    TransitionTestRule.this.mFakeTimingSource.start();
                    DataFlowGraph.setInstance((DataFlowGraph)DataFlowGraph.create((TimingSource)TransitionTestRule.this.mFakeTimingSource));
                    ChoreographerCompatImpl.setInstance((ChoreographerCompat)TransitionTestRule.this.mFakeTimingSource);
                    base.evaluate();
                }
                finally {
                    ComponentsConfiguration.isAnimationDisabled = TransitionTestRule.this.mIsAnimationDisabled;
                    ChoreographerCompatImpl.setInstance(null);
                    DataFlowGraph.setInstance(null);
                }
            }
        };
    }

    public void step(int numFrames) {
        this.mFakeTimingSource.step(numFrames);
    }
}

