/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Whitebox {
    public static <T> T getInternalState(Object object, String fieldName) {
        Field foundField = Whitebox.findFieldInHierarchy(Whitebox.getType(object), fieldName);
        try {
            return (T)foundField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    public static void setInternalState(Object object, String fieldName, Object value) {
        Field foundField = Whitebox.findFieldInHierarchy(object.getClass(), fieldName);
        try {
            foundField.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    private static Field findFieldInHierarchy(Class<?> startClass, String fieldName) {
        Field foundField = null;
        for (Class<?> currentClass = startClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                if (foundField != null) {
                    throw new IllegalArgumentException("Two or more fields matching " + fieldName + " in " + startClass + ".");
                }
                foundField = field;
            }
            if (foundField != null) break;
        }
        if (foundField == null) {
            throw new IllegalArgumentException("No fields matching " + fieldName + " in " + startClass + ".");
        }
        foundField.setAccessible(true);
        return foundField;
    }

    public static <T> T invokeMethod(Object object, String methodName, Object ... arguments) {
        Method foundMethod = Whitebox.findMethodInHierarchy(object.getClass(), methodName);
        try {
            return (T)foundMethod.invoke(object, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: Failed to invoked method.", e);
        }
    }

    public static <T> T invokeMethod(Class<?> clazz, String methodName, Object ... arguments) {
        Method foundMethod = Whitebox.findMethodInHierarchy(clazz, methodName);
        try {
            return (T)foundMethod.invoke(clazz, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: Failed to invoked method.", e);
        }
    }

    private static Method findMethodInHierarchy(Class<?> startClass, String methodName) {
        Method foundMethod = null;
        for (Class<?> currentClass = startClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = currentClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                if (foundMethod != null) {
                    throw new IllegalArgumentException("Two or more methods matching " + methodName + " in " + startClass + ".");
                }
                foundMethod = method;
            }
            if (foundMethod != null) break;
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException("No methods matching " + methodName + " in " + startClass + ".");
        }
        foundMethod.setAccessible(true);
        return foundMethod;
    }

    public static Class<?> getType(Object object) {
        if (object instanceof Class) {
            return (Class)object;
        }
        return object.getClass();
    }
}

