/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.api;

import com.facebook.litho.AttributeKey;
import com.facebook.litho.testing.api.FiltersKt;
import com.facebook.litho.testing.api.TestNode;
import com.facebook.litho.testing.api.TestNodeMatcher;
import com.facebook.litho.widget.WidgetAttributes;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a'\u0010\b\u001a\u00020\u0006\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u0002H\t\u00a2\u0006\u0002\u0010\r\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0015\u001a\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0011\u001a\u0011\u0010\u0019\u001a\u00020\u0006\"\u0006\b\u0000\u0010\t\u0018\u0001H\u0086\b\u001a\u0012\u0010\u0019\u001a\u00020\u00062\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b\u001a\u0006\u0010\u001c\u001a\u00020\u0006\u001a\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0006\u0010\u001e\u001a\u00020\u0006\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001f"}, d2={"ancestors", "", "Lcom/facebook/litho/testing/api/TestNode;", "getAncestors", "(Lcom/facebook/litho/testing/api/TestNode;)Ljava/lang/Iterable;", "hasAncestor", "Lcom/facebook/litho/testing/api/TestNodeMatcher;", "matcher", "hasAttribute", "T", "key", "Lcom/facebook/litho/AttributeKey;", "value", "(Lcom/facebook/litho/AttributeKey;Ljava/lang/Object;)Lcom/facebook/litho/testing/api/TestNodeMatcher;", "hasChild", "hasContentDescription", "description", "", "hasDescendant", "hasParent", "hasTestKey", "", "hasText", "text", "hasTextContaining", "hasType", "type", "Ljava/lang/Class;", "isEnabled", "isNotEnabled", "isRoot", "litho-testing_release"})
public final class FiltersKt {
    @NotNull
    public static final TestNodeMatcher hasType(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new TestNodeMatcher("is a component of type " + type.getCanonicalName(), (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(type){
            final /* synthetic */ Class<?> $type;
            {
                this.$type = $type;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestNode testNode) {
                Intrinsics.checkNotNullParameter((Object)testNode, (String)"testNode");
                return Intrinsics.areEqual(testNode.getComponentType(), this.$type);
            }
        }));
    }

    public static final /* synthetic */ <T> TestNodeMatcher hasType() {
        boolean $i$f$hasType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return FiltersKt.hasType(Object.class);
    }

    @NotNull
    public static final TestNodeMatcher isEnabled() {
        return new TestNodeMatcher("is enabled", (Function1<? super TestNode, Boolean>)((Function1)isEnabled.1.INSTANCE));
    }

    @NotNull
    public static final TestNodeMatcher isNotEnabled() {
        return new TestNodeMatcher("is not enabled", (Function1<? super TestNode, Boolean>)((Function1)isNotEnabled.1.INSTANCE));
    }

    @NotNull
    public static final TestNodeMatcher hasTestKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new TestNodeMatcher("has test key \"" + key + '\"', (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(key){
            final /* synthetic */ String $key;
            {
                this.$key = $key;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return Intrinsics.areEqual((Object)node.getTestKey(), (Object)this.$key);
            }
        }));
    }

    @NotNull
    public static final TestNodeMatcher hasText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        AttributeKey attributeKey = WidgetAttributes.Text;
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"Text");
        return FiltersKt.hasAttribute(attributeKey, text);
    }

    @NotNull
    public static final TestNodeMatcher hasTextContaining(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new TestNodeMatcher("has text containing \"" + text + '\"', (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(text){
            final /* synthetic */ CharSequence $text;
            {
                this.$text = $text;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                AttributeKey attributeKey = WidgetAttributes.Text;
                Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"Text");
                CharSequence charSequence = (CharSequence)node.getAttribute(attributeKey);
                return charSequence != null ? StringsKt.contains$default((CharSequence)charSequence, (CharSequence)this.$text, (boolean)false, (int)2, null) : false;
            }
        }));
    }

    @NotNull
    public static final TestNodeMatcher hasContentDescription(@NotNull CharSequence description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new TestNodeMatcher("has contentDescription \"" + description + '\"', (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(description){
            final /* synthetic */ CharSequence $description;
            {
                this.$description = $description;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return Intrinsics.areEqual((Object)node.getContentDescription(), (Object)this.$description);
            }
        }));
    }

    @NotNull
    public static final <T> TestNodeMatcher hasAttribute(@NotNull AttributeKey<T> key, T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return new TestNodeMatcher(key.getDescription() + " = " + value, (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(key, value){
            final /* synthetic */ AttributeKey<T> $key;
            final /* synthetic */ T $value;
            {
                this.$key = $key;
                this.$value = $value;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestNode testNode) {
                Intrinsics.checkNotNullParameter((Object)testNode, (String)"testNode");
                return Intrinsics.areEqual(testNode.getAttribute(this.$key), this.$value);
            }
        }));
    }

    @NotNull
    public static final TestNodeMatcher isRoot() {
        return new TestNodeMatcher("is root", (Function1<? super TestNode, Boolean>)((Function1)isRoot.1.INSTANCE));
    }

    @NotNull
    public static final TestNodeMatcher hasParent(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new TestNodeMatcher("has parent that " + matcher.getDescription(), (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(matcher){
            final /* synthetic */ TestNodeMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestNode testNode) {
                Intrinsics.checkNotNullParameter((Object)testNode, (String)"testNode");
                TestNode parent = testNode.getParent();
                return parent == null ? false : this.$matcher.matches(parent);
            }
        }));
    }

    @NotNull
    public static final TestNodeMatcher hasAncestor(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new TestNodeMatcher("has ancestor that " + matcher.getDescription(), (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(matcher){
            final /* synthetic */ TestNodeMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull TestNode testNode) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)testNode, (String)"testNode");
                    Iterable iterable = FiltersKt.access$getAncestors(testNode);
                    TestNodeMatcher testNodeMatcher = this.$matcher;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TestNode ancestor = (TestNode)element$iv;
                            boolean bl2 = false;
                            if (!testNodeMatcher.matches(ancestor)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    @NotNull
    public static final TestNodeMatcher hasChild(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new TestNodeMatcher("has child that " + matcher.getDescription(), (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(matcher){
            final /* synthetic */ TestNodeMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull TestNode testNode) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)testNode, (String)"testNode");
                    Iterable iterable = testNode.getChildren();
                    TestNodeMatcher testNodeMatcher = this.$matcher;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TestNode child = (TestNode)element$iv;
                            boolean bl2 = false;
                            if (!testNodeMatcher.matches(child)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    @NotNull
    public static final TestNodeMatcher hasDescendant(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new TestNodeMatcher("has descendant that " + matcher.getDescription(), (Function1<? super TestNode, Boolean>)((Function1)new Function1<TestNode, Boolean>(matcher){
            final /* synthetic */ TestNodeMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestNode testNode) {
                Intrinsics.checkNotNullParameter((Object)testNode, (String)"testNode");
                return FiltersKt.access$hasDescendant$checkHasDescendant(testNode, this.$matcher);
            }
        }));
    }

    private static final Iterable<TestNode> getAncestors(TestNode $this$ancestors) {
        return new Iterable<TestNode>($this$ancestors){
            final /* synthetic */ TestNode $this_ancestors;
            {
                this.$this_ancestors = $receiver;
            }

            @NotNull
            public Iterator<TestNode> iterator() {
                return new Iterator<TestNode>(this.$this_ancestors){
                    @Nullable
                    private TestNode next;
                    {
                        this.next = $receiver.getParent();
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @NotNull
                    public TestNode next() {
                        TestNode testNode;
                        TestNode testNode2 = this.next;
                        Intrinsics.checkNotNull((Object)testNode2);
                        TestNode it = testNode = testNode2;
                        boolean bl = false;
                        this.next = it.getParent();
                        return testNode;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private static final boolean hasDescendant$checkHasDescendant(TestNode node, TestNodeMatcher matcher) {
        boolean bl;
        block8: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block7: {
                $this$any$iv = node.getChildren();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TestNode p0 = (TestNode)element$iv;
                        boolean bl3 = false;
                        if (!matcher.matches(p0)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            $this$any$iv = node.getChildren();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestNode child = (TestNode)element$iv;
                    boolean bl4 = false;
                    if (!FiltersKt.hasDescendant$checkHasDescendant(child, matcher)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Iterable access$getAncestors(TestNode $receiver) {
        return FiltersKt.getAncestors($receiver);
    }

    public static final /* synthetic */ boolean access$hasDescendant$checkHasDescendant(TestNode node, TestNodeMatcher matcher) {
        return FiltersKt.hasDescendant$checkHasDescendant(node, matcher);
    }
}

