/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.api;

import android.os.Looper;
import android.view.View;
import androidx.test.core.app.ApplicationProvider;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoView;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.testing.BaseThreadLooperController;
import com.facebook.litho.testing.ResolveAndLayoutThreadLooperController;
import com.facebook.litho.testing.ThreadLooperController;
import com.facebook.litho.testing.api.LithoTestContext;
import com.facebook.litho.testing.api.TestContext;
import com.facebook.litho.testing.api.TestNodeCollectionSelection;
import com.facebook.litho.testing.api.TestNodeMatcher;
import com.facebook.litho.testing.api.TestNodeSelection;
import com.facebook.litho.testing.api.TestNodeSelectionProvider;
import com.facebook.litho.testing.api.TestNodeSelectorKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.robolectric.Shadows;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/litho/testing/api/LithoRule;", "Lorg/junit/rules/TestRule;", "Lcom/facebook/litho/testing/api/TestNodeSelectionProvider;", "()V", "componentContext", "Lcom/facebook/litho/ComponentContext;", "testContext", "Lcom/facebook/litho/testing/api/TestContext;", "threadLooperController", "Lcom/facebook/litho/testing/BaseThreadLooperController;", "apply", "Lorg/junit/runners/model/Statement;", "statement", "description", "Lorg/junit/runner/Description;", "ensureThreadLooperType", "", "idle", "render", "componentProvider", "Lkotlin/Function0;", "Lcom/facebook/litho/Component;", "selectNode", "Lcom/facebook/litho/testing/api/TestNodeSelection;", "matcher", "Lcom/facebook/litho/testing/api/TestNodeMatcher;", "selectNodes", "Lcom/facebook/litho/testing/api/TestNodeCollectionSelection;", "setupLithoViewWithComponent", "Companion", "litho-testing_release"})
public final class LithoRule
implements TestRule,
TestNodeSelectionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ComponentContext componentContext;
    private TestContext testContext;
    @NotNull
    private BaseThreadLooperController threadLooperController = new ThreadLooperController(null, 1, null);
    private static final int DEFAULT_WIDTH_SPEC = View.MeasureSpec.makeMeasureSpec((int)1080, (int)0x40000000);
    private static final int DEFAULT_HEIGHT_SPEC = View.MeasureSpec.makeMeasureSpec((int)2040, (int)0x40000000);

    @NotNull
    public Statement apply(@NotNull Statement statement, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new Statement(this, statement){
            final /* synthetic */ LithoRule this$0;
            final /* synthetic */ Statement $statement;
            {
                this.this$0 = $receiver;
                this.$statement = $statement;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() {
                LithoRule.access$ensureThreadLooperType(this.this$0);
                try {
                    LithoRule.access$setComponentContext$p(this.this$0, new ComponentContext(ApplicationProvider.getApplicationContext()));
                    LithoRule.access$getThreadLooperController$p(this.this$0).init();
                    this.$statement.evaluate();
                }
                finally {
                    LithoRule.access$getThreadLooperController$p(this.this$0).clean();
                }
            }
        };
    }

    @NotNull
    public final LithoRule render(@NotNull Function0<? extends Component> componentProvider) {
        LithoRule lithoRule;
        Intrinsics.checkNotNullParameter(componentProvider, (String)"componentProvider");
        LithoRule it = lithoRule = this;
        boolean bl = false;
        ComponentContext componentContext = this.componentContext;
        if (componentContext == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.setupLithoViewWithComponent(componentContext, componentProvider);
        return lithoRule;
    }

    @Override
    @NotNull
    public TestNodeSelection selectNode(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this.idle();
        TestContext testContext = this.testContext;
        if (testContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testContext");
            testContext = null;
        }
        return new TestNodeSelection(testContext, TestNodeSelectorKt.testNodeSelector(matcher));
    }

    @Override
    @NotNull
    public TestNodeCollectionSelection selectNodes(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this.idle();
        TestContext testContext = this.testContext;
        if (testContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testContext");
            testContext = null;
        }
        return new TestNodeCollectionSelection(testContext, TestNodeSelectorKt.testNodeSelector(matcher));
    }

    private final void setupLithoViewWithComponent(ComponentContext componentContext, Function0<? extends Component> componentProvider) {
        LithoView lithoView = new LithoView(componentContext);
        ComponentTree componentTree = ComponentTree.create((ComponentContext)componentContext).build();
        Component component = (Component)componentProvider.invoke();
        this.testContext = new LithoTestContext(lithoView);
        componentTree.setRoot(component);
        lithoView.setComponentTree(componentTree);
        lithoView.onAttachedToWindowForTest();
        lithoView.measure(DEFAULT_WIDTH_SPEC, DEFAULT_HEIGHT_SPEC);
        lithoView.layout(0, 0, lithoView.getMeasuredWidth(), lithoView.getMeasuredHeight());
    }

    private final void idle() {
        this.threadLooperController.runToEndOfTasksSync();
        Shadows.shadowOf((Looper)Looper.getMainLooper()).idle();
    }

    private final void ensureThreadLooperType() {
        if (ComponentsConfiguration.isSplitResolveAndLayoutWithSplitHandlers() && this.threadLooperController instanceof ThreadLooperController) {
            this.threadLooperController = new ResolveAndLayoutThreadLooperController();
        } else if (!ComponentsConfiguration.isSplitResolveAndLayoutWithSplitHandlers() && this.threadLooperController instanceof ResolveAndLayoutThreadLooperController) {
            this.threadLooperController = new ThreadLooperController(null, 1, null);
        }
    }

    public static final /* synthetic */ void access$ensureThreadLooperType(LithoRule $this) {
        $this.ensureThreadLooperType();
    }

    public static final /* synthetic */ void access$setComponentContext$p(LithoRule $this, ComponentContext componentContext) {
        $this.componentContext = componentContext;
    }

    public static final /* synthetic */ BaseThreadLooperController access$getThreadLooperController$p(LithoRule $this) {
        return $this.threadLooperController;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/litho/testing/api/LithoRule$Companion;", "", "()V", "DEFAULT_HEIGHT_SPEC", "", "DEFAULT_WIDTH_SPEC", "litho-testing_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

