/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.api;

import android.annotation.SuppressLint;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoLayoutResult;
import com.facebook.litho.LithoNode;
import com.facebook.litho.LithoView;
import com.facebook.litho.MountedContentKt;
import com.facebook.litho.NestedTreeHolderResult;
import com.facebook.litho.ScopedComponentInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u000628\u0010\u0007\u001a4\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\bH\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f28\u0010\u0007\u001a4\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\bJ\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/facebook/litho/testing/api/LithoViewComponentsTraverser;", "", "()V", "traverse", "", "layoutResult", "Lcom/facebook/litho/LithoLayoutResult;", "onComponentFound", "Lkotlin/Function2;", "Lcom/facebook/litho/Component;", "Lkotlin/ParameterName;", "name", "component", "parent", "lithoView", "Lcom/facebook/litho/LithoView;", "extractLayoutResult", "isRoot", "", "getChildResults", "", "TraverseNode", "litho-testing_release"})
public final class LithoViewComponentsTraverser {
    public final void traverse(@NotNull LithoView lithoView, @NotNull Function2<? super Component, ? super Component, Unit> onComponentFound) {
        Intrinsics.checkNotNullParameter((Object)lithoView, (String)"lithoView");
        Intrinsics.checkNotNullParameter(onComponentFound, (String)"onComponentFound");
        LithoLayoutResult rootLayoutResult = this.extractLayoutResult(lithoView, true);
        this.traverse(rootLayoutResult, onComponentFound);
    }

    /*
     * WARNING - void declaration
     */
    private final void traverse(LithoLayoutResult layoutResult, Function2<? super Component, ? super Component, Unit> onComponentFound) {
        if (layoutResult == null) {
            return;
        }
        HashSet<LithoLayoutResult> visited = new HashSet<LithoLayoutResult>();
        LinkedList<TraverseNode> layoutsStack = new LinkedList<TraverseNode>();
        layoutsStack.push(new TraverseNode(layoutResult, null));
        while (!((Collection)layoutsStack).isEmpty()) {
            LithoLayoutResult nestedResult;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            TraverseNode traverseNode = (TraverseNode)layoutsStack.pop();
            LithoLayoutResult currentLayoutResult = traverseNode.component1();
            Component parentComponent = traverseNode.component2();
            if (visited.contains(currentLayoutResult)) continue;
            visited.add(currentLayoutResult);
            LithoNode lithoNode = currentLayoutResult.getNode();
            List list = lithoNode.getScopedComponentInfos();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lithoNode.scopedComponentInfos");
            Iterable $this$mapNotNull$iv = CollectionsKt.asReversedMutable((List)list);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Component component = $this$forEach$iv$iv$iv.iterator();
            while (component.hasNext()) {
                Component it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = component.next();
                boolean bl = false;
                ScopedComponentInfo it = (ScopedComponentInfo)element$iv$iv;
                boolean bl2 = false;
                if (it.getComponent() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List components = (List)destination$iv$iv;
            Component lastScopedComponent = (Component)CollectionsKt.lastOrNull((List)components);
            if (currentLayoutResult instanceof NestedTreeHolderResult && (nestedResult = ((NestedTreeHolderResult)currentLayoutResult).getNestedResult()) != null && (nestedResult.getNode().getChildCount() > 0 || nestedResult instanceof NestedTreeHolderResult)) {
                layoutsStack.push(new TraverseNode(nestedResult, parentComponent));
                continue;
            }
            Iterable $this$zipWithNext$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)parentComponent), (Iterable)components);
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                CollectionsKt.emptyList();
            } else {
                List result$iv = new ArrayList();
                Object current$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void currentParent;
                    void child;
                    Object next$iv = iterator$iv.next();
                    component = (Component)next$iv;
                    element$iv$iv$iv = (Component)current$iv;
                    List list2 = result$iv;
                    boolean bl = false;
                    if (child == null) {
                        throw new IllegalStateException("Child should never be null".toString());
                    }
                    onComponentFound.invoke((Object)child, (Object)currentParent);
                    list2.add(Unit.INSTANCE);
                    current$iv = next$iv;
                }
            }
            Iterable $this$forEach$iv = this.getChildResults(currentLayoutResult);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                LithoLayoutResult child = (LithoLayoutResult)element$iv;
                boolean bl = false;
                layoutsStack.push(new TraverseNode(child, lastScopedComponent));
            }
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private final LithoLayoutResult extractLayoutResult(LithoView $this$extractLayoutResult, boolean isRoot2) {
        ComponentTree componentTree = $this$extractLayoutResult.getComponentTree();
        LayoutState committedLayoutState = componentTree != null ? componentTree.getCommittedLayoutState() : null;
        if (!(!isRoot2 || committedLayoutState != null)) {
            boolean bl = false;
            String string = "No ComponentTree/Committed Layout/Layout Root found. Please call render() first";
            throw new IllegalStateException(string.toString());
        }
        LayoutState layoutState = committedLayoutState;
        return layoutState != null ? layoutState.getRootLayoutResult() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LithoLayoutResult> getChildResults(LithoLayoutResult $this$getChildResults) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object mountedContent = MountedContentKt.getMountedContent($this$getChildResults);
        if (mountedContent instanceof HasLithoViewChildren) {
            void $this$mapNotNullTo$iv$iv;
            List list;
            HasLithoViewChildren hasLithoViewChildren = (HasLithoViewChildren)mountedContent;
            List p0 = list = CollectionsKt.createListBuilder();
            boolean $i$a$-buildList-LithoViewComponentsTraverser$getChildResults$children$22 = false;
            hasLithoViewChildren.obtainLithoViewChildren(p0);
            List children = CollectionsKt.build((List)list);
            $this$mapNotNull$iv = children;
            boolean $i$f$mapNotNull = false;
            Iterable $i$a$-buildList-LithoViewComponentsTraverser$getChildResults$children$22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LithoLayoutResult it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                LithoView it = (LithoView)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (this.extractLayoutResult(it, false) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List results = (List)destination$iv$iv;
            if (!((Collection)results).isEmpty()) {
                return CollectionsKt.asReversed((List)results);
            }
        }
        Iterable $this$map$iv = (Iterable)RangesKt.downTo((int)($this$getChildResults.getChildCount() - 1), (int)0);
        boolean $i$f$map = false;
        $this$mapNotNull$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            void it;
            int item$iv$iv;
            int $this$forEach$iv$iv$iv = item$iv$iv = ((IntIterator)iterator3).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$getChildResults.getChildAt((int)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/facebook/litho/testing/api/LithoViewComponentsTraverser$TraverseNode;", "", "layoutResult", "Lcom/facebook/litho/LithoLayoutResult;", "parentComponent", "Lcom/facebook/litho/Component;", "(Lcom/facebook/litho/LithoLayoutResult;Lcom/facebook/litho/Component;)V", "getLayoutResult", "()Lcom/facebook/litho/LithoLayoutResult;", "getParentComponent", "()Lcom/facebook/litho/Component;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "litho-testing_release"})
    public static final class TraverseNode {
        @NotNull
        private final LithoLayoutResult layoutResult;
        @Nullable
        private final Component parentComponent;

        public TraverseNode(@NotNull LithoLayoutResult layoutResult, @Nullable Component parentComponent) {
            Intrinsics.checkNotNullParameter((Object)layoutResult, (String)"layoutResult");
            this.layoutResult = layoutResult;
            this.parentComponent = parentComponent;
        }

        @NotNull
        public final LithoLayoutResult getLayoutResult() {
            return this.layoutResult;
        }

        @Nullable
        public final Component getParentComponent() {
            return this.parentComponent;
        }

        @NotNull
        public final LithoLayoutResult component1() {
            return this.layoutResult;
        }

        @Nullable
        public final Component component2() {
            return this.parentComponent;
        }

        @NotNull
        public final TraverseNode copy(@NotNull LithoLayoutResult layoutResult, @Nullable Component parentComponent) {
            Intrinsics.checkNotNullParameter((Object)layoutResult, (String)"layoutResult");
            return new TraverseNode(layoutResult, parentComponent);
        }

        public static /* synthetic */ TraverseNode copy$default(TraverseNode traverseNode, LithoLayoutResult lithoLayoutResult, Component component, int n, Object object) {
            if ((n & 1) != 0) {
                lithoLayoutResult = traverseNode.layoutResult;
            }
            if ((n & 2) != 0) {
                component = traverseNode.parentComponent;
            }
            return traverseNode.copy(lithoLayoutResult, component);
        }

        @NotNull
        public String toString() {
            return "TraverseNode(layoutResult=" + this.layoutResult + ", parentComponent=" + this.parentComponent + ')';
        }

        public int hashCode() {
            int result = this.layoutResult.hashCode();
            result = result * 31 + (this.parentComponent == null ? 0 : this.parentComponent.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TraverseNode)) {
                return false;
            }
            TraverseNode traverseNode = (TraverseNode)other;
            if (!Intrinsics.areEqual((Object)this.layoutResult, (Object)traverseNode.layoutResult)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parentComponent, (Object)traverseNode.parentComponent);
        }
    }
}

