/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.api;

import com.facebook.litho.AttributeKey;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.CommonProps;
import com.facebook.litho.Component;
import com.facebook.litho.EventHandler;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'\u00a2\u0006\u0002\u0010(R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006)"}, d2={"Lcom/facebook/litho/testing/api/TestNode;", "", "component", "Lcom/facebook/litho/Component;", "(Lcom/facebook/litho/Component;)V", "children", "", "getChildren", "()Ljava/util/List;", "setChildren", "(Ljava/util/List;)V", "clickHandler", "Lcom/facebook/litho/EventHandler;", "Lcom/facebook/litho/ClickEvent;", "getClickHandler", "()Lcom/facebook/litho/EventHandler;", "componentType", "Ljava/lang/Class;", "getComponentType", "()Ljava/lang/Class;", "contentDescription", "", "getContentDescription", "()Ljava/lang/CharSequence;", "isEnabled", "", "()Z", "parent", "getParent", "()Lcom/facebook/litho/testing/api/TestNode;", "setParent", "(Lcom/facebook/litho/testing/api/TestNode;)V", "testKey", "", "getTestKey", "()Ljava/lang/String;", "getAttribute", "T", "key", "Lcom/facebook/litho/AttributeKey;", "(Lcom/facebook/litho/AttributeKey;)Ljava/lang/Object;", "litho-testing_release"})
public final class TestNode {
    @NotNull
    private final Component component;
    @NotNull
    private final Class<?> componentType;
    @Nullable
    private TestNode parent;
    @NotNull
    private List<TestNode> children;

    public TestNode(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
        this.componentType = this.component.getClass();
        this.children = new ArrayList();
    }

    @NotNull
    public final Class<?> getComponentType() {
        return this.componentType;
    }

    @Nullable
    public final String getTestKey() {
        CommonProps commonProps = this.component.getCommonProps();
        return commonProps != null ? commonProps.getTestKey() : null;
    }

    public final boolean isEnabled() {
        CommonProps commonProps = this.component.getCommonProps();
        return commonProps != null ? commonProps.isEnabled() : false;
    }

    @Nullable
    public final CharSequence getContentDescription() {
        CommonProps commonProps = this.component.getCommonProps();
        return commonProps != null ? commonProps.getContentDescription() : null;
    }

    @Nullable
    public final EventHandler<ClickEvent> getClickHandler() {
        CommonProps commonProps = this.component.getCommonProps();
        return commonProps != null ? commonProps.getClickHandler() : null;
    }

    public final <T> T getAttribute(@NotNull AttributeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.component.getAttribute(key);
    }

    @Nullable
    public final TestNode getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable TestNode testNode) {
        this.parent = testNode;
    }

    @NotNull
    public final List<TestNode> getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull List<TestNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.children = list;
    }
}

