/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.api;

import com.facebook.litho.testing.api.ErrorsKt;
import com.facebook.litho.testing.api.TestContext;
import com.facebook.litho.testing.api.TestNode;
import com.facebook.litho.testing.api.TestNodeCollectionSelection;
import com.facebook.litho.testing.api.TestNodeMatcher;
import com.facebook.litho.testing.api.TestNodeSelection;
import com.facebook.litho.testing.api.TestNodeSelector;
import com.facebook.litho.testing.api.TestNodeSelectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/litho/testing/api/TestNodeCollectionSelection;", "", "testContext", "Lcom/facebook/litho/testing/api/TestContext;", "selector", "Lcom/facebook/litho/testing/api/TestNodeSelector;", "(Lcom/facebook/litho/testing/api/TestContext;Lcom/facebook/litho/testing/api/TestNodeSelector;)V", "assertAll", "matcher", "Lcom/facebook/litho/testing/api/TestNodeMatcher;", "assertAny", "assertCount", "count", "", "assertDoesNotExist", "assertExists", "fetchMatchingNodes", "", "Lcom/facebook/litho/testing/api/TestNode;", "select", "Lcom/facebook/litho/testing/api/TestNodeSelection;", "selectAll", "selectAtIndex", "index", "selectFirst", "selectLast", "litho-testing_release"})
public final class TestNodeCollectionSelection {
    @NotNull
    private final TestContext testContext;
    @NotNull
    private final TestNodeSelector selector;

    public TestNodeCollectionSelection(@NotNull TestContext testContext, @NotNull TestNodeSelector selector) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.testContext = testContext;
        this.selector = selector;
    }

    @NotNull
    public final TestNodeCollectionSelection assertExists() {
        List<TestNode> result = this.fetchMatchingNodes();
        if (result.isEmpty()) {
            ErrorsKt.throwNoMatchingNodeForSelectionError("Failed: assertExists", this.selector);
            throw new KotlinNothingValueException();
        }
        return this;
    }

    @NotNull
    public final TestNodeCollectionSelection assertDoesNotExist() {
        List<TestNode> result = this.fetchMatchingNodes();
        if (!((Collection)result).isEmpty()) {
            ErrorsKt.throwCountMismatchError("Failed: assertDoesNotExist", this.selector, 0, result);
            throw new KotlinNothingValueException();
        }
        return this;
    }

    @NotNull
    public final TestNodeCollectionSelection assertCount(int count) {
        List<TestNode> result = this.fetchMatchingNodes();
        if (result.size() != count) {
            ErrorsKt.throwCountMismatchError("Failed: assertCount", this.selector, count, result);
            throw new KotlinNothingValueException();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestNodeCollectionSelection assertAll(@NotNull TestNodeMatcher matcher) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        List<TestNode> result = this.fetchMatchingNodes();
        Iterable $this$filterNot$iv = result;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            TestNode it = (TestNode)element$iv$iv;
            boolean bl = false;
            if (matcher.matches(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List failedNodes = (List)destination$iv$iv;
        if (!((Collection)failedNodes).isEmpty()) {
            ErrorsKt.throwAssertAllFailError(matcher, this.selector, failedNodes);
            throw new KotlinNothingValueException();
        }
        return this;
    }

    @NotNull
    public final TestNodeCollectionSelection assertAny(@NotNull TestNodeMatcher matcher) {
        boolean bl;
        List<TestNode> result;
        block4: {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            result = this.fetchMatchingNodes();
            Iterable $this$any$iv = result;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestNode p0 = (TestNode)element$iv;
                    boolean bl2 = false;
                    if (!matcher.matches(p0)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            ErrorsKt.throwAssertAnyFailError(matcher, this.selector, result);
            throw new KotlinNothingValueException();
        }
        return this;
    }

    @NotNull
    public final TestNodeSelection selectAtIndex(int index) {
        return new TestNodeSelection(this.testContext, TestNodeSelectorKt.plusIndexNodeSelector(this.selector, index));
    }

    @NotNull
    public final TestNodeSelection selectFirst() {
        return new TestNodeSelection(this.testContext, TestNodeSelectorKt.plusManyToSingleSelector(this.selector, "first node", (Function1<? super List<TestNode>, TestNode>)((Function1)selectFirst.1.INSTANCE)));
    }

    @NotNull
    public final TestNodeSelection selectLast() {
        return new TestNodeSelection(this.testContext, TestNodeSelectorKt.plusManyToSingleSelector(this.selector, "last node", (Function1<? super List<TestNode>, TestNode>)((Function1)selectLast.1.INSTANCE)));
    }

    @NotNull
    public final TestNodeCollectionSelection selectAll(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new TestNodeCollectionSelection(this.testContext, TestNodeSelectorKt.plusManyToManySelector(this.selector, matcher));
    }

    @NotNull
    public final TestNodeSelection select(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new TestNodeSelection(this.testContext, TestNodeSelectorKt.plusManyToManySelector(this.selector, matcher));
    }

    @NotNull
    public final List<TestNode> fetchMatchingNodes() {
        List<TestNode> nodes = this.testContext.provideAllTestNodes();
        return this.selector.map(nodes).getNodes();
    }
}

