/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.api;

import com.facebook.litho.testing.api.ErrorsKt;
import com.facebook.litho.testing.api.SelectionResult;
import com.facebook.litho.testing.api.TestContext;
import com.facebook.litho.testing.api.TestNode;
import com.facebook.litho.testing.api.TestNodeCollectionSelection;
import com.facebook.litho.testing.api.TestNodeMatcher;
import com.facebook.litho.testing.api.TestNodeSelection;
import com.facebook.litho.testing.api.TestNodeSelector;
import com.facebook.litho.testing.api.TestNodeSelectorKt;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0000J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/litho/testing/api/TestNodeSelection;", "", "testContext", "Lcom/facebook/litho/testing/api/TestContext;", "selector", "Lcom/facebook/litho/testing/api/TestNodeSelector;", "(Lcom/facebook/litho/testing/api/TestContext;Lcom/facebook/litho/testing/api/TestNodeSelector;)V", "getSelector$litho_testing_release", "()Lcom/facebook/litho/testing/api/TestNodeSelector;", "assert", "matcher", "Lcom/facebook/litho/testing/api/TestNodeMatcher;", "assertDoesNotExist", "assertExists", "fetchMatchingNodes", "Lcom/facebook/litho/testing/api/SelectionResult;", "fetchTestNode", "Lcom/facebook/litho/testing/api/TestNode;", "errorOnFail", "", "selectChildAt", "index", "", "selectChildren", "Lcom/facebook/litho/testing/api/TestNodeCollectionSelection;", "litho-testing_release"})
public final class TestNodeSelection {
    @NotNull
    private final TestContext testContext;
    @NotNull
    private final TestNodeSelector selector;

    public TestNodeSelection(@NotNull TestContext testContext, @NotNull TestNodeSelector selector) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.testContext = testContext;
        this.selector = selector;
    }

    @NotNull
    public final TestNodeSelector getSelector$litho_testing_release() {
        return this.selector;
    }

    @NotNull
    public final TestNode fetchTestNode(@NotNull String errorOnFail) {
        Intrinsics.checkNotNullParameter((Object)errorOnFail, (String)"errorOnFail");
        SelectionResult result = this.fetchMatchingNodes();
        if (result.getNodes().size() != 1) {
            if (result.getSelectionError$litho_testing_release() != null) {
                throw new AssertionError((Object)(errorOnFail + '\n' + result.getSelectionError$litho_testing_release()));
            }
            if (result.getNodes().isEmpty()) {
                ErrorsKt.throwNoMatchingNodeForSelectionError(errorOnFail, this.selector);
                throw new KotlinNothingValueException();
            }
            ErrorsKt.throwCountMismatchError(errorOnFail, this.selector, 1, result.getNodes());
            throw new KotlinNothingValueException();
        }
        return (TestNode)CollectionsKt.first(result.getNodes());
    }

    public static /* synthetic */ TestNode fetchTestNode$default(TestNodeSelection testNodeSelection, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Failed";
        }
        return testNodeSelection.fetchTestNode(string);
    }

    @NotNull
    public final TestNodeSelection assertExists() {
        this.fetchTestNode("Failed: assertExists");
        return this;
    }

    @NotNull
    public final TestNodeSelection assertDoesNotExist() {
        List<TestNode> result = this.fetchMatchingNodes().getNodes();
        if (!((Collection)result).isEmpty()) {
            ErrorsKt.throwCountMismatchError("Failed: assertDoesNotExist", this.selector, 0, result);
            throw new KotlinNothingValueException();
        }
        return this;
    }

    @NotNull
    public final TestNodeSelection assert(@NotNull TestNodeMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        TestNode testNode = this.fetchTestNode("Failed assertion: " + matcher.getDescription());
        if (!matcher.matches(testNode)) {
            ErrorsKt.throwGeneralError("Failed assertion: " + matcher.getDescription(), this.selector, testNode);
            throw new KotlinNothingValueException();
        }
        return this;
    }

    @NotNull
    public final TestNodeSelection selectChildAt(int index) {
        return this.selectChildren().selectAtIndex(index);
    }

    @NotNull
    public final TestNodeCollectionSelection selectChildren() {
        return new TestNodeCollectionSelection(this.testContext, TestNodeSelectorKt.plusSingleToManySelector(this.selector, "children", (Function1<? super TestNode, ? extends List<TestNode>>)((Function1)selectChildren.1.INSTANCE)));
    }

    private final SelectionResult fetchMatchingNodes() {
        List<TestNode> nodes = this.testContext.provideAllTestNodes();
        return this.selector.map(nodes);
    }
}

