/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.assertj;

import com.facebook.litho.Component;
import com.facebook.litho.testing.assertj.HamcrestCondition;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;

public final class ComponentConditions {
    private ComponentConditions() {
    }

    public static Condition<InspectableComponent> inspectedTypeIs(final Class<? extends Component> clazz) {
        return new Condition<InspectableComponent>((Description)new TextDescription("Component with type <%s>", new Object[]{clazz})){

            public boolean matches(InspectableComponent value) {
                Class component = value.getComponentClass();
                return component != null && component.equals(clazz);
            }
        };
    }

    public static Condition<Component> typeIs(final Class<? extends Component> clazz) {
        return new Condition<Component>((Description)new TextDescription("Component with type <%s>", new Object[]{clazz})){

            public boolean matches(Component value) {
                Class<?> componentClass = value.getClass();
                return componentClass != null && componentClass.equals(clazz);
            }
        };
    }

    public static Condition<Component> typeIs(final KClass<? extends Component> clazz) {
        return new Condition<Component>((Description)new TextDescription("Component with type <%s>", new Object[]{clazz})){

            public boolean matches(Component value) {
                Class<?> componentClass = value.getClass();
                return componentClass != null && componentClass.equals(JvmClassMappingKt.getJavaClass((KClass)clazz));
            }
        };
    }

    public static Condition<InspectableComponent> textEquals(CharSequence text) {
        return ComponentConditions.text((Matcher<String>)Is.is((Object)text.toString()));
    }

    public static Condition<InspectableComponent> textEquals(String text) {
        return ComponentConditions.text((Matcher<String>)Is.is((Object)text));
    }

    public static Condition<InspectableComponent> text(final Condition<String> condition) {
        return new Condition<InspectableComponent>(){

            public boolean matches(InspectableComponent value) {
                this.as("text <%s>", new Object[]{condition});
                return condition.matches((Object)value.getTextContent());
            }
        };
    }

    public static Condition<InspectableComponent> text(Matcher<String> matcher) {
        return ComponentConditions.text(new HamcrestCondition<String>(matcher));
    }
}

