/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.assertj;

import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import java.lang.reflect.Field;

public class ErrorMessage {
    static String getCompareComponentsErrorMessage(Component actual, @Nullable Component other) {
        if (other == null) {
            return "Other Component is null";
        }
        String separator = "\n----------\n";
        StringBuilder stringBuilder = new StringBuilder("\n");
        stringBuilder.append("Expected:").append(separator);
        ErrorMessage.getComponentInfo(actual, stringBuilder);
        stringBuilder.append(separator).append("to be equal to:").append(separator);
        ErrorMessage.getComponentInfo(other, stringBuilder);
        stringBuilder.append(separator).append("but wasn't");
        return stringBuilder.toString();
    }

    private static void getComponentInfo(Component component, StringBuilder stringBuilder) {
        stringBuilder.append(component.getSimpleName()).append("\n").append("class: ").append(component.getClass());
        for (Field field : component.getClass().getDeclaredFields()) {
            try {
                boolean wasAccessible = field.isAccessible();
                if (!wasAccessible) {
                    field.setAccessible(true);
                }
                stringBuilder.append("\n").append(field.getName()).append(" : ").append(field.get(component));
                if (wasAccessible) continue;
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

