/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.assertj;

import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.LithoView;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.testing.TestCollection;
import com.facebook.litho.testing.TestCollectionItem;
import com.facebook.litho.testing.TestLithoView;
import com.facebook.litho.testing.assertj.ErrorMessage;
import com.facebook.litho.testing.assertj.LithoViewAssert;
import com.facebook.litho.testing.assertj.TestCollectionAssert;
import com.facebook.litho.testing.assertj.TestCollectionItemAssert;
import java.util.List;
import kotlin.Pair;
import kotlin.reflect.KProperty1;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;

public class LithoAssertions {
    public static LithoComponentAssert assertThat(Component component) {
        return new LithoComponentAssert(component);
    }

    public static LithoViewAssert assertThat(LithoView lithoView) {
        return LithoViewAssert.assertThat(lithoView);
    }

    public static LithoViewAssert assertThat(TestLithoView testLithoView) {
        return LithoViewAssert.assertThat(testLithoView.getLithoView());
    }

    public static TestCollectionAssert assertThat(TestCollection collection) {
        return TestCollectionAssert.Companion.assertThat(collection);
    }

    public static TestCollectionItemAssert assertThat(TestCollectionItem collectionItem) {
        return TestCollectionItemAssert.assertThat(collectionItem);
    }

    public static ListAssert<Component> assertThat(List<Component> componentsList) {
        return new ListAssert(componentsList);
    }

    public static class LithoComponentAssert
    extends AbstractAssert<LithoComponentAssert, Component> {
        LithoComponentAssert(Component actual) {
            super((Object)actual, LithoComponentAssert.class);
        }

        public <T1, T2> LithoComponentAssert hasProps(Pair<KProperty1<T2, T1>, T1> ... propsValuePairs) {
            for (Pair<KProperty1<T2, T1>, T1> pair : propsValuePairs) {
                MatcherAssert.assertThat((Object)((KProperty1)pair.getFirst()).get(this.actual), (Matcher)IsEqual.equalTo((Object)pair.getSecond()));
            }
            return this;
        }

        public <T1, T2> LithoComponentAssert hasPropsMatching(Pair<KProperty1<T2, T1>, Matcher<T1>> ... propsMatcherPairs) {
            for (Pair<KProperty1<T2, T1>, Matcher<T1>> pair : propsMatcherPairs) {
                MatcherAssert.assertThat((Object)((KProperty1)pair.getFirst()).get(this.actual), (Matcher)((Matcher)pair.getSecond()));
            }
            return this;
        }

        public LithoComponentAssert isEquivalentTo(@Nullable Component other) {
            this.isEquivalentTo(other, ComponentsConfiguration.shouldCompareCommonPropsInIsEquivalentTo);
            return this;
        }

        public LithoComponentAssert isEquivalentTo(@Nullable Component other, boolean shouldCompareCommonProps) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Component)this.actual).isEquivalentTo(other, shouldCompareCommonProps)).overridingErrorMessage(ErrorMessage.getCompareComponentsErrorMessage((Component)this.actual, other), new Object[0])).isTrue();
            return this;
        }
    }
}

