/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.assertj;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import com.facebook.litho.Component;
import com.facebook.litho.LithoView;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.TestItem;
import com.facebook.litho.componentsfinder.ComponentsFinderKt;
import com.facebook.litho.testing.assertj.ComponentConditions;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.testing.viewtree.ViewTree;
import com.facebook.litho.testing.viewtree.ViewTreeAssert;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import kotlin.Pair;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.hamcrest.Matcher;

public class LithoViewAssert
extends AbstractAssert<LithoViewAssert, LithoView> {
    public static LithoViewAssert assertThat(LithoView actual) {
        return new LithoViewAssert(actual);
    }

    LithoViewAssert(LithoView actual) {
        super((Object)actual, LithoViewAssert.class);
    }

    public LithoViewAssert containsTestKey(String testKey) {
        return this.containsTestKey(testKey, LithoViewAssert.once());
    }

    public LithoViewAssert containsTestKey(String testKey, OccurrenceCount count) {
        Deque testItems = LithoViewTestHelper.findTestItems((LithoView)((LithoView)this.actual), (String)testKey);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)testItems).hasSize(count.times)).overridingErrorMessage("Expected to find test key <%s> in LithoView <%s> %s, but %s.", new Object[]{testKey, this.actual, count, testItems.isEmpty() ? "couldn't find it" : String.format(Locale.ROOT, "saw it %d times instead", testItems.size())})).isNotNull();
        return this;
    }

    public LithoViewAssert doesNotContainTestKey(String testKey) {
        TestItem testItem = LithoViewTestHelper.findTestItem((LithoView)((LithoView)this.actual), (String)testKey);
        Rect bounds = testItem == null ? null : testItem.getBounds();
        ((AbstractObjectAssert)Assertions.assertThat((Object)testItem).overridingErrorMessage("Expected not to find test key <%s> in LithoView <%s>, but it was present at bounds %s.", new Object[]{testKey, this.actual, bounds})).isNull();
        return this;
    }

    private ViewTreeAssert assertThatViewTree() {
        return ViewTreeAssert.assertThat(ViewTree.of((View)this.actual));
    }

    public LithoViewAssert hasContentDescription(String contentDescription) {
        this.assertThatViewTree().hasContentDescription(contentDescription);
        return this;
    }

    public LithoViewAssert hasContentDescription(@StringRes int resourceId) {
        this.assertThatViewTree().hasContentDescription(resourceId);
        return this;
    }

    public LithoViewAssert hasVisibleDrawable(@DrawableRes int drawableRes) {
        this.assertThatViewTree().hasVisibleDrawable(drawableRes);
        return this;
    }

    public LithoViewAssert hasVisibleDrawable(Drawable drawable) {
        this.assertThatViewTree().hasVisibleDrawable(drawable);
        return this;
    }

    public LithoViewAssert doesNotHaveVisibleDrawable(Drawable drawable) {
        this.assertThatViewTree().doesNotHaveVisibleDrawable(drawable);
        return this;
    }

    public LithoViewAssert doesNotHaveVisibleDrawable(@DrawableRes int drawableRes) {
        this.assertThatViewTree().doesNotHaveVisibleDrawable(drawableRes);
        return this;
    }

    public LithoViewAssert hasVisibleText(String text) {
        this.assertThatViewTree().hasVisibleText(text);
        return this;
    }

    public LithoViewAssert hasVisibleText(@StringRes int resourceId) {
        this.assertThatViewTree().hasVisibleText(resourceId);
        return this;
    }

    public LithoViewAssert doesNotHaveVisibleText(String text) {
        this.assertThatViewTree().doesNotHaveVisibleText(text);
        return this;
    }

    public LithoViewAssert doesNotHaveVisibleText(@StringRes int resourceId) {
        this.assertThatViewTree().doesNotHaveVisibleText(resourceId);
        return this;
    }

    public LithoViewAssert hasVisibleTextMatching(String pattern) {
        this.assertThatViewTree().hasVisibleTextMatching(pattern);
        return this;
    }

    public LithoViewAssert hasVisibleTextContaining(String text) {
        String regexPattern = String.format(".*%s.*", text);
        return this.hasVisibleTextMatching(regexPattern);
    }

    public LithoViewAssert doesNotHaveVisibleTextMatching(String pattern) {
        this.assertThatViewTree().doesNotHaveVisibleTextMatching(pattern);
        return this;
    }

    public LithoViewAssert doesNotHaveVisibleTextContaining(String text) {
        String regexPattern = String.format(".*%s.*", text);
        return this.doesNotHaveVisibleTextMatching(regexPattern);
    }

    public LithoViewAssert hasMeasuredWidthOf(int width) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)((LithoView)this.actual).getMeasuredWidth()).overridingErrorMessage("Expected LithoView to have a width of %d, but was %d.", new Object[]{width, ((LithoView)this.actual).getMeasuredWidth()})).isEqualTo(width);
        return this;
    }

    public LithoViewAssert hasMeasuredHeightOf(int height) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)((LithoView)this.actual).getMeasuredHeight()).overridingErrorMessage("Expected LithoView to have a height of %d, but was %d.", new Object[]{height, ((LithoView)this.actual).getMeasuredHeight()})).isEqualTo(height);
        return this;
    }

    public LithoViewAssert hasViewTag(int tagId, Object tagValue) {
        this.assertThatViewTree().hasViewTag(tagId, tagValue);
        return this;
    }

    public LithoViewAssert containsDirectComponents(KClass<? extends Component> ... kClazzes) {
        return this.containsDirectComponents(LithoViewAssert.getJavaClasses(kClazzes));
    }

    public LithoViewAssert containsDirectComponents(Class<? extends Component> ... clazzes) {
        SoftAssertions softAssertions = new SoftAssertions();
        for (Class<? extends Component> clazz : clazzes) {
            Component foundDirectComponent = ComponentsFinderKt.findDirectComponentInLithoView((LithoView)this.actual, clazz);
            ((ObjectAssert)softAssertions.assertThat((Object)foundDirectComponent).overridingErrorMessage("Expected to have direct component of type %s in LithoView, but did not find one", (Object[])clazzes)).isNotNull();
        }
        softAssertions.assertAll();
        return this;
    }

    public LithoViewAssert doesNotContainDirectComponents(KClass<? extends Component> ... kClazzes) {
        return this.doesNotContainDirectComponents(LithoViewAssert.getJavaClasses(kClazzes));
    }

    public LithoViewAssert doesNotContainDirectComponents(Class<? extends Component> ... clazzes) {
        SoftAssertions softAssertions = new SoftAssertions();
        for (Class<? extends Component> clazz : clazzes) {
            Component foundDirectComponent = ComponentsFinderKt.findDirectComponentInLithoView((LithoView)this.actual, clazz);
            ((ObjectAssert)softAssertions.assertThat((Object)foundDirectComponent).overridingErrorMessage("Expected to not have direct component of type %s in LithoView, but did not find one", new Object[]{clazz})).isNull();
        }
        softAssertions.assertAll();
        return this;
    }

    public LithoViewAssert containsExactlyOne(Class<? extends Component> clazz) {
        return this.containsExactly(1, clazz);
    }

    public LithoViewAssert containsExactly(int times, Class<? extends Component> clazz) {
        List<Component> componentsList = ComponentsFinderKt.findAllComponentsInLithoView((LithoView)this.actual, clazz);
        new ListAssert(componentsList).haveExactly(times, ComponentConditions.typeIs(clazz));
        return this;
    }

    public LithoViewAssert containsExactlyOne(KClass<? extends Component> clazz) {
        return this.containsExactly(1, clazz);
    }

    public LithoViewAssert containsExactly(int times, KClass<? extends Component> clazz) {
        this.containsExactly(times, JvmClassMappingKt.getJavaClass(clazz));
        return this;
    }

    public LithoViewAssert containsComponents(Class<? extends Component> ... clazz) {
        List<Component> componentList = ComponentsFinderKt.findAllComponentsInLithoView((LithoView)this.actual, clazz);
        for (Class<? extends Component> componentClass : clazz) {
            new ListAssert(componentList).haveAtLeastOne(ComponentConditions.typeIs(componentClass));
        }
        return this;
    }

    public LithoViewAssert containsComponents(KClass<? extends Component> ... clazz) {
        List<Component> componentList = ComponentsFinderKt.findAllComponentsInLithoView((LithoView)this.actual, clazz);
        for (KClass<? extends Component> componentClass : clazz) {
            new ListAssert(componentList).haveAtLeastOne(ComponentConditions.typeIs(componentClass));
        }
        return this;
    }

    public LithoViewAssert doesNotContainComponents(Class<? extends Component> ... clazz) {
        List<Component> componentList = ComponentsFinderKt.findAllComponentsInLithoView((LithoView)this.actual, clazz);
        Assertions.assertThat(componentList).isEmpty();
        return this;
    }

    public LithoViewAssert doesNotContainComponents(KClass<? extends Component> ... clazz) {
        List<Component> componentList = ComponentsFinderKt.findAllComponentsInLithoView((LithoView)this.actual, clazz);
        Assertions.assertThat(componentList).isEmpty();
        return this;
    }

    public LithoViewAssert willRenderContent() {
        Assertions.assertThat((((LithoView)this.actual).getMountItemCount() > 0 || ((LithoView)this.actual).getChildCount() > 0 ? 1 : 0) != 0).overridingErrorMessage("Expected content to be visible, but current LithoView childCount = 0 and we did not mount any content", new Object[0]);
        return this;
    }

    public LithoViewAssert willNotRenderContent() {
        ((AbstractBooleanAssert)Assertions.assertThat((((LithoView)this.actual).getMountItemCount() == 0 && ((LithoView)this.actual).getChildCount() == 0 ? 1 : 0) != 0).overridingErrorMessage("Expected no content in the current LithoView, but found child count = %d and mounted item count = %d with LithoView hierarchy:\n %s", new Object[]{((LithoView)this.actual).getChildCount(), ((LithoView)this.actual).getMountItemCount(), ((LithoView)this.actual).toString()})).isTrue();
        return this;
    }

    public LithoViewAssert hasDirectMatchingComponent(Condition<InspectableComponent> condition) {
        InspectableComponent inspectableComponent = InspectableComponent.getRootInstance((LithoView)this.actual);
        boolean conditionMet = false;
        for (InspectableComponent component : inspectableComponent.getChildComponents()) {
            if (!condition.matches((Object)component)) continue;
            conditionMet = true;
            break;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)conditionMet).overridingErrorMessage("Expected LithoView <%s> to satisfy condition <%s>", new Object[]{this.actual, condition})).isTrue();
        return this;
    }

    public LithoViewAssert hasAnyMatchingComponent(Condition<InspectableComponent> condition) {
        InspectableComponent inspectableComponent = InspectableComponent.getRootInstance((LithoView)this.actual);
        boolean conditionMet = this.iterateOverAllChildren(Collections.singletonList(inspectableComponent), condition);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)conditionMet).overridingErrorMessage("Expected LithoView <%s> to satisfy condition <%s>", new Object[]{this.actual, condition})).isTrue();
        return this;
    }

    private boolean iterateOverAllChildren(List<InspectableComponent> inspectableComponents, Condition<InspectableComponent> condition) {
        for (InspectableComponent component : inspectableComponents) {
            if (condition.matches((Object)component)) {
                return true;
            }
            if (!this.iterateOverAllChildren(component.getChildComponents(), condition)) continue;
            return true;
        }
        return false;
    }

    public <T1, T2> LithoViewAssert hasAnyMatchingComponent(KClass kClass, Pair<KProperty1<T2, T1>, T1> ... propsValuePairs) {
        List<Component> componentsList = ComponentsFinderKt.findAllComponentsInLithoView((LithoView)this.actual, kClass);
        boolean hasMatchingProps = this.hasMatchingProps(componentsList, propsValuePairs);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasMatchingProps).overridingErrorMessage("\nExpected LithoView : \n <%s> \n to contains component with given props, but the components that were found of given class: \n <%s> \ndid not satisfy all those props: \n %s ", new Object[]{this.actual, kClass.toString(), this.getPropsFormattedString(propsValuePairs)})).isTrue();
        return this;
    }

    public <T1, T2> LithoViewAssert hasDirectMatchingComponent(KClass kClass, Pair<KProperty1<T2, T1>, T1> ... propsValuePairs) {
        List<Component> componentsList = ComponentsFinderKt.findAllDirectComponentsInLithoView((LithoView)this.actual, (KClass<? extends Component>)kClass);
        boolean hasMatchingProps = this.hasMatchingProps(componentsList, propsValuePairs);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasMatchingProps).overridingErrorMessage("\nExpected LithoView : \n <%s> \n to contains direct component with props that matches given matcher, but the direct components that were found of given class: \n <%s>  did not satisfy all those props", new Object[]{this.actual, kClass.toString()})).isTrue();
        return this;
    }

    private <T1, T2> boolean hasMatchingProps(List<Component> componentsList, Pair<KProperty1<T2, T1>, T1>[] propsValuePairs) {
        for (Component component : componentsList) {
            if (!this.comparedPropsAreEqual(component, propsValuePairs)) continue;
            return true;
        }
        return false;
    }

    public <T2, T1> LithoViewAssert hasAnyMatchingComponentWithMatcher(KClass kClass, Pair<KProperty1<T2, T1>, Matcher<T1>> ... propsMatcherPairs) {
        List<Component> componentsList = ComponentsFinderKt.findAllComponentsInLithoView((LithoView)this.actual, kClass);
        boolean isMatching = this.hasMatchingPropsWithMatcher(componentsList, propsMatcherPairs);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)isMatching).overridingErrorMessage("\nExpected LithoView : \n <%s> \n to contains component with props that matches given matcher, but the components that were found of given class: \n <%s> \ndid not satisfy those matchers: \n %s ", new Object[]{this.actual, kClass.toString(), this.getPropsMatcherFormattedString(propsMatcherPairs)})).isTrue();
        return this;
    }

    public <T2, T1> LithoViewAssert hasDirectMatchingComponentWithMatcher(KClass kClass, Pair<KProperty1<T2, T1>, Matcher<T1>> ... propsMatcherPairs) {
        List<Component> componentsList = ComponentsFinderKt.findAllDirectComponentsInLithoView((LithoView)this.actual, (KClass<? extends Component>)kClass);
        boolean isMatching = this.hasMatchingPropsWithMatcher(componentsList, propsMatcherPairs);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)isMatching).overridingErrorMessage("\nExpected LithoView : \n <%s> \n to contains a direct component with props that matches given matcher, but the direct components that were found of given class: \n <%s> \ndid not satisfy those matchers: \n %s ", new Object[]{this.actual, kClass.toString(), this.getPropsMatcherFormattedString(propsMatcherPairs)})).isTrue();
        return this;
    }

    private <T2, T1> boolean hasMatchingPropsWithMatcher(List<Component> componentsList, Pair<KProperty1<T2, T1>, Matcher<T1>>[] propsMatcherPairs) {
        for (Component component : componentsList) {
            if (!this.comparedPropsMatch(component, propsMatcherPairs)) continue;
            return true;
        }
        return false;
    }

    private <T2, T1> String getPropsFormattedString(Pair<KProperty1<T2, T1>, T1>[] propsValuePairs) {
        StringBuilder sb = new StringBuilder();
        for (Pair<KProperty1<T2, T1>, T1> pair : propsValuePairs) {
            this.appendPairString(((KProperty1)pair.getFirst()).getName(), pair.getSecond().toString(), sb);
        }
        return sb.toString();
    }

    private <T2, T1> String getPropsMatcherFormattedString(Pair<KProperty1<T2, T1>, Matcher<T1>>[] propsMatcherPairs) {
        StringBuilder sb = new StringBuilder();
        for (Pair<KProperty1<T2, T1>, Matcher<T1>> pair : propsMatcherPairs) {
            this.appendPairString(((KProperty1)pair.getFirst()).getName(), ((Matcher)pair.getSecond()).toString(), sb);
        }
        return sb.toString();
    }

    private void appendPairString(String valueName, String value, StringBuilder sb) {
        sb.append(valueName);
        sb.append(" : ");
        sb.append(value);
        sb.append("\n");
    }

    private <T2, T1> boolean comparedPropsMatch(Component component, Pair<KProperty1<T2, T1>, Matcher<T1>>[] propsMatcherPairs) {
        for (Pair<KProperty1<T2, T1>, Matcher<T1>> pair : propsMatcherPairs) {
            if (((Matcher)pair.getSecond()).matches(((KProperty1)pair.getFirst()).get((Object)component))) continue;
            return false;
        }
        return true;
    }

    private <T2, T1> boolean comparedPropsAreEqual(Component component, Pair<KProperty1<T2, T1>, T1>[] propsValuePairs) {
        for (Pair<KProperty1<T2, T1>, T1> pair : propsValuePairs) {
            if (((KProperty1)pair.getFirst()).get((Object)component).equals(pair.getSecond())) continue;
            return false;
        }
        return true;
    }

    public static OccurrenceCount times(int i) {
        return new OccurrenceCount(i, i + " times");
    }

    public static OccurrenceCount once() {
        return new OccurrenceCount(1, "once");
    }

    private static Class<? extends Component>[] getJavaClasses(KClass<? extends Component> ... kClazzes) {
        Class[] jClazzes = new Class[kClazzes.length];
        for (int i = 0; i < kClazzes.length; ++i) {
            jClazzes[i] = JvmClassMappingKt.getJavaClass(kClazzes[i]);
        }
        return jClazzes;
    }

    public static class OccurrenceCount {
        final int times;
        final String shortName;

        OccurrenceCount(int times, String shortName) {
            this.times = times;
            this.shortName = shortName;
        }

        public String toString() {
            return this.shortName;
        }
    }
}

