/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.assertj;

import android.view.View;
import androidx.annotation.StringRes;
import androidx.test.core.app.ApplicationProvider;
import com.facebook.litho.Component;
import com.facebook.litho.LithoView;
import com.facebook.litho.testing.TestCollection;
import com.facebook.litho.testing.TestCollectionItem;
import com.facebook.litho.testing.viewtree.ViewPredicates;
import com.facebook.litho.testing.viewtree.ViewTree;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018J\"\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000e2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018J4\u0010\u001c\u001a\u00020\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001e\u0012\u0004\u0012\u00020\u001a0\u0018J \u0010\u001c\u001a\u00020\u00002\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001e\u0012\u0004\u0012\u00020\u001a0\u0018J\u001a\u0010\u001f\u001a\u00020\u00002\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018J\u001a\u0010 \u001a\u00020\u00002\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018J\u0014\u0010\u0013\u001a\u00020\u001a*\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0013\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020!0\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006#"}, d2={"Lcom/facebook/litho/testing/assertj/TestCollectionAssert;", "Lorg/assertj/core/api/AbstractAssert;", "Lcom/facebook/litho/testing/TestCollection;", "testCollection", "(Lcom/facebook/litho/testing/TestCollection;)V", "containsComponents", "components", "", "Lcom/facebook/litho/Component;", "([Lcom/facebook/litho/Component;)Lcom/facebook/litho/testing/assertj/TestCollectionAssert;", "containsExactlyComponents", "doesNotContainComponents", "doesNotHaveVisibleText", "textRes", "", "text", "", "hasSize", "size", "hasVisibleText", "onChild", "withId", "", "condition", "Lkotlin/Function1;", "Lcom/facebook/litho/testing/TestCollectionItem;", "", "withIndex", "onChildren", "matching", "", "onFirstChild", "onLastChild", "Lcom/facebook/litho/LithoView;", "Companion", "litho-testing_release"})
public final class TestCollectionAssert
extends AbstractAssert<TestCollectionAssert, TestCollection> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TestCollectionAssert(@NotNull TestCollection testCollection) {
        Intrinsics.checkNotNullParameter((Object)testCollection, (String)"testCollection");
        super((Object)testCollection, TestCollectionAssert.class);
    }

    @NotNull
    public final TestCollectionAssert hasSize(int size) {
        Assertions.assertThat(((TestCollection)this.actual).getItems()).hasSize(size);
        return this;
    }

    @NotNull
    public final TestCollectionAssert onChild(int withIndex, @NotNull Function1<? super TestCollectionItem, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Assertions.assertThat((boolean)((Boolean)condition.invoke((Object)((TestCollection)this.actual).getItems().get(withIndex)))).isTrue();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestCollectionAssert onChild(@NotNull Object withId, @NotNull Function1<? super TestCollectionItem, Boolean> condition) {
        Object element$iv2;
        Function1<? super TestCollectionItem, Boolean> function1;
        block1: {
            void $this$first$iv;
            Intrinsics.checkNotNullParameter((Object)withId, (String)"withId");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Iterable iterable = ((TestCollection)this.actual).getItems();
            function1 = condition;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                TestCollectionItem it = (TestCollectionItem)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)withId)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Assertions.assertThat((boolean)((Boolean)function1.invoke(element$iv2))).isTrue();
        return this;
    }

    @NotNull
    public final TestCollectionAssert onFirstChild(@NotNull Function1<? super TestCollectionItem, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Assertions.assertThat((boolean)((Boolean)condition.invoke(CollectionsKt.first(((TestCollection)this.actual).getItems())))).isTrue();
        return this;
    }

    @NotNull
    public final TestCollectionAssert onLastChild(@NotNull Function1<? super TestCollectionItem, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Assertions.assertThat((boolean)((Boolean)condition.invoke(CollectionsKt.last(((TestCollection)this.actual).getItems())))).isTrue();
        return this;
    }

    @NotNull
    public final TestCollectionAssert onChildren(@NotNull Function1<? super List<TestCollectionItem>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Assertions.assertThat((boolean)((Boolean)condition.invoke(((TestCollection)this.actual).getItems()))).isTrue();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestCollectionAssert onChildren(@NotNull Function1<? super TestCollectionItem, Boolean> matching, @NotNull Function1<? super List<TestCollectionItem>, Boolean> condition) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(matching, (String)"matching");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Iterable iterable = ((TestCollection)this.actual).getItems();
        Function1<? super List<TestCollectionItem>, Boolean> function1 = condition;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)matching.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Assertions.assertThat((boolean)((Boolean)function1.invoke((Object)((List)destination$iv$iv)))).isTrue();
        return this;
    }

    @NotNull
    public final TestCollectionAssert containsComponents(Component ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Component[] $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object v0;
            block2: {
                Component element$iv;
                Component component = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Iterable $this$firstOrNull$iv = ((TestCollection)this.actual).getItems();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    TestCollectionItem it = (TestCollectionItem)element$iv2;
                    boolean bl2 = false;
                    if (!it.getComponent().isEquivalentTo(component)) continue;
                    v0 = element$iv2;
                    break block2;
                }
                v0 = null;
            }
            TestCollectionItem equivalentComponent = v0;
            Assertions.assertThat((Object)equivalentComponent).isNotNull();
        }
        return this;
    }

    @NotNull
    public final TestCollectionAssert doesNotContainComponents(Component ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Component[] $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object v0;
            block2: {
                Component element$iv;
                Component component = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Iterable $this$firstOrNull$iv = ((TestCollection)this.actual).getItems();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    TestCollectionItem it = (TestCollectionItem)element$iv2;
                    boolean bl2 = false;
                    if (!it.getComponent().isEquivalentTo(component)) continue;
                    v0 = element$iv2;
                    break block2;
                }
                v0 = null;
            }
            TestCollectionItem equivalentComponent = v0;
            Assertions.assertThat((Object)equivalentComponent).isNull();
        }
        return this;
    }

    @NotNull
    public final TestCollectionAssert containsExactlyComponents(Component ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)((TestCollection)this.actual).getItems(), (Object[])components);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            TestCollectionItem a = (TestCollectionItem)pair.component1();
            Component b = (Component)pair.component2();
            Assertions.assertThat((boolean)a.getComponent().isEquivalentTo(b)).isTrue();
        }
        return this;
    }

    @NotNull
    public final TestCollectionAssert hasVisibleText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object[] objectArray = new Object[]{text};
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.hasVisibleText(((TestCollection)this.actual).getLithoViews(), text)).overridingErrorMessage("Expected visible text \"<%s>\", but was not found.", objectArray)).isTrue();
        return this;
    }

    @NotNull
    public final TestCollectionAssert hasVisibleText(@StringRes int textRes) {
        String string = ApplicationProvider.getApplicationContext().getResources().getString(textRes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationContext<Co\u2026rces().getString(textRes)");
        return this.hasVisibleText(string);
    }

    @NotNull
    public final TestCollectionAssert doesNotHaveVisibleText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object[] objectArray = new Object[]{text};
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.hasVisibleText(((TestCollection)this.actual).getLithoViews(), text)).overridingErrorMessage("Did not expect visible text \"<%s>\"", objectArray)).isFalse();
        return this;
    }

    @NotNull
    public final TestCollectionAssert doesNotHaveVisibleText(@StringRes int textRes) {
        String string = ApplicationProvider.getApplicationContext().getResources().getString(textRes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationContext<Co\u2026rces().getString(textRes)");
        return this.doesNotHaveVisibleText(string);
    }

    private final boolean hasVisibleText(LithoView $this$hasVisibleText, String text) {
        ImmutableList<View> children;
        ViewTree viewTree = ViewTree.of((View)$this$hasVisibleText);
        ImmutableList<View> immutableList = children = viewTree.findChild(ViewPredicates.hasVisibleText(text), ViewPredicates.isVisible());
        return immutableList != null ? !((Collection)immutableList).isEmpty() : false;
    }

    private final boolean hasVisibleText(List<? extends LithoView> $this$hasVisibleText, String text) {
        for (LithoView lithoView : $this$hasVisibleText) {
            if (!this.hasVisibleText(lithoView, text)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/litho/testing/assertj/TestCollectionAssert$Companion;", "", "()V", "assertThat", "Lcom/facebook/litho/testing/assertj/TestCollectionAssert;", "actual", "Lcom/facebook/litho/testing/TestCollection;", "litho-testing_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TestCollectionAssert assertThat(@NotNull TestCollection actual) {
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            return new TestCollectionAssert(actual);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

