/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.eventhandler;

import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.HasEventDispatcher;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class EventHandlerTestHelper {
    public static <E, R> EventHandler<E> createMockEventHandler(Class eventClass, final MockEventHandler<E, R> handler) {
        final EventDispatcher dispatcher = (EventDispatcher)Mockito.mock(EventDispatcher.class);
        Mockito.when((Object)dispatcher.dispatchOnEvent((EventHandler)Mockito.any(EventHandler.class), Mockito.any((Class)eventClass))).then(new Answer<R>(){

            public R answer(InvocationOnMock invocation) throws Throwable {
                Object event = invocation.getArguments()[1];
                if (event != null) {
                    return handler.handleEvent(event);
                }
                return null;
            }
        });
        return new EventHandler(new HasEventDispatcher(){

            public EventDispatcher getEventDispatcher() {
                return dispatcher;
            }
        }, 0, null);
    }

    public static interface MockEventHandler<E, R> {
        public R handleEvent(E var1);
    }
}

