/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.helper;

import android.graphics.Rect;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LithoNode;
import com.facebook.litho.LithoView;
import com.facebook.litho.ResolveStateContext;
import com.facebook.litho.TestComponent;
import com.facebook.litho.TestLayoutState;
import com.facebook.litho.TreeProps;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.testing.Whitebox;
import com.facebook.litho.testing.helper.VisibilityEventsHelper;
import com.facebook.litho.testing.subcomponents.SubComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.shadows.ShadowLooper;

public final class ComponentTestHelper {
    private ComponentTestHelper() {
    }

    public static LithoView mountComponent(Component.Builder component) {
        return ComponentTestHelper.mountComponent(ComponentTestHelper.getContext(component), component.build());
    }

    public static LithoView mountComponent(Component.Builder component, boolean incrementalMountEnabled, boolean visibilityProcessingEnabled) {
        ComponentContext context = ComponentTestHelper.getContext(component);
        return ComponentTestHelper.mountComponent(context, new LithoView(context), component.build(), incrementalMountEnabled, visibilityProcessingEnabled, 100, 100);
    }

    public static LithoView mountComponent(ComponentContext context, Component component) {
        return ComponentTestHelper.mountComponent(context, component, 100, 100);
    }

    public static LithoView mountComponent(ComponentContext context, Component component, boolean incrementalMountEnabled, boolean visibilityProcessingEnabled) {
        return ComponentTestHelper.mountComponent(context, new LithoView(context), component, incrementalMountEnabled, visibilityProcessingEnabled, 100, 100);
    }

    public static LithoView mountComponent(ComponentContext context, Component component, int width, int height) {
        return ComponentTestHelper.mountComponent(context, new LithoView(context), component, width, height);
    }

    public static LithoView mountComponent(ComponentContext context, LithoView lithoView, Component component) {
        return ComponentTestHelper.mountComponent(context, lithoView, component, 100, 100);
    }

    public static LithoView mountComponent(ComponentContext context, LithoView lithoView, Component component, int width, int height) {
        return ComponentTestHelper.mountComponent(context, lithoView, component, false, false, width, height);
    }

    public static LithoView mountComponent(ComponentContext context, LithoView lithoView, Component component, boolean incrementalMountEnabled, boolean visibilityProcessingEnabled, int width, int height) {
        return ComponentTestHelper.mountComponent(lithoView, ComponentTree.create((ComponentContext)context, (Component)component).incrementalMount(incrementalMountEnabled).layoutDiffing(false).visibilityProcessing(visibilityProcessingEnabled).build(), View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public static LithoView mountComponent(LithoView lithoView, ComponentTree componentTree) {
        return ComponentTestHelper.mountComponent(lithoView, componentTree, View.MeasureSpec.makeMeasureSpec((int)100, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)100, (int)0x40000000));
    }

    public static LithoView mountComponent(LithoView lithoView, ComponentTree componentTree, Component component) {
        componentTree.setRoot(component);
        return ComponentTestHelper.mountComponent(lithoView, componentTree, View.MeasureSpec.makeMeasureSpec((int)100, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)100, (int)0x40000000));
    }

    public static LithoView mountComponent(LithoView lithoView, ComponentTree componentTree, int widthSpec, int heightSpec) {
        boolean addParent = lithoView.getParent() == null;
        ViewGroup parent = new ViewGroup(lithoView.getContext()){

            protected void onLayout(boolean changed, int l, int t, int r, int b) {
            }
        };
        if (addParent) {
            parent.addView((View)lithoView);
        }
        lithoView.setComponentTree(componentTree);
        try {
            Whitebox.invokeMethod(lithoView, "onAttach", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        lithoView.measure(widthSpec, heightSpec);
        if (addParent) {
            parent.layout(0, 0, lithoView.getMeasuredWidth(), lithoView.getMeasuredHeight());
        }
        lithoView.layout(0, 0, lithoView.getMeasuredWidth(), lithoView.getMeasuredHeight());
        return lithoView;
    }

    public static void unmountComponent(LithoView lithoView) {
        if (!lithoView.isIncrementalMountEnabled()) {
            throw new IllegalArgumentException("In order to test unmounting a Component, it needs to be mounted with incremental mount enabled. Please use a mountComponent() variation that accepts an incrementalMountEnabled argument");
        }
        Rect rect = new Rect(99999, 99999, 999999, 999999);
        lithoView.notifyVisibleBoundsChanged(rect, true);
    }

    public static void unbindComponent(LithoView lithoView) {
        try {
            Whitebox.invokeMethod(lithoView, "onDetach", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static List<SubComponent> getSubComponents(Component.Builder component) {
        return ComponentTestHelper.getSubComponents(ComponentTestHelper.getContext(component), component.build());
    }

    @Deprecated
    public static List<SubComponent> getSubComponents(ComponentContext context, Component component) {
        return ComponentTestHelper.getSubComponents(context, component, View.MeasureSpec.makeMeasureSpec((int)1000, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
    }

    @Deprecated
    public static List<SubComponent> getSubComponents(Component.Builder component, int widthSpec, int heightSpec) {
        return ComponentTestHelper.getSubComponents(ComponentTestHelper.getContext(component), component.build(), widthSpec, heightSpec);
    }

    @Deprecated
    public static List<SubComponent> getSubComponents(ComponentContext context, Component component, int widthSpec, int heightSpec) {
        return ComponentTestHelper.getImmediateSubComponents(context, component, widthSpec, heightSpec);
    }

    @Deprecated
    private static List<SubComponent> getImmediateSubComponents(ComponentContext context, Component component, int widthSpec, int heightSpec) {
        List<Component> components = ComponentTestHelper.extractImmediateSubComponents(context, component, widthSpec, heightSpec);
        ArrayList<SubComponent> subComponents = new ArrayList<SubComponent>(components.size());
        for (Component lifecycle : components) {
            subComponents.add(SubComponent.of(lifecycle));
        }
        return subComponents;
    }

    @Deprecated
    public static <T extends Component> Component getSubComponent(Component.Builder component, Class<T> componentClass) {
        List<SubComponent> subComponents = ComponentTestHelper.getSubComponents(component);
        for (SubComponent subComponent : subComponents) {
            if (!subComponent.getComponentType().equals(componentClass)) continue;
            return subComponent.getComponent();
        }
        return null;
    }

    @Deprecated
    private static LithoNode resolveImmediateSubtree(ResolveStateContext resolveStateContext, ComponentContext c, Component component, int widthSpec, int heightSpec) {
        LithoNode node = TestLayoutState.createAndMeasureTreeForComponent((ResolveStateContext)resolveStateContext, (ComponentContext)c, (Component)component, (int)widthSpec, (int)heightSpec);
        return node;
    }

    @Deprecated
    private static List<Component> extractImmediateSubComponents(@Nullable LithoNode root) {
        if (root == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> output = new ArrayList<Component>();
        if (root.getChildCount() == 0) {
            if (root.getTailComponent() != null && root.getTailComponent() instanceof TestComponent) {
                TestComponent testSubcomponent = (TestComponent)root.getTailComponent();
                output.add(testSubcomponent.getWrappedComponent());
            }
            return output;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            LithoNode child = root.getChildAt(i);
            output.addAll(ComponentTestHelper.extractImmediateSubComponents(child));
        }
        return output;
    }

    @Deprecated
    private static List<Component> extractImmediateSubComponents(ComponentContext context, Component component, int widthSpec, int heightSpec) {
        ComponentTree tree = ComponentTree.create((ComponentContext)context).build();
        ComponentContext c = new ComponentContext(ComponentContext.withComponentTree((ComponentContext)new ComponentContext(context), (ComponentTree)tree));
        ResolveStateContext rsc = c.setRenderStateContextForTests();
        LithoNode root = ComponentTestHelper.resolveImmediateSubtree(rsc, c, component, widthSpec, heightSpec);
        return ComponentTestHelper.extractImmediateSubComponents(root);
    }

    public static void measureAndLayout(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)1000, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    public static void measureAndLayout(View view, int width, int height) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    private static ComponentContext getContext(Component.Builder builder) {
        return (ComponentContext)Whitebox.getInternalState(builder, "mContext");
    }

    @Deprecated
    public static LithoView dispatchOnVisibleEvent(ComponentContext context, EventHandler onVisibleHandler, Component component) {
        return ComponentTestHelper.dispatchVisibilityEvent(context, onVisibleHandler, new VisibleEvent(), component);
    }

    @Deprecated
    public static LithoView dispatchOnFocusedVisibleEvent(ComponentContext context, EventHandler onFocusedVisibleHandler, Component component) {
        return ComponentTestHelper.dispatchVisibilityEvent(context, onFocusedVisibleHandler, new FocusedVisibleEvent(), component);
    }

    @Deprecated
    public static LithoView dispatchOnInvisibleEvent(ComponentContext context, EventHandler onInvisibleHandler, Component component) {
        return ComponentTestHelper.dispatchVisibilityEvent(context, onInvisibleHandler, new InvisibleEvent(), component);
    }

    @Deprecated
    private static LithoView dispatchVisibilityEvent(ComponentContext context, EventHandler eventHandler, Object eventInstance, Component component) {
        LithoView lithoView = new LithoView(context);
        FrameLayout parent = new FrameLayout(context.getAndroidContext());
        parent.addView((View)lithoView);
        ComponentTestHelper.mountComponent(context, lithoView, component, true, true, 100, 100);
        lithoView.notifyVisibleBoundsChanged();
        eventHandler.dispatchInfo.hasEventDispatcher = component;
        try {
            Whitebox.invokeMethod(component.getEventDispatcher(), "dispatchOnEvent", eventHandler, eventInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lithoView;
    }

    public static boolean triggerVisibilityEvent(LithoView lithoView, Class<?> visibilityClass) {
        return VisibilityEventsHelper.triggerVisibilityEvent(lithoView.getComponentTree(), visibilityClass);
    }

    public static void setTreeProp(ComponentContext context, Class propClass, Object prop) {
        TreeProps treeProps;
        try {
            treeProps = (TreeProps)Whitebox.invokeMethod(context, "getTreeProps", new Object[0]);
            if (treeProps == null) {
                treeProps = new TreeProps();
                Whitebox.invokeMethod(context, "setTreeProps", treeProps);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        treeProps.put(propClass, prop);
    }

    public static void setParentTreeProp(ComponentContext context, Class propClass, Object prop) {
        TreeProps treeProps;
        try {
            treeProps = (TreeProps)Whitebox.invokeMethod(context, "getParentTreeProps", new Object[0]);
            if (treeProps == null) {
                treeProps = new TreeProps();
                Whitebox.invokeMethod(context, "setParentTreeProps", treeProps);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        treeProps.put(propClass, prop);
    }

    @Deprecated
    @VisibleForTesting
    public static ComponentContext createScopedComponentContextWithStateForTest(ComponentContext parent, Component component, String key) {
        return ComponentContext.createScopedComponentContextWithStateForTest((ComponentContext)parent, (Component)component, (String)key);
    }

    public static Looper getDefaultLayoutThreadLooper() {
        return (Looper)Whitebox.invokeMethod(ComponentTree.class, "getDefaultLayoutThreadLooper", new Object[0]);
    }

    public static Looper getDefaultResolveThreadLooper() {
        return (Looper)Whitebox.invokeMethod(ComponentTree.class, "getDefaultResolveThreadLooper", new Object[0]);
    }

    public static ShadowLooper getDefaultLayoutThreadShadowLooper() {
        return Shadows.shadowOf((Looper)ComponentTestHelper.getDefaultLayoutThreadLooper());
    }

    public static ShadowLooper getDefaultResolveThreadShadowLooper() {
        return Shadows.shadowOf((Looper)ComponentTestHelper.getDefaultResolveThreadLooper());
    }

    public static ShadowLooper[] getDefaultThreadShadowLoopers() {
        if (ComponentsConfiguration.isResolveAndLayoutFuturesSplitEnabled) {
            return new ShadowLooper[]{ComponentTestHelper.getDefaultResolveThreadShadowLooper(), ComponentTestHelper.getDefaultLayoutThreadShadowLooper()};
        }
        return new ShadowLooper[]{ComponentTestHelper.getDefaultLayoutThreadShadowLooper()};
    }
}

