/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.helper;

import com.facebook.litho.ComponentTree;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.testing.Whitebox;
import com.facebook.rendercore.Function;
import com.facebook.rendercore.visibility.VisibilityUtils;

public class VisibilityEventsHelper {
    public static boolean triggerVisibilityEvent(ComponentTree componentTree, Class<?> visibilityEventType) {
        try {
            Object layoutState = VisibilityEventsHelper.getGetMainThreadLayoutState(componentTree);
            int size = VisibilityEventsHelper.getVisibilityOutputCount(layoutState);
            for (int i = 0; i < size; ++i) {
                Object visibilityOutput = VisibilityEventsHelper.getVisibilityOutputAt(layoutState, i);
                if (visibilityEventType == VisibleEvent.class && VisibilityEventsHelper.getEventHandler(visibilityOutput, "Visible") != null) {
                    VisibilityUtils.dispatchOnVisible(VisibilityEventsHelper.getEventHandler(visibilityOutput, "Visible"), null);
                    return true;
                }
                if (visibilityEventType == InvisibleEvent.class && VisibilityEventsHelper.getEventHandler(visibilityOutput, "Invisible") != null) {
                    VisibilityEventsHelper.dispatch(VisibilityEventsHelper.getEventHandler(visibilityOutput, "Invisible"), "Invisible");
                    return true;
                }
                if (visibilityEventType == FocusedVisibleEvent.class && VisibilityEventsHelper.getEventHandler(visibilityOutput, "Focused") != null) {
                    VisibilityEventsHelper.dispatch(VisibilityEventsHelper.getEventHandler(visibilityOutput, "Focused"), "Focused");
                    return true;
                }
                if (visibilityEventType == UnfocusedVisibleEvent.class && VisibilityEventsHelper.getEventHandler(visibilityOutput, "Unfocused") != null) {
                    VisibilityEventsHelper.dispatch(VisibilityEventsHelper.getEventHandler(visibilityOutput, "Unfocused"), "Unfocused");
                    return true;
                }
                if (visibilityEventType != FullImpressionVisibleEvent.class || VisibilityEventsHelper.getEventHandler(visibilityOutput, "FullImpression") == null) continue;
                VisibilityEventsHelper.dispatch(VisibilityEventsHelper.getEventHandler(visibilityOutput, "FullImpression"), "FullImpression");
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getGetMainThreadLayoutState(ComponentTree componentTree) {
        return Whitebox.invokeMethod(componentTree, "getMainThreadLayoutState", new Object[0]);
    }

    private static int getVisibilityOutputCount(Object layoutState) {
        return (Integer)Whitebox.invokeMethod(layoutState, "getVisibilityOutputCount", new Object[0]);
    }

    private static Object getVisibilityOutputAt(Object layoutState, int i) {
        return Whitebox.invokeMethod(layoutState, "getVisibilityOutputAt", i);
    }

    private static Function<Void> getEventHandler(Object layoutState, String name) {
        return (Function)Whitebox.invokeMethod(layoutState, "get" + name + "EventHandler", new Object[0]);
    }

    private static void dispatch(Object eventHandler, String name) throws ClassNotFoundException {
        Whitebox.invokeMethod(Class.forName("com.facebook.rendercore.visibility.VisibilityUtils"), "dispatchOn" + name, eventHandler);
    }
}

