/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.logging;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.facebook.litho.DefaultComponentsReporter;
import com.facebook.rendercore.LogLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TestComponentsReporter
extends DefaultComponentsReporter {
    private final List<Pair<LogLevel, String>> mLoggedMessages = new LinkedList<Pair<LogLevel, String>>();
    private final List<Pair<LogLevel, String>> mLoggedCategoryKeys = new LinkedList<Pair<LogLevel, String>>();

    public List<Pair<LogLevel, String>> getLoggedMessages() {
        return this.mLoggedMessages;
    }

    public List<Pair<LogLevel, String>> getLoggedCategoryKeys() {
        return this.mLoggedCategoryKeys;
    }

    public void report(LogLevel level, String categoryKey, String message, @Nullable Throwable cause, int samplingFrequency, @Nullable Map<String, Object> metadata) {
        super.report(level, categoryKey, message, cause, samplingFrequency, metadata);
        this.mLoggedMessages.add((Pair<LogLevel, String>)new Pair((Object)level, (Object)message));
        this.mLoggedCategoryKeys.add((Pair<LogLevel, String>)new Pair((Object)level, (Object)categoryKey));
    }

    public boolean hasMessageType(LogLevel logLevel) {
        for (Pair<LogLevel, String> loggedMessage : this.mLoggedMessages) {
            if (loggedMessage.first != logLevel) continue;
            return true;
        }
        return false;
    }
}

