/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.sections;

import android.content.Context;
import com.facebook.litho.EventHandler;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.StateContainer;
import com.facebook.litho.sections.Children;
import com.facebook.litho.sections.Section;
import com.facebook.litho.sections.SectionContext;
import com.facebook.litho.sections.SectionLifecycle;
import com.facebook.litho.sections.SectionLifecycleTestUtil;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.testing.sections.SubSection;
import com.facebook.litho.testing.sections.TestTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SectionsTestHelper
extends Section {
    private final SectionTree mSectionTree;
    private final SectionContext mSectionContext;
    private final Map<Section, SectionContext> preparedSections;

    public SectionsTestHelper(Context c) {
        this(new SectionContext(c));
    }

    public SectionsTestHelper(SectionContext base) {
        super("SectionComponentTestHelper");
        this.mSectionTree = SectionTree.create((SectionContext)base, (SectionTree.Target)new TestTarget()).build();
        this.mSectionContext = SectionContext.withSectionTree((SectionContext)base, (SectionTree)this.mSectionTree);
        this.preparedSections = new HashMap<Section, SectionContext>();
    }

    public boolean isEquivalentTo(Section other) {
        return ((Object)((Object)this)).equals(other);
    }

    public SectionContext getContext() {
        return this.mSectionContext;
    }

    @Nullable
    public SectionContext getScopedContext(Section s) {
        this.ensurePrepared(s);
        return this.preparedSections.get(s);
    }

    public Section prepare(Section s) {
        SectionContext context = SectionContext.withScope((SectionContext)this.mSectionContext, (Section)s);
        SectionContext spyContext = (SectionContext)Mockito.spy((Object)context);
        ((SectionContext)Mockito.doAnswer((Answer)new Answer(){

            @Nullable
            public Object answer(InvocationOnMock invocation) throws Throwable {
                Section scope = ((SectionContext)invocation.getMock()).getSectionScope();
                StateContainer.StateUpdate stateUpdate = (StateContainer.StateUpdate)invocation.getArguments()[0];
                SectionLifecycleTestUtil.getStateContainer((Section)scope).applyStateUpdate(stateUpdate);
                return null;
            }
        }).when((Object)spyContext)).updateStateSync((StateContainer.StateUpdate)Matchers.any(StateContainer.StateUpdate.class), (String)Matchers.any(String.class));
        ((SectionContext)Mockito.doAnswer((Answer)new Answer(){

            @Nullable
            public Object answer(InvocationOnMock invocation) throws Throwable {
                Section scope = ((SectionContext)invocation.getMock()).getSectionScope();
                StateContainer.StateUpdate stateUpdate = (StateContainer.StateUpdate)invocation.getArguments()[0];
                SectionLifecycleTestUtil.getStateContainer((Section)scope).applyStateUpdate(stateUpdate);
                return null;
            }
        }).when((Object)spyContext)).updateStateAsync((StateContainer.StateUpdate)Matchers.any(StateContainer.StateUpdate.class), (String)Matchers.any(String.class));
        ((SectionContext)Mockito.doAnswer((Answer)new Answer(){

            @Nullable
            public Object answer(InvocationOnMock invocation) throws Throwable {
                Section scope = ((SectionContext)invocation.getMock()).getSectionScope();
                StateContainer.StateUpdate stateUpdate = (StateContainer.StateUpdate)invocation.getArguments()[0];
                SectionLifecycleTestUtil.getStateContainer((Section)scope).applyStateUpdate(stateUpdate);
                return null;
            }
        }).when((Object)spyContext)).updateStateLazy((StateContainer.StateUpdate)Matchers.any(StateContainer.StateUpdate.class));
        ((SectionContext)Mockito.doReturn((Object)this.mSectionContext.getResourceCache()).when((Object)spyContext)).getResourceCache();
        SectionLifecycleTestUtil.setScopedContext((Section)s, (SectionContext)spyContext);
        SectionLifecycleTestUtil.createInitialState((SectionLifecycle)s, (SectionContext)spyContext, (Section)s);
        s.setGlobalKey("globalKey");
        this.preparedSections.put(s, spyContext);
        return s;
    }

    @Nullable
    public List<SubSection> getChildren(Section section) {
        this.ensurePrepared(section);
        Children children = SectionLifecycleTestUtil.createChildren((SectionLifecycle)section, (SectionContext)SectionContext.withScope((SectionContext)this.getScopedContext(section), (Section)section), (Section)section);
        return SectionsTestHelper.getSubSections(children);
    }

    @Nullable
    public static List<SubSection> getSubSections(Children children) {
        if (children == null || children.getChildren() == null) {
            return null;
        }
        ArrayList<SubSection> subsection = new ArrayList<SubSection>(children.getChildren().size());
        for (Section s : children.getChildren()) {
            subsection.add(SubSection.of(s));
        }
        return subsection;
    }

    public <T extends StateContainer> T getStateContainer(Section section) {
        return (T)SectionLifecycleTestUtil.getStateContainer((Section)this.getScopedContext(section).getSectionScope());
    }

    public static Object dispatchEvent(HasEventDispatcher section, EventHandler eventHandler, Object event) {
        return section.getEventDispatcher().dispatchOnEvent(eventHandler, event);
    }

    private void ensurePrepared(Section s) {
        if (!this.preparedSections.containsKey(s)) {
            throw new IllegalStateException("Section not prepared, did you call SectionsTestHelper#prepare()?");
        }
    }
}

