/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.sections;

import com.facebook.litho.sections.Section;
import com.facebook.litho.sections.SectionLifecycle;

public class SubSection {
    private final Class<? extends SectionLifecycle> mSectionType;
    private final Section mSection;

    public static SubSection of(Class<? extends SectionLifecycle> sectionType) {
        return new SubSection(sectionType, null);
    }

    public static SubSection of(Section section) {
        return new SubSection(section.getClass(), section);
    }

    private SubSection(Class<? extends SectionLifecycle> sectionType, Section section) {
        this.mSectionType = sectionType;
        this.mSection = section;
    }

    public Section getSection() {
        return this.mSection;
    }

    public Class<? extends SectionLifecycle> getSectionType() {
        return this.mSectionType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SubSection)) {
            return false;
        }
        SubSection that = (SubSection)o;
        return that.mSectionType.equals(this.mSectionType) && SubSection.arePropsEqual(that.mSection, this.mSection);
    }

    public int hashCode() {
        return this.mSectionType.hashCode();
    }

    public String toString() {
        return this.mSectionType.toString() + " [" + super.toString() + "]";
    }

    private static boolean arePropsEqual(Section thatSection, Section thisSection) {
        return thatSection == null || thisSection == null || thatSection.isEquivalentTo(thisSection);
    }
}

