/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.sections;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.annotations.OnEvent;
import com.facebook.litho.annotations.Param;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.sections.Children;
import com.facebook.litho.sections.Section;
import com.facebook.litho.sections.SectionContext;
import com.facebook.litho.sections.annotations.GroupSectionSpec;
import com.facebook.litho.sections.annotations.OnCreateChildren;
import com.facebook.litho.sections.common.DataDiffSection;
import com.facebook.litho.sections.common.OnCheckIsSameContentEvent;
import com.facebook.litho.sections.common.OnCheckIsSameItemEvent;
import com.facebook.litho.sections.common.RenderEvent;
import com.facebook.litho.testing.sections.TestGroupSection;
import com.facebook.litho.widget.ComponentRenderInfo;
import com.facebook.litho.widget.RenderInfo;
import com.facebook.litho.widget.Text;
import java.util.Comparator;
import java.util.List;

@GroupSectionSpec
public class TestGroupSectionSpec {
    @OnCreateChildren
    protected static Children onCreateChildren(SectionContext c, @Prop List data, @Prop(optional=true) Comparator isSameItemComparator, @Prop(optional=true) Comparator isSameContentComparator) {
        DataDiffSection.Builder builder = DataDiffSection.create((SectionContext)c).data(data).renderEventHandler(TestGroupSection.onRender(c, (ComponentContext)c));
        if (isSameItemComparator != null) {
            builder.onCheckIsSameItemEventHandler(TestGroupSection.onCheckIsSameItem(c));
        }
        if (isSameContentComparator != null) {
            builder.onCheckIsSameContentEventHandler(TestGroupSection.onCheckIsSameContent(c));
        }
        return Children.create().child((Section)builder.build()).build();
    }

    @OnEvent(value=RenderEvent.class)
    protected static RenderInfo onRender(SectionContext c, Object model, @Param ComponentContext context) {
        return ((ComponentRenderInfo.Builder)ComponentRenderInfo.create().customAttribute("model", model)).component((Component)Text.create((ComponentContext)context).text((CharSequence)model.toString()).build()).build();
    }

    @OnEvent(value=OnCheckIsSameItemEvent.class)
    protected static boolean onCheckIsSameItem(SectionContext c, Object previousItem, Object nextItem, @Prop(optional=true) Comparator isSameItemComparator) {
        return isSameItemComparator.compare(previousItem, nextItem) == 0;
    }

    @OnEvent(value=OnCheckIsSameContentEvent.class)
    protected static boolean onCheckIsSameContent(SectionContext c, Object previousItem, Object nextItem, @Prop(optional=true) Comparator isSameContentComparator) {
        return isSameContentComparator.compare(previousItem, nextItem) == 0;
    }
}

