/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.sections;

import com.facebook.litho.StateContainer;
import com.facebook.litho.sections.Change;
import com.facebook.litho.sections.ChangeSet;
import com.facebook.litho.sections.ChangesInfo;
import com.facebook.litho.sections.Children;
import com.facebook.litho.sections.Section;
import com.facebook.litho.sections.SectionContext;
import com.facebook.litho.sections.SectionLifecycle;
import com.facebook.litho.sections.SectionLifecycleTestUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class TestSectionCreator {
    public static Section createChangeSetSection(int initialCount, String key, boolean forceShouldUpdate, Change ... changes) {
        return new ChangeSetSection(initialCount, key, forceShouldUpdate, changes);
    }

    public static ChildrenSectionTest createSectionComponent(String key, Section ... children) {
        return TestSectionCreator.createSectionComponent(key, false, children);
    }

    public static ChildrenSectionTest createSectionComponent(String key, boolean forceShouldUpdate, Section ... children) {
        return new ChildrenSectionTest(0, key, forceShouldUpdate, children);
    }

    public static Section createChangeSetComponent(String key, Change ... changes) {
        return TestSectionCreator.createChangeSetSection(0, key, false, changes);
    }

    public static Section createChangeSetComponent(String key, boolean forceShouldUpdate, Change ... changes) {
        return TestSectionCreator.createChangeSetSection(0, key, forceShouldUpdate, changes);
    }

    public static void createTree(Section section, SectionContext listContext) {
        if (!SectionLifecycleTestUtil.isDiffSectionSpec((SectionLifecycle)section)) {
            section.setChildren(SectionLifecycleTestUtil.createChildren((SectionLifecycle)section, (SectionContext)listContext, (Section)section));
            int size = section.getChildren().size();
            for (int i = 0; i < size; ++i) {
                TestSectionCreator.createTree((Section)section.getChildren().get(i), listContext);
            }
        }
    }

    public static class TestStateContainer
    extends StateContainer {
        public final Set<StateContainer.StateUpdate> appliedStateUpdate = new HashSet<StateContainer.StateUpdate>();

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            this.appliedStateUpdate.add(stateUpdate);
        }
    }

    public static class TestSection
    extends Section {
        private final boolean forceShouldUpdate;
        public boolean refreshCalled;
        public int firstVisibleIndex;
        public int lastVisibleIndex;
        public int firstFullyVisibleIndex;
        public int lastFullyVisibleIndex;
        private final StateContainer stateContainer = new TestStateContainer();

        protected TestSection(String simpleName, int initialCount, String key, boolean forceShouldUpdate) {
            super(simpleName);
            this.forceShouldUpdate = forceShouldUpdate;
            this.setCount(initialCount);
            this.setKey(key);
            this.setGlobalKey(key);
        }

        public boolean equals(Object o) {
            if (this.forceShouldUpdate) {
                return false;
            }
            return o.getClass().equals(((Object)((Object)this)).getClass()) && ((Section)o).getGlobalKey().equals(this.getGlobalKey());
        }

        public boolean isEquivalentTo(Section other) {
            return this.equals(other);
        }

        public Section makeShallowCopy() {
            return this;
        }

        @Nullable
        protected StateContainer getStateContainer() {
            return this.stateContainer;
        }
    }

    private static class ChangeSetSection
    extends TestSection {
        private final Change[] mChanges;

        ChangeSetSection(int initialCount, String key, boolean forceShouldUpdate, Change ... changes) {
            super("ChangeSetSection", initialCount, key, forceShouldUpdate);
            this.mChanges = changes;
        }

        protected void generateChangeSet(SectionContext c, ChangeSet changeSet, SectionContext previousScopedContext, Section previous, SectionContext nextScopedContext, Section next) {
            if (this.mChanges != null) {
                int size = this.mChanges.length;
                for (int i = 0; i < size; ++i) {
                    changeSet.addChange(this.mChanges[i]);
                }
            }
        }

        protected void refresh(SectionContext listContext) {
            this.refreshCalled = true;
        }

        public boolean isDiffSectionSpec() {
            return true;
        }

        protected void viewportChanged(SectionContext listContext, int firstVisibleItem, int lastVisibleItem, int totalItemsCount, int firstFullyVisibleItem, int lastFullyVisibleItem) {
            this.firstVisibleIndex = firstVisibleItem;
            this.lastVisibleIndex = lastVisibleItem;
            this.firstFullyVisibleIndex = firstFullyVisibleItem;
            this.lastFullyVisibleIndex = lastFullyVisibleItem;
        }
    }

    public static class ChildrenSectionTest
    extends TestSection {
        private final Section[] mChildren;
        public boolean onDataRendered = false;
        public ChangesInfo mChangesInfo;

        ChildrenSectionTest(int initialCount, String key, boolean forceShouldUpdate, Section ... children) {
            super("ChildrenSectionTest", initialCount, key, forceShouldUpdate);
            this.mChildren = children;
        }

        protected Children createChildren(SectionContext c) {
            Children.Builder builder = Children.create();
            if (this.mChildren != null) {
                for (Section child : this.mChildren) {
                    builder.child(child);
                }
            }
            return builder.build();
        }

        protected void refresh(SectionContext listContext) {
            this.refreshCalled = true;
        }

        protected void viewportChanged(SectionContext listContext, int firstVisibleItem, int lastVisibleItem, int totalItemsCount, int firstFullyVisibleItem, int lastFullyVisibleItem) {
            this.firstVisibleIndex = firstVisibleItem;
            this.lastVisibleIndex = lastVisibleItem;
            this.firstFullyVisibleIndex = firstFullyVisibleItem;
            this.lastFullyVisibleIndex = lastFullyVisibleItem;
        }

        protected void dataRendered(SectionContext c, boolean isDataChanged, boolean isMounted, long uptimeMillis, int firstVisibleIndex, int lastVisibleIndex, ChangesInfo changesInfo, int globalOffset) {
            this.onDataRendered = true;
            this.mChangesInfo = changesInfo;
        }
    }
}

