/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.sections;

import androidx.annotation.Nullable;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.widget.ChangeSetCompleteCallback;
import com.facebook.litho.widget.RenderInfo;
import com.facebook.litho.widget.SmoothScrollAlignmentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestTarget
implements SectionTree.Target {
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    public static final int MOVE = 3;
    public static final int INSERT_RANGE = 4;
    public static final int UPDATE_RANGE = 5;
    public static final int DELETE_RANGE = 6;
    final List<Operation> mOperations = new ArrayList<Operation>();
    final List<RenderInfo> mRenderInfos = new ArrayList<RenderInfo>();
    int mNumChanges = 0;
    int mFocusTo = -1;
    int mFocusToOffset = -1;
    boolean mWasNotifyChangeSetCompleteCalledWithChangedData = false;

    public List<Operation> getOperations() {
        return this.mOperations;
    }

    public int getNumChanges() {
        return this.mNumChanges;
    }

    public boolean wereChangesHandled() {
        return !this.mOperations.isEmpty();
    }

    public boolean wasNotifyChangeSetCompleteCalledWithChangedData() {
        return this.mWasNotifyChangeSetCompleteCalledWithChangedData;
    }

    public void insert(int index, RenderInfo renderInfo) {
        Object data = renderInfo.getCustomAttribute("model");
        this.mOperations.add(new Operation(0, index, null, data));
        ++this.mNumChanges;
        this.mRenderInfos.add(index, renderInfo);
    }

    public void insertRange(int index, int count, List<RenderInfo> renderInfos) {
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            data.add(renderInfos.get(i).getCustomAttribute("model"));
        }
        this.mOperations.add(new Operation(4, index, -1, count, null, data));
        this.mNumChanges += count;
        this.mRenderInfos.addAll(index, renderInfos);
    }

    public void update(int index, RenderInfo renderInfo) {
        Object oldData = this.mRenderInfos.get(index).getCustomAttribute("model");
        Object newData = renderInfo.getCustomAttribute("model");
        this.mOperations.add(new Operation(1, index, oldData, newData));
        ++this.mNumChanges;
        this.mRenderInfos.set(index, renderInfo);
    }

    public void updateRange(int index, int count, List<RenderInfo> renderInfos) {
        int i;
        ArrayList<Object> oldData = new ArrayList<Object>();
        for (int i2 = 0; i2 < count; ++i2) {
            oldData.add(this.mRenderInfos.get(index + i2).getCustomAttribute("model"));
        }
        ArrayList<Object> newData = new ArrayList<Object>();
        for (i = 0; i < count; ++i) {
            newData.add(renderInfos.get(i).getCustomAttribute("model"));
        }
        this.mOperations.add(new Operation(5, index, -1, count, oldData, newData));
        this.mNumChanges += count;
        for (i = 0; i < count; ++i) {
            this.mRenderInfos.set(index + i, renderInfos.get(i));
        }
    }

    public void delete(int index) {
        Object data = this.mRenderInfos.remove(index).getCustomAttribute("model");
        this.mOperations.add(new Operation(2, index, data, null));
        ++this.mNumChanges;
    }

    public void deleteRange(int index, int count) {
        List<RenderInfo> renderInfos = this.mRenderInfos.subList(index, index + count);
        ArrayList<Object> data = new ArrayList<Object>();
        int size = renderInfos.size();
        for (int i = 0; i < size; ++i) {
            data.add(renderInfos.get(i).getCustomAttribute("model"));
        }
        this.mOperations.add(new Operation(6, index, -1, count, data, null));
        this.mNumChanges += count;
    }

    public void move(int fromPosition, int toPosition) {
        RenderInfo renderInfo = this.mRenderInfos.remove(fromPosition);
        Object data = renderInfo.getCustomAttribute("model");
        this.mOperations.add(new Operation(3, fromPosition, toPosition, data, data));
        ++this.mNumChanges;
        this.mRenderInfos.add(toPosition, renderInfo);
    }

    public void notifyChangeSetComplete(boolean isDataChanged, ChangeSetCompleteCallback changeSetCompleteCallback) {
        this.mWasNotifyChangeSetCompleteCalledWithChangedData = isDataChanged;
        changeSetCompleteCallback.onDataBound();
        changeSetCompleteCallback.onDataRendered(false, 0L);
    }

    public void requestFocus(int index) {
        this.mFocusTo = index;
    }

    public void requestSmoothFocus(int index, int offset, SmoothScrollAlignmentType type) {
        this.requestFocus(index);
    }

    public void requestFocusWithOffset(int index, int offset) {
        this.mFocusTo = index;
        this.mFocusToOffset = offset;
    }

    public void requestSmoothFocus(Object id, int offset, SmoothScrollAlignmentType type) {
    }

    public void requestFocusWithOffset(Object id, int offset) {
    }

    public boolean supportsBackgroundChangeSets() {
        return false;
    }

    public void changeConfig(SectionTree.Target.DynamicConfig dynamicConfig) {
    }

    public void clear() {
        this.mOperations.clear();
        this.mNumChanges = 0;
        this.mWasNotifyChangeSetCompleteCalledWithChangedData = false;
    }

    public int getFocusedTo() {
        return this.mFocusTo;
    }

    public int getFocusedToOffset() {
        return this.mFocusToOffset;
    }

    public static class Operation {
        public final int mOp;
        public final int mIndex;
        public final int mToIndex;
        public final int mRangeCount;
        @Nullable
        public List<?> mPrevData;
        @Nullable
        public List<?> mNewData;

        Operation(int op, int index, @Nullable Object prevData, @Nullable Object newData) {
            this(op, index, -1, prevData, newData);
        }

        Operation(int op, int index, int toIndex, @Nullable Object prevData, @Nullable Object newData) {
            this(op, index, toIndex, 1, prevData != null ? Collections.singletonList(prevData) : null, newData != null ? Collections.singletonList(newData) : null);
        }

        Operation(int op, int index, int toIndex, int rangeCount, @Nullable List<Object> prevData, @Nullable List<Object> newData) {
            this.mOp = op;
            this.mIndex = index;
            this.mToIndex = toIndex;
            this.mRangeCount = rangeCount;
            this.mPrevData = prevData;
            this.mNewData = newData;
        }
    }
}

