/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.specmodels;

import com.facebook.litho.specmodels.internal.ImmutableList;
import com.facebook.litho.specmodels.model.MethodParamModel;
import com.facebook.litho.specmodels.model.TypeSpec;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.assertj.core.util.Lists;

@Immutable
public class MockMethodParamModel
implements MethodParamModel {
    private final TypeSpec mTypeSpec;
    private final String mName;
    private final List<Annotation> mAnnotations;
    private final List<AnnotationSpec> mExternalAnnotations;
    private final Object mRepresentedObject;

    public MockMethodParamModel(TypeSpec typeSpec, String name, List<Annotation> annotations, List<AnnotationSpec> externalAnnotations, Object representedObject) {
        this.mTypeSpec = typeSpec;
        this.mName = name;
        this.mAnnotations = annotations;
        this.mExternalAnnotations = externalAnnotations;
        this.mRepresentedObject = representedObject;
    }

    public TypeSpec getTypeSpec() {
        return this.mTypeSpec;
    }

    public TypeName getTypeName() {
        return this.mTypeSpec.getTypeName();
    }

    public String getName() {
        return this.mName;
    }

    public List<Annotation> getAnnotations() {
        return this.mAnnotations;
    }

    public List<AnnotationSpec> getExternalAnnotations() {
        return this.mExternalAnnotations;
    }

    public Object getRepresentedObject() {
        return this.mRepresentedObject;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TypeName mType;
        private String mName;
        private List<Class<? extends Annotation>> mAnnotations = ImmutableList.of((Object[])new Class[0]);
        private List<AnnotationSpec> mExternalAnnotations = ImmutableList.of((Object[])new AnnotationSpec[0]);
        private Object mRepresentedObject;

        public Builder type(TypeName type) {
            this.mType = type;
            return this;
        }

        public Builder name(String name) {
            this.mName = name;
            return this;
        }

        public Builder annotations(List<Class<? extends Annotation>> annotations) {
            this.mAnnotations = annotations;
            return this;
        }

        public Builder annotations(Class<? extends Annotation> ... annotations) {
            this.mAnnotations = Lists.newArrayList((Object[])annotations);
            return this;
        }

        public Builder externalAnnotations(AnnotationSpec ... externalAnnotations) {
            this.mExternalAnnotations = Lists.newArrayList((Object[])externalAnnotations);
            return this;
        }

        public Builder externalAnnotations(List<AnnotationSpec> externalAnnotations) {
            this.mExternalAnnotations = externalAnnotations;
            return this;
        }

        public Builder representedObject(Object representedObject) {
            this.mRepresentedObject = representedObject;
            return this;
        }

        public MockMethodParamModel build() {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>(this.mAnnotations.size());
            for (final Class<? extends Annotation> annotation : this.mAnnotations) {
                annotations.add(new Annotation(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return annotation;
                    }
                });
            }
            return new MockMethodParamModel(new TypeSpec(this.mType), this.mName, annotations, this.mExternalAnnotations, this.mRepresentedObject);
        }
    }
}

