/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.specmodels;

import com.facebook.litho.specmodels.internal.ImmutableList;
import com.facebook.litho.specmodels.internal.RunMode;
import com.facebook.litho.specmodels.model.BuilderMethodModel;
import com.facebook.litho.specmodels.model.CachedValueParamModel;
import com.facebook.litho.specmodels.model.DelegateMethod;
import com.facebook.litho.specmodels.model.DependencyInjectionHelper;
import com.facebook.litho.specmodels.model.EventDeclarationModel;
import com.facebook.litho.specmodels.model.EventMethod;
import com.facebook.litho.specmodels.model.FieldModel;
import com.facebook.litho.specmodels.model.HasEnclosedSpecModel;
import com.facebook.litho.specmodels.model.HasPureRender;
import com.facebook.litho.specmodels.model.InjectPropModel;
import com.facebook.litho.specmodels.model.InterStageInputParamModel;
import com.facebook.litho.specmodels.model.PrepareInterStageInputParamModel;
import com.facebook.litho.specmodels.model.PropDefaultModel;
import com.facebook.litho.specmodels.model.PropJavadocModel;
import com.facebook.litho.specmodels.model.PropModel;
import com.facebook.litho.specmodels.model.RenderDataDiffModel;
import com.facebook.litho.specmodels.model.SpecElementType;
import com.facebook.litho.specmodels.model.SpecMethodModel;
import com.facebook.litho.specmodels.model.SpecModel;
import com.facebook.litho.specmodels.model.SpecModelValidationError;
import com.facebook.litho.specmodels.model.StateParamModel;
import com.facebook.litho.specmodels.model.TagModel;
import com.facebook.litho.specmodels.model.TreePropModel;
import com.facebook.litho.specmodels.model.UpdateStateMethod;
import com.facebook.litho.specmodels.model.WorkingRangeMethodModel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MockSpecModel
implements SpecModel,
HasPureRender,
HasEnclosedSpecModel {
    private final String mSpecName;
    private final ClassName mSpecTypeName;
    private final String mComponentName;
    private final TypeName mComponentTypeName;
    private final ClassName mComponentClass;
    private final ImmutableList<SpecMethodModel<DelegateMethod, Void>> mDelegateMethods;
    private final ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> mEventMethods;
    private final ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> mTriggerMethods;
    @Nullable
    private final SpecMethodModel<EventMethod, Void> mWorkingRangeRegisterMethod;
    private final ImmutableList<WorkingRangeMethodModel> mWorkingRangeMethods;
    private final ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> mUpdateStateMethods;
    private final ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> mUpdateStateWithTransitionMethods;
    private final ImmutableList<PropModel> mProps;
    private final ImmutableList<PropModel> mRawProps;
    private final ImmutableList<InjectPropModel> mRawInjectProps;
    private final ImmutableList<InjectPropModel> mInjectProps;
    private final ImmutableList<PropDefaultModel> mPropDefaults;
    private final ImmutableList<TypeVariableName> mTypeVariables;
    private final ImmutableList<StateParamModel> mStateValues;
    private final ImmutableList<CachedValueParamModel> mCachedValues;
    private final ImmutableList<InterStageInputParamModel> mInterStageInputs;
    private final ImmutableList<TreePropModel> mTreeProps;
    private final ImmutableList<EventDeclarationModel> mEventDeclarations;
    private final ImmutableList<BuilderMethodModel> mImplicitBuilderMethods;
    private final ImmutableList<RenderDataDiffModel> mDiffs;
    private final String mClassJavadoc;
    private final ImmutableList<PropJavadocModel> mPropJavadocs;
    private final boolean mIsPublic;
    private final boolean mHasInjectedDependencies;
    @Nullable
    private final DependencyInjectionHelper mDependencyInjectionHelper;
    private final Object mRepresentedObject;
    private final TypeSpec mGeneratedTypeSpec;
    private final ClassName mContextClass;
    private final ClassName mStateContainerClass;
    private final ClassName mTransitionClass;
    private final ClassName mTransitionContainerClass;
    private final boolean mHasDeepCopy;
    private final boolean mShouldCheckIdInIsEquivalentToMethod;
    private final String mScopeMethodName;
    private final boolean mIsStylingSupported;
    private final List<SpecModelValidationError> mSpecModelValidationErrors;
    private final ImmutableList<AnnotationSpec> mClassAnnotations;
    private final ImmutableList<TagModel> mTags;
    private final SpecElementType mSpecElementType;
    private final boolean mIsPureRender;
    private final SpecModel mEnclosedSpecModel;

    private MockSpecModel(String specName, ClassName specTypeName, String componentName, TypeName componentTypeName, ClassName componentClass, ImmutableList<SpecMethodModel<DelegateMethod, Void>> delegateMethods, ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> eventMethods, ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> triggerMethods, SpecMethodModel<EventMethod, Void> workingRangeRegisterMethod, ImmutableList<WorkingRangeMethodModel> workingRangeMethods, ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> updateStateMethods, ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> updateStateWithTransitionMethods, ImmutableList<PropModel> rawProps, ImmutableList<PropModel> props, ImmutableList<InjectPropModel> rawInjectProps, ImmutableList<InjectPropModel> injectProps, ImmutableList<PropDefaultModel> propDefaults, ImmutableList<TypeVariableName> typeVariables, ImmutableList<StateParamModel> stateValues, ImmutableList<CachedValueParamModel> cachedValues, ImmutableList<InterStageInputParamModel> interStageInputs, ImmutableList<TreePropModel> treeProps, ImmutableList<EventDeclarationModel> eventDeclarations, ImmutableList<BuilderMethodModel> implicitBuilderMethods, ImmutableList<RenderDataDiffModel> diffs, String classJavadoc, ImmutableList<PropJavadocModel> propJavadocs, boolean isPublic, boolean hasInjectedDependencies, @Nullable DependencyInjectionHelper dependencyInjectionHelper, Object representedObject, TypeSpec generatedTypeSpec, ClassName contextClass, ClassName stateContainerClass, ClassName transitionClass, ClassName transitionContainerClass, boolean hasDeepCopy, boolean shouldCheckIdInIsEquivalentToMethod, String scopeMethodName, boolean isStylingSupported, List<SpecModelValidationError> specModelValidationErrors, ImmutableList<AnnotationSpec> classAnnotations, ImmutableList<TagModel> tags, SpecElementType specElementType, boolean isPureRender, SpecModel enclosedSpecModel) {
        this.mSpecName = specName;
        this.mSpecTypeName = specTypeName;
        this.mComponentName = componentName;
        this.mComponentTypeName = componentTypeName;
        this.mComponentClass = componentClass;
        this.mDelegateMethods = delegateMethods;
        this.mEventMethods = eventMethods;
        this.mTriggerMethods = triggerMethods;
        this.mWorkingRangeRegisterMethod = workingRangeRegisterMethod;
        this.mWorkingRangeMethods = workingRangeMethods;
        this.mUpdateStateMethods = updateStateMethods;
        this.mUpdateStateWithTransitionMethods = updateStateWithTransitionMethods;
        this.mRawProps = rawProps;
        this.mProps = props;
        this.mRawInjectProps = rawInjectProps;
        this.mInjectProps = injectProps;
        this.mPropDefaults = propDefaults;
        this.mTypeVariables = typeVariables;
        this.mStateValues = stateValues;
        this.mCachedValues = cachedValues;
        this.mInterStageInputs = interStageInputs;
        this.mTreeProps = treeProps;
        this.mEventDeclarations = eventDeclarations;
        this.mImplicitBuilderMethods = implicitBuilderMethods;
        this.mDiffs = diffs;
        this.mClassJavadoc = classJavadoc;
        this.mPropJavadocs = propJavadocs;
        this.mIsPublic = isPublic;
        this.mHasInjectedDependencies = hasInjectedDependencies;
        this.mDependencyInjectionHelper = dependencyInjectionHelper;
        this.mRepresentedObject = representedObject;
        this.mGeneratedTypeSpec = generatedTypeSpec;
        this.mContextClass = contextClass;
        this.mStateContainerClass = stateContainerClass;
        this.mTransitionClass = transitionClass;
        this.mTransitionContainerClass = transitionContainerClass;
        this.mHasDeepCopy = hasDeepCopy;
        this.mShouldCheckIdInIsEquivalentToMethod = shouldCheckIdInIsEquivalentToMethod;
        this.mScopeMethodName = scopeMethodName;
        this.mIsStylingSupported = isStylingSupported;
        this.mSpecModelValidationErrors = specModelValidationErrors;
        this.mClassAnnotations = classAnnotations;
        this.mTags = tags;
        this.mSpecElementType = specElementType;
        this.mIsPureRender = isPureRender;
        this.mEnclosedSpecModel = enclosedSpecModel;
    }

    public String getSpecName() {
        return this.mSpecName;
    }

    public ClassName getSpecTypeName() {
        return this.mSpecTypeName;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public TypeName getComponentTypeName() {
        return this.mComponentTypeName;
    }

    public ImmutableList<FieldModel> getFields() {
        throw new RuntimeException("Mock was not provided with fields");
    }

    public ImmutableList<SpecMethodModel<DelegateMethod, Void>> getDelegateMethods() {
        return this.mDelegateMethods;
    }

    public ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> getEventMethods() {
        return this.mEventMethods;
    }

    public ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> getTriggerMethods() {
        return this.mTriggerMethods;
    }

    @Nullable
    public SpecMethodModel<EventMethod, Void> getWorkingRangeRegisterMethod() {
        return this.mWorkingRangeRegisterMethod;
    }

    public ImmutableList<WorkingRangeMethodModel> getWorkingRangeMethods() {
        return this.mWorkingRangeMethods;
    }

    public ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> getUpdateStateMethods() {
        return this.mUpdateStateMethods;
    }

    public ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> getUpdateStateWithTransitionMethods() {
        return this.mUpdateStateWithTransitionMethods;
    }

    public ImmutableList<PropModel> getRawProps() {
        return this.mRawProps;
    }

    public ImmutableList<PropModel> getProps() {
        return this.mProps;
    }

    public ImmutableList<InjectPropModel> getRawInjectProps() {
        return this.mRawInjectProps;
    }

    public ImmutableList<InjectPropModel> getInjectProps() {
        return this.mInjectProps;
    }

    public ImmutableList<PropDefaultModel> getPropDefaults() {
        return this.mPropDefaults;
    }

    public ImmutableList<TypeVariableName> getTypeVariables() {
        return this.mTypeVariables;
    }

    public ImmutableList<StateParamModel> getStateValues() {
        return this.mStateValues;
    }

    public ImmutableList<CachedValueParamModel> getCachedValues() {
        return this.mCachedValues;
    }

    public ImmutableList<InterStageInputParamModel> getInterStageInputs() {
        return this.mInterStageInputs;
    }

    public ImmutableList<PrepareInterStageInputParamModel> getPrepareInterStageInputs() {
        return ImmutableList.of((Object[])new PrepareInterStageInputParamModel[0]);
    }

    public ImmutableList<TreePropModel> getTreeProps() {
        return this.mTreeProps;
    }

    public ImmutableList<EventDeclarationModel> getEventDeclarations() {
        return this.mEventDeclarations;
    }

    public ImmutableList<BuilderMethodModel> getExtraBuilderMethods() {
        return this.mImplicitBuilderMethods;
    }

    public ImmutableList<RenderDataDiffModel> getRenderDataDiffs() {
        return this.mDiffs;
    }

    public ImmutableList<AnnotationSpec> getClassAnnotations() {
        return this.mClassAnnotations;
    }

    public ImmutableList<TagModel> getTags() {
        return this.mTags;
    }

    public String getClassJavadoc() {
        return this.mClassJavadoc;
    }

    public ImmutableList<PropJavadocModel> getPropJavadocs() {
        return this.mPropJavadocs;
    }

    public boolean isPublic() {
        return this.mIsPublic;
    }

    public ClassName getContextClass() {
        return this.mContextClass;
    }

    public ClassName getComponentClass() {
        return this.mComponentClass;
    }

    public ClassName getStateContainerClass() {
        return this.mStateContainerClass;
    }

    public ClassName getTransitionClass() {
        return this.mTransitionClass;
    }

    public ClassName getTransitionContainerClass() {
        return this.mTransitionContainerClass;
    }

    public String getScopeMethodName() {
        return this.mScopeMethodName;
    }

    public boolean isStylingSupported() {
        return this.mIsStylingSupported;
    }

    public boolean hasInjectedDependencies() {
        return this.mHasInjectedDependencies;
    }

    public boolean shouldCheckIdInIsEquivalentToMethod() {
        return this.mShouldCheckIdInIsEquivalentToMethod;
    }

    public boolean hasDeepCopy() {
        return this.mHasDeepCopy;
    }

    public boolean shouldGenerateHasState() {
        return true;
    }

    public boolean shouldGenerateTransferState() {
        return true;
    }

    public boolean shouldGenerateCopyMethod() {
        return true;
    }

    public boolean isStateful() {
        return this.mEnclosedSpecModel.isStateful();
    }

    @Nullable
    public DependencyInjectionHelper getDependencyInjectionHelper() {
        return this.mDependencyInjectionHelper;
    }

    public SpecElementType getSpecElementType() {
        return this.mSpecElementType;
    }

    public Object getRepresentedObject() {
        return this.mRepresentedObject;
    }

    public List<SpecModelValidationError> validate(EnumSet<RunMode> runMode) {
        return this.mSpecModelValidationErrors;
    }

    public TypeSpec generate(EnumSet<RunMode> runMode) {
        return this.mGeneratedTypeSpec;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SpecModel getEnclosedSpecModel() {
        return this.mEnclosedSpecModel;
    }

    public boolean isPureRender() {
        return this.mIsPureRender;
    }

    public boolean shouldGenerateIsEquivalentTo() {
        return false;
    }

    public static class Builder {
        private String mSpecName;
        private ClassName mSpecTypeName;
        private String mComponentName;
        private TypeName mComponentTypeName;
        private ClassName mComponentClass;
        private ImmutableList<SpecMethodModel<DelegateMethod, Void>> mDelegateMethods = ImmutableList.of((Object[])new SpecMethodModel[0]);
        private ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> mEventMethods = ImmutableList.of((Object[])new SpecMethodModel[0]);
        private ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> mTriggerMethods = ImmutableList.of((Object[])new SpecMethodModel[0]);
        private SpecMethodModel<EventMethod, Void> mWorkingRangeRegisterMethod;
        private ImmutableList<WorkingRangeMethodModel> mWorkingRangeMethods = ImmutableList.of((Object[])new WorkingRangeMethodModel[0]);
        private ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> mUpdateStateMethods = ImmutableList.of((Object[])new SpecMethodModel[0]);
        private ImmutableList<PropModel> mRawProps = ImmutableList.of((Object[])new PropModel[0]);
        private ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> mUpdateStateWithTransitionMethods = ImmutableList.of((Object[])new SpecMethodModel[0]);
        private ImmutableList<PropModel> mProps = ImmutableList.of((Object[])new PropModel[0]);
        private ImmutableList<InjectPropModel> mRawInjectProps = ImmutableList.of((Object[])new InjectPropModel[0]);
        private ImmutableList<InjectPropModel> mInjectProps = ImmutableList.of((Object[])new InjectPropModel[0]);
        private ImmutableList<PropDefaultModel> mPropDefaults = ImmutableList.of((Object[])new PropDefaultModel[0]);
        private ImmutableList<TypeVariableName> mTypeVariables = ImmutableList.of((Object[])new TypeVariableName[0]);
        private ImmutableList<StateParamModel> mStateValues = ImmutableList.of((Object[])new StateParamModel[0]);
        private ImmutableList<CachedValueParamModel> mCachedValues = ImmutableList.of((Object[])new CachedValueParamModel[0]);
        private ImmutableList<InterStageInputParamModel> mInterStageInputs = ImmutableList.of((Object[])new InterStageInputParamModel[0]);
        private ImmutableList<TreePropModel> mTreeProps = ImmutableList.of((Object[])new TreePropModel[0]);
        private ImmutableList<EventDeclarationModel> mEventDeclarations = ImmutableList.of((Object[])new EventDeclarationModel[0]);
        private ImmutableList<BuilderMethodModel> mImplicitBuilderMethods = ImmutableList.of((Object[])new BuilderMethodModel[0]);
        private ImmutableList<RenderDataDiffModel> mDiffs = ImmutableList.of((Object[])new RenderDataDiffModel[0]);
        private String mClassJavadoc;
        private ImmutableList<PropJavadocModel> mPropJavadocs = ImmutableList.of((Object[])new PropJavadocModel[0]);
        private boolean mIsPublic;
        private boolean mHasInjectedDependencies;
        private DependencyInjectionHelper mDependencyInjectionHelper;
        private Object mRepresentedObject;
        private TypeSpec mGeneratedTypeSpec;
        private ClassName mContextClass;
        private ClassName mStateContainerClass;
        private ClassName mTransitionClass;
        private ClassName mTransitionContainerClass;
        private boolean mHasDeepCopy;
        private boolean mShouldCheckIdInIsEquivalentToMethod;
        private String mScopeMethodName;
        private boolean mIsStylingSupported;
        private List<SpecModelValidationError> mSpecModelValidationErrors = ImmutableList.of((Object[])new SpecModelValidationError[0]);
        private ImmutableList<AnnotationSpec> mClassAnnotations;
        private ImmutableList<TagModel> mTags = ImmutableList.of((Object[])new TagModel[0]);
        private SpecElementType mSpecElementType;
        private boolean mIsPureRender;
        private SpecModel mEnclosedSpecModel;

        public Builder specName(String specName) {
            this.mSpecName = specName;
            return this;
        }

        public Builder specTypeName(ClassName specTypeName) {
            this.mSpecTypeName = specTypeName;
            return this;
        }

        public Builder componentName(String componentName) {
            this.mComponentName = componentName;
            return this;
        }

        public Builder componentTypeName(TypeName componentTypeName) {
            this.mComponentTypeName = componentTypeName;
            return this;
        }

        public Builder componentClass(ClassName componentClass) {
            this.mComponentClass = componentClass;
            return this;
        }

        public Builder delegateMethods(ImmutableList<SpecMethodModel<DelegateMethod, Void>> delegateMethods) {
            this.mDelegateMethods = delegateMethods;
            return this;
        }

        public Builder eventMethods(ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> eventMethods) {
            this.mEventMethods = eventMethods;
            return this;
        }

        public Builder triggerMethods(ImmutableList<SpecMethodModel<EventMethod, EventDeclarationModel>> triggerMethods) {
            this.mTriggerMethods = triggerMethods;
            return this;
        }

        public Builder workingRangeRegisterMethod(SpecMethodModel<EventMethod, Void> workingRangeRegisterMethod) {
            this.mWorkingRangeRegisterMethod = workingRangeRegisterMethod;
            return this;
        }

        public Builder workingRangeMethods(ImmutableList<WorkingRangeMethodModel> workingRangeMethods) {
            this.mWorkingRangeMethods = workingRangeMethods;
            return this;
        }

        public Builder updateStateMethods(ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> updateStateMethods) {
            this.mUpdateStateMethods = updateStateMethods;
            return this;
        }

        public Builder updateStateWithTransitionMethods(ImmutableList<SpecMethodModel<UpdateStateMethod, Void>> updateStateWithTransitionMethods) {
            this.mUpdateStateWithTransitionMethods = updateStateWithTransitionMethods;
            return this;
        }

        public Builder rawProps(ImmutableList<PropModel> rawProps) {
            this.mRawProps = rawProps;
            return this;
        }

        public Builder props(ImmutableList<PropModel> props) {
            this.mProps = props;
            return this;
        }

        public Builder rawInjectProps(ImmutableList<InjectPropModel> rawInjectProps) {
            this.mRawInjectProps = rawInjectProps;
            return this;
        }

        public Builder injectProps(ImmutableList<InjectPropModel> injectProps) {
            this.mInjectProps = injectProps;
            return this;
        }

        public Builder propDefaults(ImmutableList<PropDefaultModel> propDefaults) {
            this.mPropDefaults = propDefaults;
            return this;
        }

        public Builder typeVariables(ImmutableList<TypeVariableName> typeVariables) {
            this.mTypeVariables = typeVariables;
            return this;
        }

        public Builder stateValues(ImmutableList<StateParamModel> stateValues) {
            this.mStateValues = stateValues;
            return this;
        }

        public Builder cachedValues(ImmutableList<CachedValueParamModel> cachedValues) {
            this.mCachedValues = cachedValues;
            return this;
        }

        public Builder interStageInputs(ImmutableList<InterStageInputParamModel> interStageInputs) {
            this.mInterStageInputs = interStageInputs;
            return this;
        }

        public Builder treeProps(ImmutableList<TreePropModel> treeProps) {
            this.mTreeProps = treeProps;
            return this;
        }

        public Builder eventDeclarations(ImmutableList<EventDeclarationModel> eventDeclarations) {
            this.mEventDeclarations = eventDeclarations;
            return this;
        }

        public Builder implicitBuilderMethods(ImmutableList<BuilderMethodModel> implicitBuilderMethods) {
            this.mImplicitBuilderMethods = implicitBuilderMethods;
            return this;
        }

        public Builder diffs(ImmutableList<RenderDataDiffModel> diffs) {
            this.mDiffs = diffs;
            return this;
        }

        public Builder classJavadoc(String classJavadoc) {
            this.mClassJavadoc = classJavadoc;
            return this;
        }

        public Builder propJavadocs(ImmutableList<PropJavadocModel> propJavadocs) {
            this.mPropJavadocs = propJavadocs;
            return this;
        }

        public Builder isPublic(boolean isPublic) {
            this.mIsPublic = isPublic;
            return this;
        }

        public Builder hasInjectedDependencies(boolean hasInjectedDependencies) {
            this.mHasInjectedDependencies = hasInjectedDependencies;
            return this;
        }

        public Builder dependencyInjectionHelper(DependencyInjectionHelper dependencyInjectionHelper) {
            this.mDependencyInjectionHelper = dependencyInjectionHelper;
            return this;
        }

        public Builder representedObject(Object representedObject) {
            this.mRepresentedObject = representedObject;
            return this;
        }

        public Builder generatedTypeSpec(TypeSpec generatedTypeSpec) {
            this.mGeneratedTypeSpec = generatedTypeSpec;
            return this;
        }

        public Builder contextClass(ClassName contextClass) {
            this.mContextClass = contextClass;
            return this;
        }

        public Builder stateContainerClass(ClassName stateContainerClass) {
            this.mStateContainerClass = stateContainerClass;
            return this;
        }

        public Builder transitionClass(ClassName transitionClass) {
            this.mTransitionClass = transitionClass;
            return this;
        }

        public Builder transitionContainerClass(ClassName transitionContainerClass) {
            this.mTransitionContainerClass = transitionContainerClass;
            return this;
        }

        public Builder hasDeepCopy(boolean hasDeepCopy) {
            this.mHasDeepCopy = hasDeepCopy;
            return this;
        }

        public Builder shouldCheckIdInIsEquivalentToMethod(boolean shouldCheckIdInIsEquivalentToMethod) {
            this.mShouldCheckIdInIsEquivalentToMethod = shouldCheckIdInIsEquivalentToMethod;
            return this;
        }

        public Builder updateStateInterface(TypeName updateStateInterface) {
            return this;
        }

        public Builder scopeMethodName(String scopeMethodName) {
            this.mScopeMethodName = scopeMethodName;
            return this;
        }

        public Builder isStylingSupported(boolean isStylingSupported) {
            this.mIsStylingSupported = isStylingSupported;
            return this;
        }

        public Builder specModelValidationErrors(List<SpecModelValidationError> specModelValidationErrors) {
            this.mSpecModelValidationErrors = specModelValidationErrors;
            return this;
        }

        public Builder classAnnotations(ImmutableList<AnnotationSpec> classAnnotations) {
            this.mClassAnnotations = classAnnotations;
            return this;
        }

        public Builder tags(ImmutableList<TagModel> tags) {
            this.mTags = tags;
            return this;
        }

        public Builder specElementType(SpecElementType specElementType) {
            this.mSpecElementType = specElementType;
            return this;
        }

        public Builder isPureRender(boolean isPureRender) {
            this.mIsPureRender = isPureRender;
            return this;
        }

        public Builder enclosedSpecModel(SpecModel enclosedSpecModel) {
            this.mEnclosedSpecModel = enclosedSpecModel;
            return this;
        }

        public MockSpecModel build() {
            return new MockSpecModel(this.mSpecName, this.mSpecTypeName, this.mComponentName, this.mComponentTypeName, this.mComponentClass, this.mDelegateMethods, this.mEventMethods, this.mTriggerMethods, this.mWorkingRangeRegisterMethod, this.mWorkingRangeMethods, this.mUpdateStateMethods, this.mUpdateStateWithTransitionMethods, this.mRawProps, this.mProps, this.mRawInjectProps, this.mInjectProps, this.mPropDefaults, this.mTypeVariables, this.mStateValues, this.mCachedValues, this.mInterStageInputs, this.mTreeProps, this.mEventDeclarations, this.mImplicitBuilderMethods, this.mDiffs, this.mClassJavadoc, this.mPropJavadocs, this.mIsPublic, this.mHasInjectedDependencies, this.mDependencyInjectionHelper, this.mRepresentedObject, this.mGeneratedTypeSpec, this.mContextClass, this.mStateContainerClass, this.mTransitionClass, this.mTransitionContainerClass, this.mHasDeepCopy, this.mShouldCheckIdInIsEquivalentToMethod, this.mScopeMethodName, this.mIsStylingSupported, this.mSpecModelValidationErrors, this.mClassAnnotations, this.mTags, this.mSpecElementType, this.mIsPureRender, this.mEnclosedSpecModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.mIsPublic == builder.mIsPublic && this.mHasInjectedDependencies == builder.mHasInjectedDependencies && this.mHasDeepCopy == builder.mHasDeepCopy && this.mShouldCheckIdInIsEquivalentToMethod == builder.mShouldCheckIdInIsEquivalentToMethod && this.mIsStylingSupported == builder.mIsStylingSupported && Objects.equals(this.mSpecName, builder.mSpecName) && Objects.equals(this.mSpecTypeName, builder.mSpecTypeName) && Objects.equals(this.mComponentName, builder.mComponentName) && Objects.equals(this.mComponentTypeName, builder.mComponentTypeName) && Objects.equals(this.mComponentClass, builder.mComponentClass) && Objects.equals(this.mDelegateMethods, builder.mDelegateMethods) && Objects.equals(this.mEventMethods, builder.mEventMethods) && Objects.equals(this.mTriggerMethods, builder.mTriggerMethods) && Objects.equals(this.mWorkingRangeRegisterMethod, builder.mWorkingRangeRegisterMethod) && Objects.equals(this.mWorkingRangeMethods, builder.mWorkingRangeMethods) && Objects.equals(this.mUpdateStateMethods, builder.mUpdateStateMethods) && Objects.equals(this.mUpdateStateWithTransitionMethods, builder.mUpdateStateWithTransitionMethods) && Objects.equals(this.mRawProps, builder.mRawProps) && Objects.equals(this.mProps, builder.mProps) && Objects.equals(this.mPropDefaults, builder.mPropDefaults) && Objects.equals(this.mTypeVariables, builder.mTypeVariables) && Objects.equals(this.mStateValues, builder.mStateValues) && Objects.equals(this.mCachedValues, builder.mCachedValues) && Objects.equals(this.mInterStageInputs, builder.mInterStageInputs) && Objects.equals(this.mTreeProps, builder.mTreeProps) && Objects.equals(this.mEventDeclarations, builder.mEventDeclarations) && Objects.equals(this.mImplicitBuilderMethods, builder.mImplicitBuilderMethods) && Objects.equals(this.mDiffs, builder.mDiffs) && Objects.equals(this.mClassJavadoc, builder.mClassJavadoc) && Objects.equals(this.mPropJavadocs, builder.mPropJavadocs) && Objects.equals(this.mDependencyInjectionHelper, builder.mDependencyInjectionHelper) && Objects.equals(this.mRepresentedObject, builder.mRepresentedObject) && Objects.equals(this.mGeneratedTypeSpec, builder.mGeneratedTypeSpec) && Objects.equals(this.mContextClass, builder.mContextClass) && Objects.equals(this.mStateContainerClass, builder.mStateContainerClass) && Objects.equals(this.mTransitionClass, builder.mTransitionClass) && Objects.equals(this.mTransitionContainerClass, builder.mTransitionContainerClass) && Objects.equals(this.mScopeMethodName, builder.mScopeMethodName) && Objects.equals(this.mSpecModelValidationErrors, builder.mSpecModelValidationErrors) && Objects.equals(this.mClassAnnotations, builder.mClassAnnotations) && Objects.equals(this.mTags, builder.mTags) && Objects.equals(this.mSpecElementType, builder.mSpecElementType) && Objects.equals(this.mIsPureRender, builder.mIsPureRender) && Objects.equals(this.mEnclosedSpecModel, builder.mEnclosedSpecModel);
        }

        public int hashCode() {
            return Objects.hash(this.mSpecName, this.mSpecTypeName, this.mComponentName, this.mComponentTypeName, this.mComponentClass, this.mDelegateMethods, this.mEventMethods, this.mTriggerMethods, this.mWorkingRangeRegisterMethod, this.mWorkingRangeMethods, this.mUpdateStateMethods, this.mUpdateStateWithTransitionMethods, this.mProps, this.mPropDefaults, this.mTypeVariables, this.mStateValues, this.mCachedValues, this.mInterStageInputs, this.mTreeProps, this.mEventDeclarations, this.mImplicitBuilderMethods, this.mDiffs, this.mClassJavadoc, this.mPropJavadocs, this.mIsPublic, this.mHasInjectedDependencies, this.mDependencyInjectionHelper, this.mRepresentedObject, this.mGeneratedTypeSpec, this.mContextClass, this.mStateContainerClass, this.mTransitionClass, this.mTransitionContainerClass, this.mHasDeepCopy, this.mShouldCheckIdInIsEquivalentToMethod, this.mScopeMethodName, this.mIsStylingSupported, this.mSpecModelValidationErrors, this.mClassAnnotations, this.mTags, this.mSpecElementType, this.mIsPureRender, this.mEnclosedSpecModel);
        }
    }
}

