/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.state;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ErrorComponentReceiver;
import com.facebook.litho.LithoTree;
import com.facebook.litho.LithoTreeLifecycleProvider;
import com.facebook.litho.LithoView;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.MountedViewReference;
import com.facebook.litho.testing.Whitebox;
import com.facebook.litho.testing.helper.ComponentTestHelper;
import org.robolectric.shadows.ShadowLooper;

public final class StateUpdatesTestHelper {
    private StateUpdatesTestHelper() {
    }

    public static LithoView getViewAfterStateUpdate(ComponentContext context, Component component, StateUpdater stateUpdater, ShadowLooper layoutThreadShadowLooper) {
        return StateUpdatesTestHelper.getViewAfterStateUpdate(context, component, stateUpdater, layoutThreadShadowLooper, false, false);
    }

    public static LithoView getViewAfterStateUpdate(ComponentContext context, Component component) {
        return StateUpdatesTestHelper.getViewAfterStateUpdate(context, component, new StateUpdater(){

            @Override
            public void performStateUpdate(ComponentContext ignored) {
            }
        }, ComponentTestHelper.getDefaultLayoutThreadShadowLooper(), false, false);
    }

    public static LithoView getViewAfterStateUpdate(ComponentContext context, Component component, StateUpdater stateUpdater) {
        return StateUpdatesTestHelper.getViewAfterStateUpdate(context, component, stateUpdater, ComponentTestHelper.getDefaultThreadShadowLoopers(), false, false);
    }

    public static LithoView getViewAfterStateUpdate(ComponentContext context, Component component, StateUpdater stateUpdater, boolean incrementalMountEnabled, boolean visibilityProcessingEnabled) {
        return StateUpdatesTestHelper.getViewAfterStateUpdate(context, component, stateUpdater, ComponentTestHelper.getDefaultThreadShadowLoopers(), incrementalMountEnabled, visibilityProcessingEnabled);
    }

    public static LithoView getViewAfterStateUpdate(ComponentContext context, Component component, StateUpdater stateUpdater, ShadowLooper layoutThreadShadowLooper, boolean incrementalMountEnabled, boolean visibilityProcessingEnabled) {
        return StateUpdatesTestHelper.getViewAfterStateUpdate(context, component, stateUpdater, new ShadowLooper[]{layoutThreadShadowLooper}, incrementalMountEnabled, visibilityProcessingEnabled);
    }

    public static LithoView getViewAfterStateUpdate(ComponentContext context, Component component, StateUpdater stateUpdater, ShadowLooper[] loopers, boolean incrementalMountEnabled, boolean visibilityProcessingEnabled) {
        Whitebox.invokeMethod(component, "setKey", "bogusKeyForTest");
        ComponentTree componentTree = ComponentTree.create((ComponentContext)context, (Component)component).incrementalMount(incrementalMountEnabled).visibilityProcessing(visibilityProcessingEnabled).layoutDiffing(false).build();
        LithoView lithoView = new LithoView(context);
        ComponentTestHelper.mountComponent(lithoView, componentTree);
        Whitebox.setInternalState(component, "mId", 457282882);
        Whitebox.setInternalState(context, "mGlobalKey", "$bogusKeyForTest");
        Whitebox.setInternalState(context, "mComponentScope", component);
        Whitebox.setInternalState(context, "mLithoTree", new LithoTree((com.facebook.litho.StateUpdater)componentTree, (MountedViewReference)componentTree, (ErrorComponentReceiver)componentTree, (LithoTreeLifecycleProvider)componentTree));
        if (Component.isLayoutSpecWithSizeSpec((Component)component)) {
            Whitebox.setInternalState(context, "isNestedTreeContext", true);
        }
        LithoViewTestHelper.InternalNodeRef rootLayoutNode = LithoViewTestHelper.getRootLayoutRef((LithoView)lithoView);
        stateUpdater.performStateUpdate(context);
        for (ShadowLooper looper : loopers) {
            looper.runToEndOfTasks();
        }
        LithoViewTestHelper.setRootLayoutRef((LithoView)lithoView, (LithoViewTestHelper.InternalNodeRef)rootLayoutNode);
        return ComponentTestHelper.mountComponent(lithoView, componentTree);
    }

    @FunctionalInterface
    public static interface StateUpdater {
        public void performStateUpdate(ComponentContext var1);
    }
}

