/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.subcomponents;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DebugLayoutNode;
import com.facebook.litho.EventHandler;
import com.facebook.litho.LithoView;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.StateContainer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class InspectableComponent {
    private final DebugComponent mComponent;

    private InspectableComponent(DebugComponent component) {
        this.mComponent = component;
    }

    @Nullable
    public static InspectableComponent getRootInstance(LithoView view) {
        DebugComponent rootInstance = DebugComponent.getRootInstance((LithoView)view);
        if (rootInstance == null) {
            return null;
        }
        return new InspectableComponent(rootInstance);
    }

    @Nullable
    public InspectableComponent getNestedInstance(Component component) {
        LinkedList queue = new LinkedList(this.mComponent.getChildComponents());
        while (!queue.isEmpty()) {
            DebugComponent childComponent = (DebugComponent)queue.remove();
            if (childComponent.getComponent() == component) {
                return new InspectableComponent(childComponent);
            }
            queue.addAll(childComponent.getChildComponents());
        }
        return null;
    }

    public String getName() {
        return this.mComponent.getComponent().getClass().getName();
    }

    public String getSimpleName() {
        return this.mComponent.getComponent().getSimpleName();
    }

    public Class getComponentClass() {
        return this.mComponent.getComponent().getClass();
    }

    public List<InspectableComponent> getChildComponents() {
        List debugComponents = this.mComponent.getChildComponents();
        ArrayList<InspectableComponent> res = new ArrayList<InspectableComponent>(debugComponents.size());
        for (DebugComponent debugComponent : debugComponents) {
            res.add(new InspectableComponent(debugComponent));
        }
        return res;
    }

    @Nullable
    public View getMountedView() {
        return this.mComponent.getMountedView();
    }

    @Nullable
    public Drawable getMountedDrawable() {
        return this.mComponent.getMountedDrawable();
    }

    @Nullable
    public LithoView getLithoView() {
        return this.mComponent.getLithoView();
    }

    public Rect getBoundsInLithoView() {
        return this.mComponent.getBoundsInLithoView();
    }

    public Rect getBounds() {
        return this.mComponent.getBounds();
    }

    @Nullable
    public String getTestKey() {
        return this.mComponent.getTestKey();
    }

    @Nullable
    public String getComponentTestKey() {
        return this.mComponent.getComponentTestKey();
    }

    @Nullable
    public Object getComponentTag() {
        return this.mComponent.getComponentTag();
    }

    @Nullable
    public String getTextContent() {
        return this.mComponent.getTextContent();
    }

    @Nullable
    public ComponentHost getComponentHost() {
        return this.mComponent.getComponentHost();
    }

    @Nullable
    public String getKey() {
        return this.mComponent.getKey();
    }

    public Component getComponent() {
        return this.mComponent.getComponent();
    }

    @Nullable
    public Drawable getForeground() {
        DebugLayoutNode layout = this.mComponent.getLayoutNode();
        return layout == null ? null : layout.getForeground();
    }

    @Nullable
    public Drawable getBackground() {
        DebugLayoutNode layout = this.mComponent.getLayoutNode();
        return layout == null ? null : layout.getBackground();
    }

    @Nullable
    public Integer getImportantForAccessibility() {
        DebugLayoutNode layout = this.mComponent.getLayoutNode();
        return layout == null ? null : Integer.valueOf(layout.getImportantForAccessibility());
    }

    public boolean getFocusable() {
        DebugLayoutNode layout = this.mComponent.getLayoutNode();
        return layout == null ? false : layout.getFocusable();
    }

    @Nullable
    public CharSequence getContentDescription() {
        DebugLayoutNode layout = this.mComponent.getLayoutNode();
        return layout == null ? null : layout.getContentDescription();
    }

    @Nullable
    public StateContainer getStateContainer() {
        return this.mComponent.getStateContainer();
    }

    public String getId() {
        return this.mComponent.getGlobalKey();
    }

    @Nullable
    public EventHandler getClickHandler() {
        DebugLayoutNode layout = this.mComponent.getLayoutNode();
        return layout == null ? null : layout.getClickHandler();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InspectableComponent of ");
        sb.append(this.getSimpleName());
        sb.append(" with hierarchy\n");
        sb.append(LithoViewTestHelper.viewToString((LithoView)this.mComponent.getLithoView()));
        return sb.toString();
    }
}

