/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.subcomponents;

import com.facebook.litho.Component;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import org.assertj.core.api.Condition;

public class SubComponent {
    private final Class<? extends Component> mComponentType;
    private final Component mComponent;

    public static SubComponent of(Class<? extends Component> componentType) {
        return new SubComponent(componentType, null);
    }

    public static <T extends Component> SubComponent of(T component) {
        return new SubComponent(component.getClass(), component);
    }

    private SubComponent(Class<? extends Component> componentType, Component component) {
        this.mComponentType = componentType;
        this.mComponent = component;
    }

    public Component getComponent() {
        return this.mComponent;
    }

    public Class<? extends Component> getComponentType() {
        return this.mComponentType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SubComponent)) {
            return false;
        }
        SubComponent that = (SubComponent)o;
        return that.mComponentType.equals(this.mComponentType) && SubComponent.arePropsEqual(that.mComponent, this.mComponent);
    }

    public int hashCode() {
        return this.mComponentType.hashCode();
    }

    public String toString() {
        return this.mComponentType.toString();
    }

    private static boolean arePropsEqual(Component thatComponent, Component thisComponent) {
        return thatComponent == null || thisComponent == null || thatComponent.isEquivalentTo(thisComponent);
    }

    public static Condition<InspectableComponent> legacySubComponent(final SubComponent subComponent) {
        return new Condition<InspectableComponent>(){

            public boolean matches(InspectableComponent value) {
                Component component = value.getComponent();
                return component != null && SubComponent.of(component).equals(subComponent);
            }
        };
    }
}

